/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.util.TextBufferStreamFactory;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.URLPropertyProvider;

public class PropertyFilePropertyProvider
extends URLPropertyProvider {
    private String prefix;
    private boolean loaded;
    private Properties props;

    private void $init$() {
        this.loaded = false;
        this.props = new Properties();
    }

    public PropertyFilePropertyProvider(URL url, String prefix) {
        super(url);
        this.$init$();
        if (prefix != null) {
            if (!(prefix = prefix.trim()).endsWith(".")) {
                prefix = prefix + ".";
            }
            this.prefix = prefix;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getProperties(AntContextImpl context, Map properties, Map ids, Set alreadySeen) {
        URL url = this.getURL();
        if (!alreadySeen.contains(url)) {
            if (!this.loaded) {
                this.loadProperties();
            }
            this.resolveAllProperties(context, this.props);
            for (String string : this.props.keySet()) {
                void var7_7;
                if (this.prefix != null) {
                    String string2 = this.prefix + string;
                }
                if (properties.containsKey(var7_7)) continue;
                String value = this.props.getProperty((String)var7_7);
                properties.put(var7_7, value);
            }
        }
    }

    private void loadProperties() {
        URL url = this.getURL();
        InputStream is = this.getInputStream(url);
        if (is != null) {
            try {
                try {
                    this.props.load(is);
                }
                catch (Exception exception) {}
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe) {}
                }
                this.loaded = true;
            }
        }
    }

    public void firePropertiesChanged() {
        super.firePropertiesChanged();
        this.loaded = false;
        this.props.clear();
    }

    private void resolveAllProperties(AntContextImpl context, Properties props) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this.resolve(context, props, name, new Stack());
        }
    }

    private void resolve(AntContextImpl context, Properties props, String name, Stack propertiesSeen) {
        if (!propertiesSeen.contains(name)) {
            String value = props.getProperty(name);
            propertiesSeen.push(name);
            StringBuffer buffer = new StringBuffer();
            Pattern pattern = Pattern.compile("(?:^|[^\\$])(\\$\\{(.+?)\\})");
            Matcher matcher = pattern.matcher(value);
            int last = 0;
            while (matcher.find()) {
                buffer.append(value.substring(last, matcher.start(1)));
                String property = matcher.group(2);
                String v = context.getProperty(property);
                if (v == null && props.containsKey(property)) {
                    this.resolve(context, props, property, propertiesSeen);
                    v = props.getProperty(property);
                }
                if (v != null) {
                    buffer.append(v);
                } else {
                    buffer.append(matcher.group(1));
                }
                last = matcher.end(1);
            }
            buffer.append(value.substring(last, value.length()));
            props.put(name, buffer.toString());
            propertiesSeen.pop();
        }
    }

    private InputStream getInputStream(URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                TextBuffer buffer = textNode.acquireTextBuffer();
                buffer.readLock();
                try {
                    InputStream inputStream = TextBufferStreamFactory.getInputStream((TextBuffer)buffer);
                    return inputStream;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    buffer.readUnlock();
                    textNode.releaseTextBuffer();
                }
            }
        }
        catch (IllegalAccessException iae) {
        }
        catch (InstantiationException ie) {
            // empty catch block
        }
        return null;
    }
}

