/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.AntHandler;
import oracle.jdevimpl.ant.parser.EnvironmentPropertyProvider;
import oracle.jdevimpl.ant.parser.PropertyFilePropertyProvider;
import org.apache.tools.ant.PathTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PropertyHandler
implements AntHandler {
    public void handleElement(AntContextImpl context, Element element) {
        Attr attr = element.getAttributeNodeNS(null, "name");
        if (attr != null) {
            String name = attr.getValue();
            String value = null;
            attr = element.getAttributeNodeNS(null, "value");
            if (attr != null) {
                value = context.resolveProperties(attr.getValue());
            }
            if (value == null && (attr = element.getAttributeNodeNS(null, "location")) != null) {
                String location = context.resolveProperties(attr.getValue());
                File file = context.resolveFile(location);
                if (file == null) {
                    return;
                }
                value = file.getPath();
            }
            if (value == null && (attr = element.getAttributeNodeNS(null, "refid")) != null) {
                String id = context.resolveProperties(attr.getValue());
                value = context.resolveId(id);
            }
            if (value != null) {
                String id = null;
                attr = element.getAttributeNodeNS(null, "id");
                if (attr != null) {
                    id = attr.getValue();
                    context.addId(id, value);
                }
                context.addProperty(name, value, id);
            }
        } else {
            URL url = null;
            attr = element.getAttributeNodeNS(null, "url");
            if (attr != null) {
                try {
                    String value = context.resolveProperties(attr.getValue(), true);
                    if (value == null) {
                        return;
                    }
                    url = new URL(value);
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
            }
            if (url == null && (attr = element.getAttributeNodeNS(null, "file")) != null) {
                String file = context.resolveProperties(attr.getValue(), true);
                if (file == null) {
                    return;
                }
                File resolved = context.resolveFile(file);
                if (resolved == null) {
                    return;
                }
                URL uRL = url = resolved.isDirectory() ? URLFactory.newDirURL((File)resolved) : URLFactory.newFileURL((File)resolved);
            }
            if (url == null && (attr = element.getAttributeNodeNS(null, "resource")) != null) {
                String resource = context.resolveProperties(attr.getValue(), true);
                if (resource == null) {
                    return;
                }
                attr = element.getAttributeNodeNS(null, "classpath");
                ClassLoader loader = null;
                if (attr != null) {
                    String classpath = context.resolveProperties(attr.getValue(), true);
                    if (classpath == null) {
                        return;
                    }
                    URL[] urls = this.resolvePath(context, classpath);
                    if (urls == null) {
                        return;
                    }
                    loader = new URLClassLoader(urls, null);
                } else {
                    JDevXmlContext xmlContext = (JDevXmlContext)context.getXmlContext();
                    Project project = xmlContext.getProject();
                    if (project != null) {
                        AntRunConfiguration config = AntRunConfiguration.getInstance((PropertyStorage)project);
                        loader = config.getAntClassLoader(project);
                    }
                }
                if (loader != null) {
                    url = loader.getResource(resource);
                }
            }
            if (url != null) {
                String prefix = null;
                attr = element.getAttributeNodeNS(null, "prefix");
                if (attr != null) {
                    prefix = context.resolveProperties(attr.getValue());
                }
                context.addPropertyProvider(new PropertyFilePropertyProvider(url, prefix));
            } else {
                attr = element.getAttributeNodeNS(null, "environment");
                if (attr != null) {
                    String value = context.resolveProperties(attr.getValue());
                    context.addPropertyProvider(new EnvironmentPropertyProvider(value));
                }
            }
        }
    }

    private URL[] resolvePath(AntContextImpl context, String path) {
        PathTokenizer tokenizer = new PathTokenizer(path);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenizer.hasMoreTokens()) {
            File file = context.resolveFile(tokenizer.nextToken());
            if (file == null) {
                return null;
            }
            URL url = file.isDirectory() ? URLFactory.newDirURL((File)file) : URLFactory.newFileURL((File)file);
            urls.add(url);
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

