/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.jdevimpl.ant.parser.PropertyProvider;

public abstract class URLPropertyProvider
extends PropertyProvider
implements Observer {
    private URL url;

    public URLPropertyProvider(URL url) {
        this.url = url;
        Node node = this.getNode(url);
        if (node != null) {
            node.attach((Observer)this);
        }
    }

    public URL getURL() {
        return this.url;
    }

    public void dispose() {
        super.dispose();
        Node node = this.getNode(this.url);
        if (node != null) {
            node.detach((Observer)this);
        }
    }

    public void update(Object observed, UpdateMessage change) {
        int id = change.getMessageID();
        if (id != UpdateMessage.CHILD_REMOVED && id != UpdateMessage.CHILD_ADDED && id != UpdateMessage.PROPERTY_SET && id != UpdateMessage.OBJECT_RENAMED && id != UpdateMessage.CHILD_RENAMED && id != UpdateMessage.OBJECT_OPENED && id != UpdateMessage.OBJECT_CLOSED && id != UpdateMessage.ATTRIBUTE_CHANGED) {
            this.firePropertiesChanged();
        }
    }

    private Node getNode(URL url) {
        Node node = null;
        try {
            node = NodeFactory.findOrCreate((URL)url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }
}

