/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.model.XmlModel;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.URLPropertyProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFilePropertyProvider
extends URLPropertyProvider {
    private String prefix;
    private boolean keepRoot;
    private boolean semanticAttributes;
    private boolean includeSemanticAttribute;
    private boolean collapseAttributes;
    private HashMap addedAttributes;
    private HashSet semantic;

    private void $init$() {
        this.addedAttributes = new HashMap();
        this.semantic = new HashSet();
    }

    public XmlFilePropertyProvider(URL url, String prefix, boolean keepRoot, boolean collapseAttributes, boolean semanticAttributes, boolean includeSemanticAttribute) {
        super(url);
        this.$init$();
        this.prefix = prefix;
        this.keepRoot = keepRoot;
        this.semanticAttributes = semanticAttributes;
        this.includeSemanticAttribute = includeSemanticAttribute;
        this.collapseAttributes = collapseAttributes;
        this.semantic.add("id");
        this.semantic.add("refid");
        this.semantic.add("location");
        this.semantic.add("value");
        this.semantic.add("path");
        this.semantic.add("pathid");
    }

    public void getProperties(AntContextImpl context, Map properties, Map ids, Set alreadySeen) {
        block17: {
            URL url = this.getURL();
            if (!alreadySeen.contains(url)) {
                this.addedAttributes.clear();
                InputStream is = null;
                try {
                    try {
                        XmlModel model = context.getXmlContext().getRelatedXmlModel(url);
                        if (model == null) break block17;
                        try {
                            model.acquireReadLock();
                            Document document = model.getDocument();
                            Element root = document.getDocumentElement();
                            if (this.keepRoot) {
                                this.addNodeRecursively(context, properties, ids, root, this.prefix, null);
                            } else {
                                NodeList children = root.getChildNodes();
                                int length = children.getLength();
                                int i = 0;
                                while (i < length) {
                                    this.addNodeRecursively(context, properties, ids, children.item(i), this.prefix, null);
                                    ++i;
                                }
                            }
                        }
                        finally {
                            model.releaseReadLock();
                        }
                    }
                    catch (Exception e) {}
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
    }

    private void addNodeRecursively(AntContextImpl context, Map properties, Map ids, Node node, String prefix, Object container) {
        String nodePrefix = prefix;
        if (node.getNodeType() != 3) {
            if (prefix.trim().length() > 0) {
                nodePrefix = nodePrefix + ".";
            }
            nodePrefix = nodePrefix + node.getNodeName();
        }
        if (node.getNodeType() == 1 && ((Element)node).getAttributeNodeNS(null, "pathid") != null) {
            return;
        }
        Object nodeObject = this.processNode(context, properties, ids, node, nodePrefix, container);
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int length = children.getLength();
            int i = 0;
            while (i < length) {
                this.addNodeRecursively(context, properties, ids, children.item(i), nodePrefix, nodeObject);
                ++i;
            }
        }
    }

    public Object processNode(AntContextImpl context, Map properties, Map ids, Node node, String prefix, Object container) {
        String id = null;
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            Node idNode = attributes.getNamedItem("id");
            id = this.semanticAttributes && idNode != null ? idNode.getNodeValue() : null;
            int length = attributes.getLength();
            int i = 0;
            while (i < length) {
                Node attribute = attributes.item(i);
                if (!this.semanticAttributes || !"id".equals(attribute.getNodeName())) {
                    String name = this.getAttributeName(attribute);
                    String value = this.getAttributeValue(context, attribute);
                    if (value != null) {
                        this.addProperty(properties, ids, prefix + name, value, id);
                    }
                }
                ++i;
            }
        }
        String text = null;
        if (node.getNodeType() == 3) {
            text = this.getAttributeValue(context, node);
        } else if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 4) {
            text = node.getFirstChild().getNodeValue();
        }
        if (text != null && text.trim().length() > 0) {
            if (this.semanticAttributes && id == null && container instanceof String) {
                id = (String)container;
            }
            this.addProperty(properties, ids, prefix, text, id);
        }
        return id;
    }

    private String getAttributeName(Node node) {
        String name = node.getNodeName();
        if (this.semanticAttributes) {
            if ("refid".equals(name)) {
                return "";
            }
            if (this.includeSemanticAttribute || !this.semantic.contains(name)) {
                return "." + name;
            }
            return "";
        }
        if (this.collapseAttributes) {
            return "." + name;
        }
        return "(" + name + ")";
    }

    private String getAttributeValue(AntContextImpl context, Node node) {
        String value = node.getNodeValue();
        if (this.semanticAttributes) {
            value = context.resolveProperties(value);
            String name = node.getNodeName();
            if ("location".equals(name)) {
                File file = context.resolveFile(value);
                if (file != null) {
                    value = file.getPath();
                }
            } else if ("refid".equals(name)) {
                value = context.resolveId(value);
            }
        }
        return value;
    }

    private void addProperty(Map properties, Map ids, String name, String value, String id) {
        if (this.addedAttributes.containsKey(name)) {
            value = this.addedAttributes.get(name) + "," + value;
        }
        if (!properties.containsKey(name)) {
            properties.put(name, value);
        }
        if (this.semanticAttributes && id != null) {
            ids.put(id, value);
        }
        this.addedAttributes.put(name, value);
    }
}

