/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.parser;

import java.io.File;
import java.net.URL;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.ant.AntContextImpl;
import oracle.jdevimpl.ant.parser.AntHandler;
import oracle.jdevimpl.ant.parser.XmlFilePropertyProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class XmlPropertyHandler
implements AntHandler {
    public void handleElement(AntContextImpl context, Element element) {
        Attr attr = element.getAttributeNodeNS(null, "file");
        if (attr != null) {
            String value = context.resolveProperties(attr.getValue(), true);
            if (value == null) {
                return;
            }
            File file = context.resolveFile(value);
            if (file != null) {
                URL url = file.isDirectory() ? URLFactory.newDirURL((File)file) : URLFactory.newFileURL((File)file);
                String prefix = "";
                attr = element.getAttributeNodeNS(null, "prefix");
                if (attr != null) {
                    prefix = attr.getValue();
                }
                context.addPropertyProvider(new XmlFilePropertyProvider(url, prefix, this.isFalse(context, element, "keeproot") ^ true, this.isTrue(context, element, "collapseattributes"), this.isTrue(context, element, "semanticattributes"), this.isTrue(context, element, "includesemanticattribute")));
            }
        }
    }

    private boolean isTrue(AntContextImpl context, Element element, String attribute) {
        Attr attr = element.getAttributeNodeNS(null, attribute);
        if (attr != null) {
            String value = context.resolveProperties(attr.getValue());
            return "true".equals(value) || "on".equals(value) || "yes".equals(value);
        }
        return false;
    }

    private boolean isFalse(AntContextImpl context, Element element, String attribute) {
        Attr attr = element.getAttributeNodeNS(null, attribute);
        if (attr != null) {
            String value = context.resolveProperties(attr.getValue());
            return "false".equals(value) || "off".equals(value) || "no".equals(value);
        }
        return false;
    }
}

