/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdevimpl.ant.registry.AntlibInfo;
import oracle.jdevimpl.ant.registry.PropertyInfo;
import oracle.jdevimpl.ant.registry.TaskInfo;
import oracle.jdevimpl.ant.registry.TypeInfo;

public class AntRegistry
extends HashStructureAdapter {
    public static final String DATA_KEY = AntRegistry.class.getName();
    public static final String ANTLIB_LIST = "antlibList";
    public static final String TASK_LIST = "taskList";
    public static final String TYPE_LIST = "taskList";
    public static final String PROPERTY_LIST = "propertyList";
    private static AntRegistry extensionRegistry;

    public AntRegistry() {
        this(HashStructure.newInstance());
    }

    private AntRegistry(HashStructure hash) {
        super(hash);
    }

    public static AntRegistry getInstance(PropertyStorage project) {
        return new AntRegistry(project.getProperties().getOrCreateHashStructure(DATA_KEY));
    }

    public static AntRegistry getExtensionAntRegistry() {
        if (extensionRegistry == null) {
            extensionRegistry = new AntRegistry();
        }
        return extensionRegistry;
    }

    public void addAntlib(AntlibInfo antlib) {
        HashStructure hash = HashStructure.newInstance();
        AntlibInfo copy = new AntlibInfo(hash);
        antlib.copyTo((Object)copy);
        ListStructure list = this._hash.getOrCreateListStructure(ANTLIB_LIST);
        list.add(hash);
    }

    public void addTask(TaskInfo task) {
        HashStructure hash = HashStructure.newInstance();
        TaskInfo copy = new TaskInfo(hash);
        task.copyTo((Object)copy);
        ListStructure list = this._hash.getOrCreateListStructure("taskList");
        list.add(hash);
    }

    public void addType(TypeInfo type) {
        HashStructure hash = HashStructure.newInstance();
        TypeInfo copy = new TypeInfo(hash);
        type.copyTo((Object)copy);
        ListStructure list = this._hash.getOrCreateListStructure("taskList");
        list.add(hash);
    }

    public void addProperty(PropertyInfo property) {
        HashStructure hash = HashStructure.newInstance();
        PropertyInfo copy = new PropertyInfo(hash);
        property.copyTo((Object)copy);
        ListStructure list = this._hash.getOrCreateListStructure(PROPERTY_LIST);
        list.add(hash);
    }

    public List getAntlibList() {
        ArrayList<AntlibInfo> antlibs = new ArrayList<AntlibInfo>();
        ListStructure list = this._hash.getListStructure(ANTLIB_LIST);
        if (list != null) {
            for (HashStructure hash : list) {
                antlibs.add(new AntlibInfo(hash));
            }
        }
        return Collections.unmodifiableList(antlibs);
    }

    public void setAntlibList(List antlibs) {
        if (antlibs == null) {
            this._hash.remove(ANTLIB_LIST);
        } else {
            ArrayList<HashStructure> hashes = new ArrayList<HashStructure>();
            Iterator iterator = antlibs.iterator();
            while (iterator.hasNext()) {
                AntlibInfo antlib = (AntlibInfo)((Object)iterator.next());
                HashStructure hash = (HashStructure)iterator.next();
                AntlibInfo copy = new AntlibInfo(hash);
                antlib.copyTo((Object)copy);
                hashes.add(hash);
            }
            ListStructure list = this._hash.getOrCreateListStructure(ANTLIB_LIST);
            list.mirror(antlibs);
        }
    }

    public List getTaskList() {
        ArrayList<TaskInfo> tasks = new ArrayList<TaskInfo>();
        ListStructure list = this._hash.getListStructure("taskList");
        if (list != null) {
            for (HashStructure hash : list) {
                tasks.add(new TaskInfo(hash));
            }
        }
        return Collections.unmodifiableList(tasks);
    }

    public void setTaskList(List tasks) {
        if (tasks == null) {
            this._hash.remove("taskList");
        } else {
            ArrayList<HashStructure> hashes = new ArrayList<HashStructure>();
            Iterator iterator = tasks.iterator();
            while (iterator.hasNext()) {
                TaskInfo task = (TaskInfo)((Object)iterator.next());
                HashStructure hash = (HashStructure)iterator.next();
                TaskInfo copy = new TaskInfo(hash);
                task.copyTo((Object)copy);
                hashes.add(hash);
            }
            ListStructure list = this._hash.getOrCreateListStructure("taskList");
            list.mirror(tasks);
        }
    }

    public List getTypeList() {
        ArrayList<TypeInfo> types = new ArrayList<TypeInfo>();
        ListStructure list = this._hash.getListStructure("taskList");
        if (list != null) {
            for (HashStructure hash : list) {
                types.add(new TypeInfo(hash));
            }
        }
        return Collections.unmodifiableList(types);
    }

    public void setTypeList(List types) {
        if (types == null) {
            this._hash.remove("taskList");
        } else {
            ArrayList<HashStructure> hashes = new ArrayList<HashStructure>();
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                TypeInfo type = (TypeInfo)((Object)iterator.next());
                HashStructure hash = (HashStructure)iterator.next();
                TypeInfo copy = new TypeInfo(hash);
                type.copyTo((Object)copy);
                hashes.add(hash);
            }
            ListStructure list = this._hash.getOrCreateListStructure("taskList");
            list.mirror(types);
        }
    }

    public List getPropertyList() {
        ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
        ListStructure list = this._hash.getListStructure(PROPERTY_LIST);
        if (list != null) {
            for (HashStructure hash : list) {
                properties.add(new PropertyInfo(hash));
            }
        }
        return Collections.unmodifiableList(properties);
    }

    public void setPropertyList(List properties) {
        if (properties == null) {
            this._hash.remove(PROPERTY_LIST);
        } else {
            ArrayList<HashStructure> hashes = new ArrayList<HashStructure>();
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                PropertyInfo property = (PropertyInfo)((Object)iterator.next());
                HashStructure hash = (HashStructure)iterator.next();
                PropertyInfo copy = new PropertyInfo(hash);
                property.copyTo((Object)copy);
                hashes.add(hash);
            }
            ListStructure list = this._hash.getOrCreateListStructure(PROPERTY_LIST);
            list.mirror(properties);
        }
    }

    public URLPath getClassPath() {
        URLPath classpath = new URLPath();
        for (AntlibInfo antlib : this.getAntlibList()) {
            classpath.add(antlib.getClassPath());
        }
        for (TaskInfo task : this.getTaskList()) {
            classpath.add(task.getClassPath());
        }
        for (TypeInfo type : this.getTypeList()) {
            classpath.add(type.getClassPath());
        }
        return classpath;
    }
}

