/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.jdevimpl.ant.AntArb;

public class AntInputHandler {
    public String getInput(String prompt, String[] choices) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        String input = null;
        YesNoChoice yesNo = this.getYesNoChoice(choices);
        if (yesNo != null) {
            int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), prompt, AntArb.getString(149), 1);
            switch (result) {
                case 0: {
                    input = yesNo.getYesString();
                    break;
                }
                case 1: {
                    input = yesNo.getNoString();
                    break;
                }
                default: {
                    input = null;
                    break;
                }
            }
        } else {
            input = this.showInputDialog((Component)Ide.getMainWindow(), prompt, AntArb.getString(149), 3, choices, null);
        }
        thread.setContextClassLoader(oldLoader);
        return input;
    }

    private String showInputDialog(Component parentComponent, Object message, String title, int messageType, Object[] selectionValues, Object initialSelectionValue) {
        JOptionPane pane = new JOptionPane(message, messageType, 2, null, null, null);
        pane.setWantsInput(true);
        pane.setMessageType(messageType);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.setComponentOrientation(parentComponent.getComponentOrientation());
        JDialog dialog = pane.createDialog(parentComponent, title);
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
        Object value = pane.getInputValue();
        if (value == JOptionPane.UNINITIALIZED_VALUE) {
            return null;
        }
        return (String)value;
    }

    private YesNoChoice getYesNoChoice(String[] choices) {
        YesNoChoice choice = null;
        if (choices != null && choices.length == 2) {
            if (choices[0].equalsIgnoreCase("n") && choices[1].equalsIgnoreCase("y") || choices[0].equalsIgnoreCase("no") && choices[1].equalsIgnoreCase("yes")) {
                choice = new YesNoChoice(choices[1], choices[0]);
            } else if (choices[0].equalsIgnoreCase("y") && choices[1].equalsIgnoreCase("n") || choices[0].equalsIgnoreCase("yes") && choices[1].equalsIgnoreCase("no")) {
                choice = new YesNoChoice(choices[0], choices[1]);
            }
        }
        return choice;
    }

    private class YesNoChoice {
        private String yes;
        private String no;

        public YesNoChoice(String yes, String no) {
            this.yes = yes;
            this.no = no;
        }

        public String getYesString() {
            return this.yes;
        }

        public String getNoString() {
            return this.no;
        }
    }
}

