/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.EnvironOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.MessagePage;
import oracle.ide.log.StyledMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.RunProcess;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntOptions;

public class AntLogPage
extends MessagePage {
    private static MultiMap<String, AntLogPage> availablePages;
    private Context context;
    private String title;
    private boolean buildFinished;
    private final Pattern linePattern;
    private static final String ANT_LOG_PAGE = "AntLogPage";
    protected static SimpleAttributeSet errAttributes;
    protected static SimpleAttributeSet warnAttributes;
    protected static SimpleAttributeSet infoAttributes;
    protected static SimpleAttributeSet verboseAttributes;
    protected static SimpleAttributeSet debugAttributes;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.linePattern = Pattern.compile("\\s*(?:\\[(.*)\\])?\\s*(?:file:)?(.+?):(\\d+):(?:(\\d+):)?(?:\\d+:\\d+:)?(.+)");
    }

    static {
        $assertionsDisabled = AntLogPage.class.desiredAssertionStatus() ^ true;
        availablePages = new MultiMap();
        errAttributes = new SimpleAttributeSet();
        warnAttributes = new SimpleAttributeSet();
        infoAttributes = new SimpleAttributeSet();
        verboseAttributes = new SimpleAttributeSet();
        debugAttributes = new SimpleAttributeSet();
        AntLogPage.getAntOptions().addChangeListener(new 1());
        AntLogPage.updateAttributeSets();
    }

    public AntLogPage(Context context, String title) {
        super(new ViewId(ANT_LOG_PAGE, title), AntArb.getIcon(224), false, true);
        this.$init$();
        this.setContext(context);
        this.title = title;
        LogManager.getLogManager().addPage((LogPage)this);
        this.show();
        EnvironOptions options = Ide.getEnvironOptions();
        if (options.isSaveLogToFile()) {
            URL prefix = options.getLogFilePrefix();
            URL logFile = URLFactory.newURL((URL)prefix, (String)title.replace(' ', '_'));
            this.setLogFileName(URLFileSystem.getPlatformPathName((URL)logFile));
        }
    }

    public void setContext(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AntLogPage getAntLogPage(Context context, String title) {
        AntLogPage page = null;
        MultiMap<String, AntLogPage> multiMap = availablePages;
        synchronized (multiMap) {
            Collection pages = availablePages.get((Object)title);
            if (pages != null && !pages.isEmpty()) {
                page = (AntLogPage)((Object)pages.iterator().next());
                availablePages.remove((Object)title, (Object)page);
                if (!$assertionsDisabled && !page.isFinished()) {
                    throw new AssertionError();
                }
                page.setContext(context);
            }
        }
        if (page == null) {
            page = new AntLogPage(context, title);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        MultiMap<String, AntLogPage> multiMap = availablePages;
        synchronized (multiMap) {
            availablePages.remove((Object)this.title, (Object)this);
        }
    }

    public void log(Object msg) {
        StyledMessage styled;
        String text;
        if (msg instanceof StyledMessage && (text = (styled = (StyledMessage)msg).getText()) != null) {
            AttributeSet attributes = styled.getAttributes();
            if (attributes == RunProcess.getSystemErrAttributeSet()) {
                msg = new StyledMessage((AttributeSet)errAttributes, text);
            } else if (attributes == RunProcess.getSystemOutAttributeSet()) {
                msg = new StyledMessage((AttributeSet)infoAttributes, text);
            }
        }
        super.log(msg);
    }

    public void log(int priority, String message) {
        this.log(priority, message, null, null, -1);
    }

    public void log(int priority, String message, String task, String file, int line) {
        StringBuffer buffer = new StringBuffer();
        int offset = 0;
        if (task != null) {
            int pad = 12 - task.length() - 3;
            offset += pad > 0 ? pad + 1 : 1;
            int i = 0;
            while (i < pad) {
                buffer.append(" ");
                ++i;
            }
            buffer.append("[");
            buffer.append(task);
            buffer.append("] ");
        }
        buffer.append(message);
        buffer.append("\n");
        String text = buffer.toString();
        StyledMessage styledMessage = new StyledMessage(AntLogPage.getAttributeSet(priority), text);
        super.logMsg((Object)styledMessage);
        if (task != null && file.length() > 0) {
            this.addHref(file, line, offset += styledMessage.getStartOffset(), offset + task.length());
        }
        this.addFileLinks(text, styledMessage.getStartOffset(), task, priority);
        SwingUtilities.invokeLater(new 2());
    }

    public String getToolTipText() {
        return this.title;
    }

    public String getToolTip() {
        if (this.buildFinished) {
            return RunMgrArb.format((int)5, (Object)this.title);
        }
        return this.title;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ant_log_html");
    }

    public void buildStarted() {
        this.buildFinished = false;
        this.updateToolTipText();
        SwingUtilities.invokeLater(new 3());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished() {
        this.buildFinished = true;
        MultiMap<String, AntLogPage> multiMap = availablePages;
        synchronized (multiMap) {
            availablePages.add((Object)this.title, (Object)this);
        }
        this.updateToolTipText();
    }

    public void buildCancelled() {
        String cancelled = AntArb.getString(28);
        this.log(0, cancelled);
    }

    public boolean isFinished() {
        return this.buildFinished;
    }

    private void addHref(String file, int line, int startOffset, int endOffset) {
        URL url = null;
        if (file.startsWith("jar:") || file.startsWith("file:")) {
            try {
                url = new URL(file);
            }
            catch (MalformedURLException mue) {
                url = null;
            }
        } else {
            url = URLFactory.newFileURL((String)file);
        }
        if (url != null) {
            URL localURL = url;
            4 href = new 4(this, file, url, localURL, line);
            href.setStartOffset(startOffset);
            href.setEndOffset(endOffset);
            this.addHref(href);
        }
    }

    private void addFileLinks(String message, int offset, String task, int priority) {
        Matcher lineMatcher = this.linePattern.matcher(message);
        while (lineMatcher.find()) {
            String file = lineMatcher.group(2).trim();
            int line = Integer.valueOf(lineMatcher.group(3));
            int startOffset = offset + lineMatcher.start(2);
            int endOffset = offset + lineMatcher.end(2);
            this.addHref(file, line, startOffset, endOffset);
        }
    }

    private static AttributeSet getAttributeSet(int priority) {
        SimpleAttributeSet attributeSet;
        switch (priority) {
            case 0: {
                attributeSet = errAttributes;
                break;
            }
            case 1: {
                attributeSet = warnAttributes;
                break;
            }
            case 2: {
                attributeSet = infoAttributes;
                break;
            }
            case 3: {
                attributeSet = verboseAttributes;
                break;
            }
            case 4: {
                attributeSet = debugAttributes;
                break;
            }
            default: {
                attributeSet = infoAttributes;
                break;
            }
        }
        return attributeSet;
    }

    private static AntOptions getAntOptions() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        return (AntOptions)settings.getData("AntOptions");
    }

    private static void updateAttributeSets() {
        AntOptions options = AntLogPage.getAntOptions();
        AntLogPage.checkColor(errAttributes, options.getErrColor());
        AntLogPage.checkColor(warnAttributes, options.getWarnColor());
        AntLogPage.checkColor(infoAttributes, options.getInfoColor());
        AntLogPage.checkColor(verboseAttributes, options.getVerboseColor());
        AntLogPage.checkColor(debugAttributes, options.getDebugColor());
    }

    private static void checkColor(SimpleAttributeSet attributeSet, int color) {
        if (StyleConstants.getForeground(attributeSet).getRGB() != color) {
            StyleConstants.setForeground(attributeSet, new Color(color));
        }
    }

    static Context ra$context(AntLogPage antLogPage) {
        return antLogPage.context;
    }

    static void mav$requestShow(AntLogPage antLogPage) {
        antLogPage.requestShow();
    }

    static void maS$updateAttributeSets() {
        AntLogPage.updateAttributeSets();
    }

    static final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            AntLogPage.maS$updateAttributeSets();
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            AntLogPage.mav$requestShow(AntLogPage.this);
        }
    }

    final class 3
    implements Runnable {
        public void run() {
            if (!LogManager.getLogManager().isLogVisible()) {
                LogManager.getLogManager().showLog();
            }
        }
    }

    final class 4
    extends Href {
        private final /* synthetic */ URL v$localURL;
        private final /* synthetic */ int v$line;
        final /* synthetic */ AntLogPage this$0;

        public void go() {
            Source.showSourceFile(AntLogPage.ra$context(this.this$0).getWorkspace(), AntLogPage.ra$context(this.this$0).getProject(), this.v$localURL, this.v$line, true);
        }

        public 4(AntLogPage antLogPage, String string, URL uRL, URL uRL2, int n) {
            this.v$line = n;
            this.v$localURL = uRL2;
            this.this$0 = antLogPage;
            super(string, uRL);
        }
    }
}

