/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.log.LogPage;
import oracle.ide.model.NodeFactory;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.util.Assert;
import oracle.jdeveloper.ant.AntListener;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.runner.AntLogPage;
import oracle.jdevimpl.ant.runner.AntProcess;
import oracle.jdevimpl.ant.runner.AntStarterFactory;

public class AntRunProcess
extends JRunProcess
implements AntProcess {
    private AntRunConfiguration runConfiguration;
    private AntListener antListener;
    private Object waitLock;
    private boolean started;
    private String name;

    private void $init$() {
        this.waitLock = new Object();
        this.started = false;
    }

    public AntRunProcess(AntRunConfiguration runConfiguration, Context context, String name) {
        super(context);
        this.$init$();
        this.name = name;
        this.lockCompiler = false;
        this.runConfiguration = runConfiguration;
        this.logCommandString = runConfiguration.getOutputLevel() == 4;
        this.logStartDirectory = this.logCommandString;
        this.logExit = this.logCommandString;
        this.considerDefaultRunTarget = false;
    }

    public void setRunProcessListener(RunProcessListener runProcessListener) {
        this.runProcessListener = runProcessListener;
    }

    public void setAntListener(AntListener antListener) {
        this.antListener = antListener;
    }

    protected void determineTargetAndStarter(Class starterFactorySubClass) {
        try {
            this.target = NodeFactory.findOrCreate((URL)this.runConfiguration.getBuildfile());
            this.starter = this.getStarterForTarget(this.target, starterFactorySubClass);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public AntListener getAntListener() {
        return this.antListener;
    }

    public AntRunConfiguration getAntRunConfiguration() {
        return this.runConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitUntilFinished() throws InterruptedException {
        Object object = this.waitLock;
        synchronized (object) {
            if (!this.started) {
                this.waitLock.wait();
            }
        }
        return this.starter == null ? -1 : this.starter.waitForProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean startTarget() {
        boolean value = super.startTarget();
        Object object = this.waitLock;
        synchronized (object) {
            this.started = true;
            this.waitLock.notifyAll();
        }
        return value;
    }

    protected boolean compile() {
        return true;
    }

    protected LogPage makeLogPage(boolean create) {
        AntLogPage logPage = AntLogPage.getAntLogPage(this.context, this.name);
        if (this.runConfiguration.isClearLogBeforeRun()) {
            logPage.clearAll();
        }
        return logPage;
    }

    protected Class getStarterFactorySubClass() {
        return AntStarterFactory.class;
    }

    public String getShortLabel() {
        return this.name;
    }

    public String getProcessLabelPrefix() {
        return this.getShortLabel();
    }

    public String getShortLabelWithPrefix() {
        return this.getShortLabel();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return AntArb.getIcon(224);
    }

    public void terminate() {
        super.terminate();
        ((AntLogPage)this.getLogPage()).buildCancelled();
    }
}

