/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.ant.AntListener;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdevimpl.ant.AntManagerImpl;
import oracle.jdevimpl.ant.AntVersion;
import oracle.jdevimpl.ant.runner.AntInputHandler;
import oracle.jdevimpl.ant.runner.AntLogPage;
import oracle.jdevimpl.ant.runner.AntProcess;
import oracle.jdevimpl.ant.runner.JAXPProperties;
import oracle.jdevimpl.ant.runner.OutOfProcessInputHandler;

public class AntStarter
extends JStarter {
    private AntNode node;
    private AntProcess antProcess;
    private AntRunConfiguration antConfiguration;
    private volatile Thread serverThread;
    private ServerSocket serverSocket;
    private Object portLock;
    private int port;
    private static final String ANT_MAIN_CLASS = "org.apache.tools.ant.Main";
    private static final String LOGGER_CLASS = "oracle.jdevimpl.ant.runner.OutOfProcessAntLogger";
    private static final String PROPERTY_FILE_INPUT_HANDLER_CLASS = "org.apache.tools.ant.input.PropertyFileInputHandler";
    private static final int SERVER_COMMAND_MESSAGE = 0;
    private static final int SERVER_COMMAND_TASK_MESSAGE = 1;
    private static final int SERVER_COMMAND_INPUT_REQUEST = 2;
    private static final int SERVER_COMMAND_DISCONNECT = 3;
    private static final int SOCKET_TIMEOUT = 5000;

    private void $init$() {
        this.portLock = new Object();
    }

    public AntStarter(AntProcess process, AntNode node) {
        super((JRunProcess)((Object)process), null);
        this.$init$();
        this.node = node;
        this.antProcess = process;
        this.antConfiguration = process.getAntRunConfiguration();
    }

    public boolean canStart(List errors) {
        return true;
    }

    public boolean start() {
        this.saveAll();
        this.startServer(this.runProcess.getContext());
        ((AntLogPage)this.runProcess.getLogPage()).buildStarted();
        AntListener listener2 = this.antProcess.getAntListener();
        if (listener2 != null) {
            listener2.buildStarted(this.antConfiguration);
        }
        AntManagerImpl manager = (AntManagerImpl)AntManager.getAntManager();
        for (AntListener listener2 : manager.getAntListeners()) {
            listener2.buildStarted(this.antConfiguration);
        }
        return super.start();
    }

    public void finished() {
        super.finished();
        ((AntLogPage)this.runProcess.getLogPage()).buildFinished();
        AntListener listener2 = this.antProcess.getAntListener();
        if (listener2 != null) {
            listener2.buildFinished(this.antConfiguration);
        }
        AntManagerImpl manager = (AntManagerImpl)AntManager.getAntManager();
        for (AntListener listener2 : manager.getAntListeners()) {
            listener2.buildFinished(this.antConfiguration);
        }
        this.shutdownServer();
    }

    public void terminate() {
        super.terminate();
        this.shutdownServer();
    }

    public File getStartDirectory() {
        URL dir = this.antConfiguration.getWorkingDirectory();
        if (dir != null) {
            return new File(URLFileSystem.getPath((URL)dir));
        }
        URL buildfile = this.antConfiguration.getBuildfile();
        if (buildfile != null) {
            URL parent = URLFileSystem.getParent((URL)buildfile);
            return new File(URLFileSystem.getPath((URL)parent));
        }
        return null;
    }

    public String[] getStartEnvironmentParams() {
        List names = this.antConfiguration.getEnvironmentNames();
        if (!names.isEmpty()) {
            Map<String, String> env = System.getenv();
            List values = this.antConfiguration.getEnvironmentValues();
            MacroRegistry registry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
            int len = names.size();
            int i = 0;
            while (i < len) {
                String name = (String)names.get(i);
                String value = (String)values.get(i);
                String expanded = registry.expand(value, this.runProcess.getContext());
                env.put(name, expanded);
                ++i;
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String name : env.keySet()) {
                String value = env.get(name);
                list.add(name + "=" + value);
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    public String[] getStartCommand() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.addJavaExecutableName(list)) {
            return null;
        }
        this.addClassPathOption(list);
        this.addBootClassPathOption(list);
        this.addJavaOptions(list);
        this.addFirstAntOptions(list);
        list.add(ANT_MAIN_CLASS);
        this.addAntOptions(list);
        this.addLastAntOptions(list);
        list.addAll(this.antConfiguration.getTargetList());
        return list.toArray(new String[list.size()]);
    }

    protected boolean addJavaExecutableName(List list) {
        JDK jdk = this.antConfiguration.getJDK(this.runProcess.getProject());
        String java = jdk.getSDKBinJavaExecutableNoConsole();
        if (java == null) {
            java = jdk.getJavaExecutableNoConsole();
        }
        if (java != null) {
            list.add(java);
            list.addAll(JAXPProperties.getCommandLineArgs(jdk.getJavaVersion()));
            return true;
        }
        return false;
    }

    protected void addJavaOptions(List list) {
        String javaArgs;
        list.add("-Djdev.ant.port=" + this.port);
        URL antHome = this.antConfiguration.getAntHome();
        if (antHome == null) {
            AntVersion version = AntVersion.getDefaultAntVersion();
            antHome = version.getAntHome();
        }
        list.add("-Dant.home=" + URLFileSystem.getPlatformPathName((URL)antHome));
        if (this.antConfiguration.getUseInputFile()) {
            URL inputFile = this.antConfiguration.getInputFile();
            String path = URLFileSystem.getPlatformPathName((URL)inputFile);
            list.add("-Dant.input.properties=" + path);
        }
        if ((javaArgs = this.antConfiguration.getJavaArgs()) != null) {
            String[] args = IdeUtil.convertStringToStringArray((String)javaArgs, (boolean)true, (boolean)true);
            int i = 0;
            while (i < args.length) {
                list.add(args[i]);
                ++i;
            }
        }
    }

    protected String getClassPath() {
        Project project = this.runProcess.getProject();
        URLPath urlPath = this.antConfiguration.getAntClassPath(project);
        return urlPath.toString();
    }

    private void addFirstAntOptions(List list) {
        String[] a = (String[])this.jrunProcess.getValue("Ant", null, "FirstAntCommandOptions");
        if (a != null) {
            AntStarter.addArrayToList(list, a);
        }
    }

    private void addLastAntOptions(List list) {
        String[] a = (String[])this.jrunProcess.getValue("Ant", null, "LastAntCommandOptions");
        if (a != null) {
            AntStarter.addArrayToList(list, a);
        }
    }

    private void addAntOptions(List list) {
        AntVersion antVersion = null;
        URL antHome = this.antConfiguration.getAntHome();
        if (antHome != null) {
            antVersion = AntVersion.createAntVersion(antHome);
        }
        if (antVersion == null) {
            antVersion = AntVersion.getDefaultAntVersion();
        }
        VersionNumber version = antVersion.getVersion();
        boolean isAnt15 = version.isAfter(new VersionNumber("1.5"));
        boolean isAnt16 = version.isAfter(new VersionNumber("1.6"));
        int outputLevel = this.antConfiguration.getOutputLevel();
        switch (outputLevel) {
            case 0: 
            case 1: {
                list.add("-quiet");
                break;
            }
            case 3: {
                list.add("-verbose");
                break;
            }
            case 4: {
                list.add("-debug");
                break;
            }
        }
        if (isAnt16 && this.antConfiguration.getKeepGoing()) {
            list.add("-k");
        }
        list.add("-logger");
        list.add(LOGGER_CLASS);
        if (isAnt15) {
            list.add("-inputhandler");
            if (this.antConfiguration.getUseInputFile()) {
                list.add(PROPERTY_FILE_INPUT_HANDLER_CLASS);
            } else {
                list.add(OutOfProcessInputHandler.class.getName());
            }
        }
        list.add("-f");
        list.add(URLFileSystem.getPlatformPathName((URL)this.antConfiguration.getBuildfile()));
        list.add("-Doracle.home=" + Ide.getOracleHomeDirectory());
        MacroRegistry registry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
        Iterator names = this.antConfiguration.getPropertyNames().iterator();
        Iterator values = this.antConfiguration.getPropertyValues().iterator();
        while (names.hasNext()) {
            String property = (String)names.next();
            String value = (String)values.next();
            String expanded = registry.expand(value, this.runProcess.getContext());
            list.add("-D" + property + "=" + expanded);
        }
        Iterator files = this.antConfiguration.getPropertyFiles().iterator();
        while (files.hasNext()) {
            list.add("-propertyfile");
            list.add((String)files.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(Context context) {
        Object object = this.portLock;
        synchronized (object) {
            this.serverThread = new ServerThread(context);
            this.serverThread.start();
            try {
                this.portLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void shutdownServer() {
        this.serverThread = null;
    }

    private void saveAll() {
        if (Ide.getEnvironOptions().getSaveBeforeCompile()) {
            IdeUtil.runNow((Runnable)new 1());
        }
    }

    static void wa$serverSocket(AntStarter antStarter, ServerSocket serverSocket) {
        antStarter.serverSocket = serverSocket;
    }

    static ServerSocket ra$serverSocket(AntStarter antStarter) {
        return antStarter.serverSocket;
    }

    static Object ra$portLock(AntStarter antStarter) {
        return antStarter.portLock;
    }

    static void wa$port(AntStarter antStarter, int n) {
        antStarter.port = n;
    }

    static Thread ra$serverThread(AntStarter antStarter) {
        return antStarter.serverThread;
    }

    static RunProcess ra$runProcess(AntStarter antStarter) {
        return antStarter.runProcess;
    }

    private class ServerThread
    extends Thread {
        private AntLogPage logPage;
        private AntInputHandler inputHandler;

        private void $init$() {
            this.inputHandler = new AntInputHandler();
        }

        public ServerThread(Context context) {
            super("Ant Server");
            this.$init$();
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void handleMessage(DataInputStream input) throws IOException {
            int priority = input.readInt();
            String message = input.readUTF();
            if (this.logPage != null) {
                this.logPage.log(priority, message, null, null, 0);
            }
        }

        private void handleTaskMessage(DataInputStream input) throws IOException {
            String task = input.readUTF();
            String file = input.readUTF();
            int line = input.readInt();
            int priority = input.readInt();
            String message = input.readUTF();
            if (this.logPage != null) {
                this.logPage.log(priority, message, task, file, line);
            }
        }

        private void handleInputRequest(DataInputStream input, DataOutputStream output) throws IOException {
            String response;
            String prompt = input.readUTF();
            int numChoices = input.readInt();
            String[] choices = null;
            if (numChoices > 0) {
                choices = new String[numChoices];
                int i = 0;
                while (i < numChoices) {
                    choices[i] = input.readUTF();
                    ++i;
                }
            }
            output.writeBoolean((response = this.inputHandler.getInput(prompt, choices)) != null);
            if (response != null) {
                output.writeUTF(response);
            }
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            try {
                SaveAllCommand.saveAll();
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }
}

