/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.util.JDK;
import oracle.ide.util.VersionNumber;

public class JAXPProperties {
    private static final String[] properties = new String[]{"javax.xml.transform.TransformerFactory", "javax.xml.parsers.SAXParserFactory", "javax.xml.parsers.DocumentBuilderFactory"};
    private static final String[] jdk14values = new String[]{"org.apache.xalan.processor.TransformerFactoryImpl", "org.apache.crimson.jaxp.SAXParserFactoryImpl", "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl"};
    private static final String[] jdk15values = new String[]{"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl"};
    private static final String[] oldValues = new String[]{System.getProperty(properties[0]), System.getProperty(properties[1]), System.getProperty(properties[2])};

    public static final void override() {
        String[] values = JDK.IS_JDK15 ? jdk15values : jdk14values;
        int i = 0;
        while (i < properties.length) {
            System.setProperty(properties[i], values[i]);
            ++i;
        }
    }

    public static final void restore() {
        int i = 0;
        while (i < properties.length) {
            if (oldValues[i] == null) {
                System.clearProperty(properties[i]);
            } else {
                System.setProperty(properties[i], oldValues[i]);
            }
            ++i;
        }
    }

    public static final List getCommandLineArgs(VersionNumber jdkVersion) {
        ArrayList<String> args = new ArrayList<String>(properties.length);
        VersionNumber jdk15 = new VersionNumber("1.5");
        String[] values = jdkVersion.isAfter(jdk15, true) ? jdk15values : jdk14values;
        int i = 0;
        while (i < properties.length) {
            args.add("-D" + properties[i] + "=" + values[i]);
            ++i;
        }
        return args;
    }
}

