/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.io.PrintStream;
import oracle.jdevimpl.ant.runner.OutOfProcessIDEHook;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Task;

public class OutOfProcessAntLogger
extends DefaultLogger {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    protected void printMessage(String message, PrintStream stream, int priority) {
        OutOfProcessIDEHook.sendMessage(message, priority);
    }

    public void buildStarted(BuildEvent event) {
        OutOfProcessIDEHook.connect();
        super.buildStarted(event);
    }

    public void buildFinished(BuildEvent event) {
        super.buildFinished(event);
        OutOfProcessIDEHook.disconnect();
    }

    public void targetStarted(BuildEvent event) {
        if (2 <= this.msgOutputLevel && event.getTarget().getName().length() > 0) {
            String msg = LINE_SEPARATOR + event.getTarget().getName() + ":";
            this.printMessage(msg, this.out, 2);
        }
    }

    public void messageLogged(BuildEvent event) {
        if (event.getPriority() <= this.msgOutputLevel) {
            Task task = event.getTask();
            OutOfProcessIDEHook.sendMessage(task, event.getMessage(), event.getPriority());
        }
    }
}

