/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import oracle.jdevimpl.ant.runner.AntLocation;
import org.apache.tools.ant.Task;

public class OutOfProcessIDEHook {
    private static final int SERVER_COMMAND_MESSAGE = 0;
    private static final int SERVER_COMMAND_TASK_MESSAGE = 1;
    private static final int SERVER_COMMAND_INPUT_REQUEST = 2;
    private static final int SERVER_COMMAND_DISCONNECT = 3;
    public static final String ANT_PORT_PROPERTY = "jdev.ant.port";
    private static Socket socket;
    private static DataInputStream input;
    private static DataOutputStream output;
    private static boolean connected;

    private OutOfProcessIDEHook() {
    }

    public static void connect() {
        int port = Integer.parseInt(System.getProperty(ANT_PORT_PROPERTY));
        try {
            socket = new Socket(InetAddress.getByName(null), port);
            output = new DataOutputStream(socket.getOutputStream());
            input = new DataInputStream(socket.getInputStream());
            connected = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void disconnect() {
        OutOfProcessIDEHook.sendDisconnect();
        try {
            try {
                if (input != null) {
                    input.close();
                    input = null;
                }
                if (output != null) {
                    output.close();
                    output = null;
                }
                if (socket != null) {
                    socket.close();
                    socket = null;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        finally {
            connected = false;
        }
    }

    public static void sendMessage(String message, int priority) {
        OutOfProcessIDEHook.sendMessage(null, message, priority);
    }

    public static synchronized void sendMessage(Task task, String message, int priority) {
        if (connected) {
            try {
                if (task != null) {
                    output.writeInt(1);
                    output.writeUTF(task.getTaskName());
                    AntLocation location = new AntLocation(task.getLocation());
                    String file = location.getFileName();
                    output.writeUTF(file == null ? "" : file);
                    output.writeInt(location.getLineNumber());
                } else {
                    output.writeInt(0);
                }
                output.writeInt(priority);
                output.writeUTF(message);
                output.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static synchronized String sendInputRequest(String prompt, String[] choices) {
        try {
            output.writeInt(2);
            output.writeUTF(prompt);
            if (choices == null) {
                output.writeInt(0);
            } else {
                output.writeInt(choices.length);
                int i = 0;
                while (i < choices.length) {
                    output.writeUTF(choices[i]);
                    ++i;
                }
            }
            output.flush();
            boolean responded = input.readBoolean();
            String string = responded ? input.readUTF() : null;
            return string;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static synchronized void sendDisconnect() {
        if (connected) {
            try {
                output.writeInt(3);
                output.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

