/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.runner.ui.AntRunConfigurationPage;
import oracle.jdevimpl.ant.runner.ui.EnvironmentPanel;
import oracle.jdevimpl.library.JDKPanel;
import oracle.jdevimpl.library.LibraryPanel;

public class AntJavaPage
extends AntRunConfigurationPage {
    private JLabel jdkLabel;
    private JTextField jdkField;
    private JButton editJDKButton;
    private LibraryList[] libLists;
    private JProjectLibraryList prjLibList;
    private Project jProject;
    private JLabel workingDirLabel;
    private URLTextField workingDirField;
    private JButton browseWorkingDirButton;
    private JLabel javaArgsLabel;
    private JTextField javaArgsField;
    private JButton environmentButton;
    private EnvironmentPanel environmentPanel;
    private List envNames;
    private List envValues;
    private JDK jdk;
    private JProjectLibraries projectLibraries;
    private static final LocalChangeListener LISTENER = new LocalChangeListener(null);
    private static final String[] PROPERTY_KEYS = new String[]{"jdkVersion", "workingDir", "javaArgs"};

    public AntJavaPage() {
        this.jbInit();
    }

    public void setJProject(Project jProject) {
        this.jProject = jProject;
        this.projectLibraries = JProjectLibraries.getInstance((PropertyStorage)jProject);
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void loadFrom(AntRunConfiguration antConfiguration) {
        this.loadJDKs();
        this.jdk = antConfiguration.getJDK(this.jProject);
        if (this.jdk != null) {
            this.jdkField.setText(this.jdk.toString());
        }
        this.workingDirField.setURL(antConfiguration.getWorkingDirectory());
        URL buildfile = antConfiguration.getBuildfile();
        if (buildfile != null) {
            this.workingDirField.setDefaultChooserURL(URLFileSystem.getParent((URL)buildfile));
        }
        this.javaArgsField.setText(antConfiguration.getJavaArgs());
        this.envNames = antConfiguration.getEnvironmentNames();
        this.envValues = antConfiguration.getEnvironmentValues();
    }

    public void saveTo(AntRunConfiguration antConfiguration) {
        if (this.jdk != null && this.jdk.equals(this.getDefaultJDK())) {
            antConfiguration.setJDK(null);
        } else {
            antConfiguration.setJDK(this.jdk);
        }
        antConfiguration.setWorkingDirectory(this.workingDirField.getURL());
        String args = this.javaArgsField.getText();
        if (args != null && args.length() == 0) {
            args = null;
        }
        antConfiguration.setJavaArgs(args);
        antConfiguration.setEnvironmentNames(this.envNames);
        antConfiguration.setEnvironmentValues(this.envValues);
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        Project jProject;
        this.jProject = jProject = (Project)tc.find("Project");
        PropertyStorage propertyData = AntJavaPage.getPropertyData((Namespace)tc);
        this.projectLibraries = JProjectLibraries.getInstance((PropertyStorage)propertyData);
        super.onProjectPanelEntry(tc);
    }

    public Component getInitialFocus() {
        return this.jdkField;
    }

    public String getPageName() {
        return AntArb.getString(187);
    }

    public boolean isComplete() {
        return true;
    }

    public boolean validateOptions() {
        if (this.workingDirField.getText().trim().length() > 0 && this.workingDirField.getURL() == null) {
            MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(108), (String)AntArb.getString(41), null);
            return false;
        }
        return true;
    }

    public String getPageHelpTopicID() {
        return "process_html";
    }

    private void jbInit() {
        JLabel instructions = new JLabel();
        instructions.setText("<html>" + AntArb.getString(229) + "</html>");
        this.jdkLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.jdkLabel, null, (String)JProjectArb.getString((int)33));
        this.jdkField = new JTextField();
        this.jdkField.setEditable(false);
        this.editJDKButton = new JButton();
        this.editJDKButton.addActionListener(new 1());
        ResourceUtils.resButton((AbstractButton)this.editJDKButton, (String)ControlsArb.getString((int)70));
        this.workingDirField = new URLTextField(null, true, false);
        this.workingDirField.setColumns(30);
        this.workingDirField.setDialogHelpContext("f1_idedurlchooserdir_html");
        this.workingDirLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.workingDirLabel, (Component)this.workingDirField, (String)AntArb.getString(169));
        this.browseWorkingDirButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.browseWorkingDirButton, (String)AntArb.getString(10));
        this.browseWorkingDirButton.addActionListener((ActionListener)this.workingDirField);
        this.javaArgsField = new JTextField();
        this.javaArgsLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.javaArgsLabel, (Component)this.javaArgsField, (String)AntArb.getString(31));
        this.environmentButton = new JButton();
        this.environmentPanel = new EnvironmentPanel();
        ResourceUtils.resButton((AbstractButton)this.environmentButton, (String)AntArb.getString(66));
        this.environmentButton.addActionListener(new 2());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 15, 0);
        gbc.weightx = 1.0;
        this.add(instructions, gbc);
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 2, 5);
        this.add(this.jdkLabel, gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        this.add(this.jdkField, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 2, 0);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add(this.editJDKButton, gbc);
        gbc.insets = new Insets(10, 0, 2, 0);
        this.add(this.javaArgsLabel, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.weightx = 1.0;
        this.add(this.javaArgsField, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(10, 0, 2, 0);
        this.add(this.workingDirLabel, gbc);
        gbc.gridwidth = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.workingDirField, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.weightx = 0.0;
        this.add(this.browseWorkingDirButton, gbc);
        gbc.insets = new Insets(10, 0, 0, 0);
        this.add(this.environmentButton, gbc);
        gbc.gridheight = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(new JLabel(), gbc);
    }

    private void loadJDKs() {
        LibraryList[] builtInLists = JLibraryManager.getAllLibraryLists();
        if (this.jProject != null) {
            this.prjLibList = this.projectLibraries.getProjectLibraryList();
            this.libLists = new LibraryList[builtInLists.length + 1];
            System.arraycopy(builtInLists, 0, this.libLists, 0, builtInLists.length);
            this.libLists[this.libLists.length - 1] = this.prjLibList;
        } else {
            this.libLists = builtInLists;
        }
    }

    private void editJDK() {
        JDKPanel panel = new JDKPanel();
        ListWrapper[] copies = new ListWrapper[this.libLists.length];
        int i = 0;
        while (i < copies.length) {
            copies[i] = new ListWrapper(this.libLists[i]);
            ++i;
        }
        panel.initPanel(copies, (Object)this.jdk);
        panel.setSelectionMode(1);
        LocalChangeListener.wa$_panel(LISTENER, (LibraryPanel)panel);
        if (OnePageWizardDialogFactory.runDialog((Component)((Object)this), (Component)panel, null, (String)ControlsArb.getString((int)40), (int)7, (VetoableChangeListener)LISTENER)) {
            copies = panel.getLibraryLists();
            int i2 = 0;
            while (i2 < copies.length) {
                copies[i2].commit(copies[i2].getWrappedList() != this.prjLibList);
                ++i2;
            }
            Library[] selection = panel.getSelection();
            if (selection != null && selection.length > 0) {
                this.jdk = (JDK)selection[0];
            }
            this.jdkField.setText(this.jdk.toString());
            this.loadJDKs();
        }
    }

    private JDK getDefaultJDK() {
        JDK jdk = null;
        if (this.jProject != null) {
            jdk = this.projectLibraries.getJDK();
        }
        if (jdk == null) {
            jdk = JLibraryManager.getDefaultJDK();
        }
        return jdk;
    }

    static void mav$editJDK(AntJavaPage antJavaPage) {
        antJavaPage.editJDK();
    }

    static EnvironmentPanel ra$environmentPanel(AntJavaPage antJavaPage) {
        return antJavaPage.environmentPanel;
    }

    static List ra$envNames(AntJavaPage antJavaPage) {
        return antJavaPage.envNames;
    }

    static List ra$envValues(AntJavaPage antJavaPage) {
        return antJavaPage.envValues;
    }

    static void wa$envNames(AntJavaPage antJavaPage, List list) {
        antJavaPage.envNames = list;
    }

    static void wa$envValues(AntJavaPage antJavaPage, List list) {
        antJavaPage.envValues = list;
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            AntJavaPage.mav$editJDK(AntJavaPage.this);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            AntJavaPage.ra$environmentPanel(AntJavaPage.this).setEnvironment(AntJavaPage.ra$envNames(AntJavaPage.this), AntJavaPage.ra$envValues(AntJavaPage.this));
            if (AntJavaPage.ra$environmentPanel(AntJavaPage.this).runDialog()) {
                AntJavaPage.wa$envNames(AntJavaPage.this, AntJavaPage.ra$environmentPanel(AntJavaPage.this).getNames());
                AntJavaPage.wa$envValues(AntJavaPage.this, AntJavaPage.ra$environmentPanel(AntJavaPage.this).getValues());
            }
        }
    }

    private static final class LocalChangeListener
    implements VetoableChangeListener {
        private LibraryPanel _panel;
        private boolean _vetoThrown;

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            if (!this._panel.commitChanges()) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, e);
            }
        }

        private LocalChangeListener() {
        }

        LocalChangeListener(1 var1_1) {
            this();
        }

        static void wa$_panel(LocalChangeListener localChangeListener, LibraryPanel libraryPanel) {
            localChangeListener._panel = libraryPanel;
        }

        public final class 1 {
        }
    }
}

