/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.JScrollingLabel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntVersion;
import oracle.jdevimpl.ant.runner.ui.AntRunConfigurationPage;

public class AntMainPage
extends AntRunConfigurationPage {
    private ButtonGroup antVersionButtonGroup;
    private JRadioButton useDefaultAnt;
    private JRadioButton useAntHome;
    private JButton browseAntHomeButton;
    private JLabel antHomeLabel;
    private URLTextField antHomeField;
    private JScrollingLabel versionLabel;
    private JComboBox outputLevel;
    private JCheckBox keepGoingCheckBox;
    private JLabel inputFileLabel;
    private JCheckBox inputFileCheckBox;
    private URLTextField inputFileField;
    private JButton browseInputFileButton;
    private static final String[] OUTPUT_LEVEL_STRINGS = new String[]{AntArb.getString(123), AntArb.getString(226), AntArb.getString(59), AntArb.getString(13)};
    private static final int[] OUTPUT_LEVELS = new int[]{1, 2, 3, 4};
    private static final String[] PROPERTY_KEYS = new String[]{"antHome", "outputLevel", "keepGoing", "useInputFile", "inputFile"};

    public AntMainPage() {
        this.jbInit();
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void loadFrom(AntRunConfiguration antConfiguration) {
        URL antHome = antConfiguration.getAntHome();
        if (antHome != null) {
            this.useAntHome.setSelected(true);
            this.antHomeField.setURL(antHome);
        } else {
            this.useDefaultAnt.setSelected(true);
            this.antHomeField.setURL(null);
        }
        this.updateAntHome();
        int level = antConfiguration.getOutputLevel();
        this.outputLevel.setSelectedIndex(this.getIndexForLevel(level));
        this.keepGoingCheckBox.setSelected(antConfiguration.getKeepGoing());
        this.inputFileCheckBox.setSelected(antConfiguration.getUseInputFile());
        URL inputFile = antConfiguration.getInputFile();
        this.inputFileField.setURL(inputFile);
        this.updateInputFile();
        URL buildfile = antConfiguration.getBuildfile();
        if (buildfile != null) {
            URL parent = URLFileSystem.getParent((URL)buildfile);
            this.inputFileField.setDefaultChooserURL(parent);
        } else {
            this.inputFileField.setDefaultChooserURL(null);
        }
    }

    public void saveTo(AntRunConfiguration antConfiguration) {
        if (this.useDefaultAnt.isSelected()) {
            antConfiguration.setAntHome(null);
        } else {
            antConfiguration.setAntHome(this.antHomeField.getURL());
        }
        int index = this.outputLevel.getSelectedIndex();
        antConfiguration.setOutputLevel(OUTPUT_LEVELS[index]);
        antConfiguration.setKeepGoing(this.keepGoingCheckBox.isSelected());
        antConfiguration.setUseInputFile(this.inputFileCheckBox.isSelected());
        antConfiguration.setInputFile(this.inputFileField.getURL());
    }

    public Component getInitialFocus() {
        return this.useDefaultAnt;
    }

    public String getPageName() {
        return AntArb.getString(21);
    }

    public boolean isComplete() {
        return true;
    }

    public boolean validateOptions() {
        if (this.useAntHome.isSelected()) {
            AntVersion version = null;
            URL antHome = this.antHomeField.getURL();
            if (antHome != null && URLFileSystem.isDirectory((URL)antHome)) {
                version = AntVersion.createAntVersion(antHome);
            }
            if (version == null) {
                MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(92), (String)AntArb.getString(142), null);
                return false;
            }
        }
        if (this.inputFileCheckBox.isSelected() && this.inputFileField.getURL() == null) {
            MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(172), (String)AntArb.getString(174), null);
            return false;
        }
        return true;
    }

    public String getPageHelpTopicID() {
        return "options_html";
    }

    private void jbInit() {
        JLabel instructions = new JLabel();
        instructions.setText("<html>" + AntArb.getString(34) + "</html>");
        JPanel versionPanel = new JPanel();
        versionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(AntArb.getString(209)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
        this.antVersionButtonGroup = new ButtonGroup();
        1 radioListener = new 1();
        this.useDefaultAnt = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.useDefaultAnt, (String)AntArb.getString(219));
        this.useDefaultAnt.addActionListener(radioListener);
        this.antVersionButtonGroup.add(this.useDefaultAnt);
        this.useAntHome = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.useAntHome, (String)AntArb.getString(135));
        this.useAntHome.addActionListener(radioListener);
        this.antVersionButtonGroup.add(this.useAntHome);
        this.antHomeLabel = new JLabel();
        this.antHomeField = new URLTextField(null, true, false);
        this.antHomeField.setColumns(30);
        this.antHomeField.getDocument().addDocumentListener(new AntHomeListener(null));
        this.antHomeField.setDialogHelpContext("f1_idedurlchooserdir_html");
        ResourceUtils.resLabel((JLabel)this.antHomeLabel, (Component)this.antHomeField, (String)AntArb.getString(137));
        this.browseAntHomeButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.browseAntHomeButton, (String)AntArb.getString(207));
        this.browseAntHomeButton.addActionListener((ActionListener)this.antHomeField);
        this.versionLabel = new JScrollingLabel();
        Font font = this.versionLabel.getFont();
        if (font != null) {
            this.versionLabel.setFont(font.deriveFont(1));
        }
        JLabel outputLabel = new JLabel();
        this.outputLevel = new JComboBox<String>(OUTPUT_LEVEL_STRINGS);
        ResourceUtils.resLabel((JLabel)outputLabel, (Component)this.outputLevel, (String)AntArb.getString(104));
        this.keepGoingCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.keepGoingCheckBox, (String)AntArb.getString(179));
        this.inputFileCheckBox = new JCheckBox();
        this.inputFileCheckBox.addItemListener(new 2());
        ResourceUtils.resButton((AbstractButton)this.inputFileCheckBox, (String)AntArb.getString(89));
        this.inputFileField = new URLTextField(null, false, false);
        this.inputFileField.setColumns(30);
        DefaultURLFilter filter = new DefaultURLFilter(AntArb.getString(143), ".properties");
        this.inputFileField.setFilter((URLFilter)filter);
        this.inputFileField.setDialogHelpContext("f1_idedurlchooserfile_html");
        this.inputFileLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this.inputFileLabel, (Component)this.inputFileField, (String)AntArb.getString(43));
        this.browseInputFileButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.browseInputFileButton, (String)AntArb.getString(151));
        this.browseInputFileButton.addActionListener((ActionListener)this.inputFileField);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 15, 0);
        this.add(instructions, gbc);
        versionPanel.setLayout(new GridBagLayout());
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        versionPanel.add((Component)this.useDefaultAnt, gbc);
        versionPanel.add((Component)this.useAntHome, gbc);
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 20, 0, 8);
        versionPanel.add((Component)this.antHomeLabel, gbc);
        gbc.gridwidth = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 8);
        versionPanel.add((Component)this.antHomeField, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        versionPanel.add((Component)this.browseAntHomeButton, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 0, 0, 0);
        versionPanel.add((Component)this.versionLabel, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 10, 0);
        this.add(versionPanel, gbc);
        JPanel outputPanel = new JPanel(new GridBagLayout());
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 8);
        outputPanel.add((Component)outputLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 0, 0, 0);
        outputPanel.add((Component)this.outputLevel, gbc);
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add(outputPanel, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add(this.keepGoingCheckBox, gbc);
        this.add(this.inputFileCheckBox, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 20, 0, 8);
        gbc.gridwidth = 1;
        this.add(this.inputFileLabel, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 8);
        gbc.gridwidth = -1;
        this.add((Component)this.inputFileField, gbc);
        gbc.gridwidth = 0;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add(this.browseInputFileButton, gbc);
        gbc.gridheight = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(new JLabel(), gbc);
    }

    private void updateInputFile() {
        boolean useInputFile = this.inputFileCheckBox.isSelected();
        this.inputFileLabel.setEnabled(useInputFile);
        this.inputFileField.setEnabled(useInputFile);
        this.browseInputFileButton.setEnabled(useInputFile);
    }

    private void updateAntHome() {
        AntVersion version = null;
        boolean isDefault = this.useDefaultAnt.isSelected();
        if (isDefault) {
            version = AntVersion.getDefaultAntVersion();
        } else {
            URL antHome = this.antHomeField.getURL();
            if (antHome != null && URLFileSystem.isDirectory((URL)antHome)) {
                version = AntVersion.createAntVersion(antHome);
            }
        }
        if (version != null) {
            this.versionLabel.setText(version.getVersionString());
            boolean isKeepGoingSupported = version.getVersion().isAfter(new VersionNumber("1.6"), true);
            this.keepGoingCheckBox.setEnabled(isKeepGoingSupported);
            boolean isInputFileSupported = version.getVersion().isAfter(new VersionNumber("1.5"), true);
            this.inputFileCheckBox.setEnabled(isInputFileSupported);
            this.updateInputFile();
        } else {
            this.versionLabel.setText(null);
        }
        this.antHomeLabel.setEnabled(isDefault ^ true);
        this.antHomeField.setEnabled(isDefault ^ true);
        this.browseAntHomeButton.setEnabled(isDefault ^ true);
    }

    private int getIndexForLevel(int level) {
        if (level == 0) {
            level = 1;
        }
        int i = 0;
        while (i < OUTPUT_LEVELS.length) {
            if (level == OUTPUT_LEVELS[i]) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    static void mav$updateAntHome(AntMainPage antMainPage) {
        antMainPage.updateAntHome();
    }

    static void mav$updateInputFile(AntMainPage antMainPage) {
        antMainPage.updateInputFile();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            AntMainPage.mav$updateAntHome(AntMainPage.this);
        }
    }

    final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
            AntMainPage.mav$updateInputFile(AntMainPage.this);
        }
    }

    private class AntHomeListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            AntMainPage.mav$updateAntHome(AntMainPage.this);
        }

        public void insertUpdate(DocumentEvent e) {
            AntMainPage.mav$updateAntHome(AntMainPage.this);
        }

        public void removeUpdate(DocumentEvent e) {
            AntMainPage.mav$updateAntHome(AntMainPage.this);
        }

        private AntHomeListener() {
        }

        AntHomeListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

