/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.sort.Sort;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ide.externaltools.macro.MacroPicker;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.externaltools.AntExternalToolType;
import oracle.jdevimpl.ant.runner.ui.AntRunConfigurationPage;

public class AntPropertiesPage
extends AntRunConfigurationPage {
    private NiceTable propertyTable;
    private JPanel propertyPanel;
    private JList fileList;
    private JTextField propertyNameField;
    private JTextField propertyValueField;
    private JButton removePropertyButton;
    private JButton editPropertyButton;
    private JButton removeFileButton;
    private URL buildfile;
    private URL lastPropertyFile;
    private boolean inRemove;
    private static final String ADD_PROPERTY_HELP_TOPIC = "f1_ant_add_property_dlg_html";
    private static final String EDIT_PROPERTY_HELP_TOPIC = "f1_ant_edit_property_dlg_html";
    private static final int INDEX_NAME = 0;
    private static final int INDEX_VALUE = 1;
    private static final String[] PROPERTY_KEYS = new String[]{"propertyNames", "propertyValues", "propertyFiles"};

    private void $init$() {
        this.inRemove = false;
    }

    public AntPropertiesPage() {
        this.$init$();
        this.jbInit();
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void loadFrom(AntRunConfiguration antConfiguration) {
        this.buildfile = antConfiguration.getBuildfile();
        DefaultTableModel tableModel = (DefaultTableModel)this.propertyTable.getModel();
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
        Iterator names = antConfiguration.getPropertyNames().iterator();
        Iterator values = antConfiguration.getPropertyValues().iterator();
        while (names.hasNext()) {
            String property = (String)names.next();
            String value = (String)values.next();
            tableModel.addRow(new String[]{property, value});
        }
        if (tableModel.getRowCount() > 0) {
            this.propertyTable.setRowSelectionInterval(0, 0);
        }
        DefaultListModel listModel = (DefaultListModel)this.fileList.getModel();
        listModel.clear();
        Iterator files = antConfiguration.getPropertyFiles().iterator();
        while (files.hasNext()) {
            listModel.addElement((String)files.next());
        }
        if (listModel.size() > 0) {
            this.fileList.setSelectedIndex(0);
        }
        this.updatePropertyButtons();
        this.updateFileButtons();
    }

    public void saveTo(AntRunConfiguration antConfiguration) {
        DefaultTableModel tableModel = (DefaultTableModel)this.propertyTable.getModel();
        int rowCount = tableModel.getRowCount();
        String[] names = new String[rowCount];
        String[] values = new String[rowCount];
        int i = 0;
        while (i < rowCount) {
            names[i] = (String)tableModel.getValueAt(i, 0);
            values[i] = (String)tableModel.getValueAt(i, 1);
            ++i;
        }
        antConfiguration.setPropertyNames(Arrays.asList(names));
        antConfiguration.setPropertyValues(Arrays.asList(values));
        ListModel listModel = this.fileList.getModel();
        int fileCount = listModel.getSize();
        String[] files = new String[fileCount];
        int i2 = 0;
        while (i2 < fileCount) {
            files[i2] = (String)listModel.getElementAt(i2);
            ++i2;
        }
        antConfiguration.setPropertyFiles(Arrays.asList(files));
    }

    public Component getInitialFocus() {
        return this.propertyTable;
    }

    public String getPageName() {
        return AntArb.getString(64);
    }

    public boolean isComplete() {
        return true;
    }

    public boolean validateOptions() {
        return true;
    }

    public String getPageHelpTopicID() {
        return "properties_html";
    }

    private void jbInit() {
        JLabel instructions = new JLabel();
        instructions.setText("<html>" + AntArb.getString(65) + "</html>");
        this.propertyTable = new NiceTable();
        this.propertyTable.setResizeColumnOnDoubleClick(false);
        this.propertyTable.setColumnSelectorAvailable(false);
        this.propertyTable.setSorted(false);
        this.propertyTable.getTableHeader().setReorderingAllowed(false);
        Object[] columnNames = new Object[]{AntArb.getString(61), AntArb.getString(165)};
        this.propertyTable.setModel((TableModel)new 1(columnNames, 0));
        this.propertyTable.getColumnModel().getColumn(0).setCellRenderer(new PropertyCellRenderer(null));
        this.propertyTable.getSelectionModel().addListSelectionListener(new 2());
        JScrollPane scrollPane = new JScrollPane((Component)this.propertyTable);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JLabel propertyTableLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)propertyTableLabel, (Component)this.propertyTable, (String)AntArb.getString(100));
        ButtonBar propertyButtons = new ButtonBar();
        propertyButtons.setOrientation(1);
        propertyButtons.setAlignment(1);
        JButton addButton = new JButton();
        ResourceUtils.resButton((AbstractButton)addButton, (String)AntArb.getString(72));
        addButton.addActionListener(new 3());
        propertyButtons.add((Component)addButton);
        this.editPropertyButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.editPropertyButton, (String)AntArb.getString(134));
        this.editPropertyButton.addActionListener(new 4());
        propertyButtons.add((Component)this.editPropertyButton);
        this.removePropertyButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.removePropertyButton, (String)AntArb.getString(105));
        this.removePropertyButton.addActionListener(new 5());
        propertyButtons.add((Component)this.removePropertyButton);
        this.updatePropertyButtons();
        this.fileList = new JList(new DefaultListModel());
        this.fileList.getSelectionModel().addListSelectionListener(new 6());
        JScrollPane fileScrollPane = new JScrollPane(this.fileList);
        JLabel propertyFilesLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)propertyFilesLabel, (Component)this.propertyTable, (String)AntArb.getString(211));
        ButtonBar fileButtons = new ButtonBar();
        fileButtons.setOrientation(1);
        fileButtons.setAlignment(1);
        JButton addFileButton = new JButton();
        ResourceUtils.resButton((AbstractButton)addFileButton, (String)AntArb.getString(45));
        addFileButton.addActionListener(new 7());
        fileButtons.add((Component)addFileButton);
        this.removeFileButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.removeFileButton, (String)AntArb.getString(203));
        this.removeFileButton.addActionListener(new 8());
        fileButtons.add((Component)this.removeFileButton);
        this.updateFileButtons();
        this.setLayout(new BorderLayout(0, 15));
        this.add(instructions, "North");
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridLayout(2, 1, 0, 10));
        JPanel propertyPanel = new JPanel();
        propertyPanel.setLayout(new BorderLayout(8, 3));
        propertyPanel.add((Component)propertyTableLabel, "North");
        propertyPanel.add((Component)scrollPane, "Center");
        propertyPanel.add((Component)propertyButtons, "East");
        gridPanel.add(propertyPanel);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BorderLayout(8, 3));
        filePanel.add((Component)propertyFilesLabel, "North");
        filePanel.add((Component)fileScrollPane, "Center");
        filePanel.add((Component)fileButtons, "East");
        gridPanel.add(filePanel);
        this.add(gridPanel, "Center");
    }

    private void addProperty() {
        JEWTDialog propertyDialog = this.createPropertyDialog(AntArb.getString(195), ADD_PROPERTY_HELP_TOPIC);
        try {
            this.propertyNameField.setText(null);
            this.propertyValueField.setText(null);
            if (propertyDialog.runDialog()) {
                DefaultTableModel model = (DefaultTableModel)this.propertyTable.getModel();
                model.addRow(new String[]{this.propertyNameField.getText(), this.propertyValueField.getText()});
                int row = model.getRowCount() - 1;
                this.propertyTable.setRowSelectionInterval(row, row);
                this.propertyTable.scrollToSelection();
            }
        }
        finally {
            propertyDialog.dispose();
        }
    }

    private void removeProperty() {
        DefaultTableModel model = (DefaultTableModel)this.propertyTable.getModel();
        int[] rows = this.propertyTable.getSelectedRows();
        if (rows != null) {
            try {
                this.inRemove = true;
                Sort.qSort((int[])rows, (int)rows.length, (boolean)false);
                int row = 0;
                int i = 0;
                while (i < rows.length) {
                    row = rows[i];
                    model.removeRow(row);
                    ++i;
                }
                if ((row = Math.min(row, this.propertyTable.getRowCount() - 1)) >= 0) {
                    this.propertyTable.setRowSelectionInterval(row, row);
                    this.propertyTable.scrollToSelection();
                }
            }
            finally {
                this.inRemove = false;
                this.updatePropertyButtons();
            }
        }
    }

    private void editProperty() {
        int[] rows = this.propertyTable.getSelectedRows();
        if (rows != null && rows.length > 0) {
            int row = rows[0];
            DefaultTableModel model = (DefaultTableModel)this.propertyTable.getModel();
            JEWTDialog propertyDialog = this.createPropertyDialog(AntArb.getString(73), EDIT_PROPERTY_HELP_TOPIC);
            try {
                this.propertyNameField.setText((String)model.getValueAt(row, 0));
                this.propertyValueField.setText((String)model.getValueAt(row, 1));
                if (propertyDialog.runDialog()) {
                    model.setValueAt(this.propertyNameField.getText(), row, 0);
                    model.setValueAt(this.propertyValueField.getText(), row, 1);
                }
            }
            finally {
                propertyDialog.dispose();
            }
        }
    }

    private JEWTDialog createPropertyDialog(String title, String helpTopic) {
        if (this.propertyPanel == null) {
            this.propertyPanel = this.createPropertyPanel();
        }
        HelpUtils.setHelpID((JComponent)this.propertyPanel, (String)helpTopic);
        JEWTDialog dialog = JEWTDialog.createDialog((Component)((Object)this), (String)title, (int)7);
        dialog.addVetoableChangeListener((VetoableChangeListener)new 9());
        dialog.setContent((Component)this.propertyPanel);
        dialog.setInitialFocus((Component)this.propertyNameField);
        return dialog;
    }

    private JPanel createPropertyPanel() {
        JPanel panel = new JPanel();
        JLabel nameLabel = new JLabel();
        JLabel valueLabel = new JLabel();
        this.propertyNameField = new JTextField(20);
        this.propertyValueField = new JTextField(20);
        JButton valueMacroButton = new JButton();
        valueMacroButton.addActionListener(new 10());
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.propertyNameField, (String)AntArb.getString(218));
        ResourceUtils.resLabel((JLabel)valueLabel, (Component)this.propertyValueField, (String)AntArb.getString(107));
        ResourceUtils.resButton((AbstractButton)valueMacroButton, (String)AntArb.getString(220));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 3, 5);
        gbc.weightx = 0.0;
        panel.add((Component)nameLabel, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        panel.add((Component)this.propertyNameField, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 3, 5);
        panel.add((Component)valueLabel, gbc);
        gbc.gridwidth = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        panel.add((Component)this.propertyValueField, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 3, 0);
        panel.add((Component)valueMacroButton, gbc);
        return panel;
    }

    private void chooseMacro(JTextField field) {
        MacroRegistry registry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
        MacroPicker picker = registry.getPicker((ExternalToolType)new AntExternalToolType(), false);
        MacroExpander macro = picker.runDialog((Component)((Object)this));
        if (macro != null) {
            try {
                field.getDocument().insertString(field.getCaretPosition(), macro.toMacroString(), null);
            }
            catch (BadLocationException ble) {
                ExceptionDialog.showExceptionDialog((Component)((Object)this), (Throwable)ble);
            }
        }
    }

    private void updatePropertyButtons() {
        if (!this.inRemove) {
            int count = this.propertyTable.getSelectedRowCount();
            this.removePropertyButton.setEnabled(count > 0);
            this.editPropertyButton.setEnabled(count == 1);
        }
    }

    private void updateFileButtons() {
        if (!this.inRemove) {
            int index = this.fileList.getSelectedIndex();
            this.removeFileButton.setEnabled(index != -1);
        }
    }

    private void validateProperty(PropertyChangeEvent e) throws PropertyVetoException {
        String name = this.propertyNameField.getText();
        String value = this.propertyValueField.getText();
        if (name == null || name.length() == 0 || value == null || value.length() == 0) {
            MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(129), (String)AntArb.getString(22), null);
            throw new PropertyVetoException("Name or value not specified", e);
        }
    }

    private void addPropertyFile() {
        URL initialURL = this.lastPropertyFile;
        if (initialURL == null && this.buildfile != null) {
            initialURL = URLFileSystem.getParent((URL)this.buildfile);
        }
        URLChooser chooser = initialURL != null ? DialogUtil.newURLChooser((URL)initialURL) : DialogUtil.newURLChooser();
        DefaultURLFilter filter = new DefaultURLFilter(AntArb.getString(143), ".properties");
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.setURLFilter((URLFilter)filter);
        int result = chooser.showOpenDialog((Component)((Object)this), AntArb.getString(70));
        if (result == 0) {
            URL[] urls = chooser.getSelectedURLs();
            DefaultListModel model = (DefaultListModel)this.fileList.getModel();
            int start = model.size();
            int end = start + urls.length - 1;
            int i = 0;
            while (i < urls.length) {
                URL url = urls[i];
                String file = URLFileSystem.getPlatformPathName((URL)url);
                if (!model.contains(file)) {
                    model.addElement(file);
                }
                ++i;
            }
            this.fileList.setSelectionInterval(start, end);
            this.updateFileButtons();
            this.lastPropertyFile = URLFileSystem.getParent((URL)urls[0]);
        }
    }

    private void removePropertyFile() {
        int[] selection = this.fileList.getSelectedIndices();
        DefaultListModel model = (DefaultListModel)this.fileList.getModel();
        try {
            this.inRemove = true;
            int index = 0;
            int i = selection.length - 1;
            while (i >= 0) {
                index = selection[i];
                model.remove(index);
                --i;
            }
            if ((index = Math.min(index, this.fileList.getModel().getSize() - 1)) >= 0) {
                this.fileList.setSelectedIndex(index);
            }
        }
        finally {
            this.inRemove = false;
            this.updateFileButtons();
        }
    }

    static JTextField ra$propertyValueField(AntPropertiesPage antPropertiesPage) {
        return antPropertiesPage.propertyValueField;
    }

    static void mav$chooseMacro(AntPropertiesPage antPropertiesPage, JTextField jTextField) {
        antPropertiesPage.chooseMacro(jTextField);
    }

    static void mav$validateProperty(AntPropertiesPage antPropertiesPage, PropertyChangeEvent propertyChangeEvent) {
        antPropertiesPage.validateProperty(propertyChangeEvent);
    }

    static void mav$updatePropertyButtons(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.updatePropertyButtons();
    }

    static void mav$addProperty(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.addProperty();
    }

    static void mav$editProperty(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.editProperty();
    }

    static void mav$removeProperty(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.removeProperty();
    }

    static void mav$updateFileButtons(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.updateFileButtons();
    }

    static void mav$addPropertyFile(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.addPropertyFile();
    }

    static void mav$removePropertyFile(AntPropertiesPage antPropertiesPage) {
        antPropertiesPage.removePropertyFile();
    }

    final class 1
    extends DefaultTableModel {
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public 1(Object[] objectArray, int n) {
            super(objectArray, n);
        }
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            AntPropertiesPage.mav$updatePropertyButtons(AntPropertiesPage.this);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AntPropertiesPage.mav$addProperty(AntPropertiesPage.this);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AntPropertiesPage.mav$editProperty(AntPropertiesPage.this);
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AntPropertiesPage.mav$removeProperty(AntPropertiesPage.this);
        }
    }

    final class 6
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            AntPropertiesPage.mav$updateFileButtons(AntPropertiesPage.this);
        }
    }

    final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AntPropertiesPage.mav$addPropertyFile(AntPropertiesPage.this);
        }
    }

    final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AntPropertiesPage.mav$removePropertyFile(AntPropertiesPage.this);
        }
    }

    final class 9
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                AntPropertiesPage.mav$validateProperty(AntPropertiesPage.this, e);
            }
        }
    }

    final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            AntPropertiesPage.mav$chooseMacro(AntPropertiesPage.this, AntPropertiesPage.ra$propertyValueField(AntPropertiesPage.this));
        }
    }

    private class PropertyCellRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setIcon(OracleIcons.getIcon((String)"attribute.png"));
            return this;
        }

        private PropertyCellRenderer() {
        }

        PropertyCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

