/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.Context;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Project;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntRunConfiguration;
import oracle.jdeveloper.ant.Target;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.runner.ui.AntRunConfigurationPage;
import oracle.jdevimpl.ant.runner.ui.AntTargetSelector;

public class AntTargetPage
extends AntRunConfigurationPage {
    private Context context;
    private AntTargetSelector targetSelector;
    private static final String[] PROPERTY_KEYS = new String[]{"targetList"};

    public AntTargetPage() {
        this.jbInit();
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void loadFrom(AntRunConfiguration antConfiguration) {
        Target defaultTarget;
        AntContext context = this.getAntContext(antConfiguration);
        List targets = context.getTargets();
        List selectedNames = antConfiguration.getTargetList();
        ArrayList<Target> selected = new ArrayList<Target>();
        for (String name : selectedNames) {
            Target target = context.getTarget(name);
            if (target == null) continue;
            selected.add(target);
        }
        if (selected.isEmpty() && (defaultTarget = context.getDefaultTarget()) != null) {
            selected.add(defaultTarget);
        }
        selected.trimToSize();
        this.targetSelector.setSelectedTargets(selected);
        ArrayList<Target> available = new ArrayList<Target>();
        for (Target target : targets) {
            if (selected.contains(target)) continue;
            available.add(target);
        }
        this.targetSelector.setAvailableTargets(available);
    }

    public void saveTo(AntRunConfiguration antConfiguration) {
        ArrayList<String> targets = new ArrayList<String>();
        for (Target target : this.targetSelector.getSelectedTargets()) {
            targets.add(target.getName());
        }
        targets.trimToSize();
        antConfiguration.setTargetList(targets);
    }

    public Component getInitialFocus() {
        return this.targetSelector.getInitialFocus();
    }

    public String getPageName() {
        return AntArb.getString(90);
    }

    public boolean isComplete() {
        return this.targetSelector.getSelectedTargets().size() > 0;
    }

    public boolean validateOptions() {
        if (this.targetSelector.getSelectedTargets().size() == 0) {
            MessageDialog.error((Component)((Object)this), (Object)AntArb.getString(52), (String)AntArb.getString(37), null);
            return false;
        }
        return true;
    }

    public String getPageHelpTopicID() {
        return "targets_html";
    }

    private void jbInit() {
        this.targetSelector = new AntTargetSelector();
        this.targetSelector.addListDataListener(new 1());
        this.setLayout(new BorderLayout(0, 10));
        this.add(this.targetSelector, "Center");
        JLabel instructions = new JLabel();
        instructions.setText("<html>" + AntArb.getString(192) + "</html>");
        this.add(instructions, "North");
    }

    private AntContext getAntContext(AntRunConfiguration antConfiguration) {
        URL url = antConfiguration.getBuildfile();
        Project project = this.context != null ? this.context.getProject() : null;
        return AntManager.getAntManager().getAntContext(url, project);
    }

    final class 1
    implements ListDataListener {
        public void intervalAdded(ListDataEvent e) {
            boolean isComplete = AntTargetPage.this.isComplete();
            AntTargetPage.this.firePropertyChange("isComplete", false, isComplete);
        }

        public void intervalRemoved(ListDataEvent e) {
            AntTargetPage.this.firePropertyChange("isComplete", true, AntTargetPage.this.isComplete());
        }

        public void contentsChanged(ListDataEvent e) {
            boolean isComplete = AntTargetPage.this.isComplete();
            AntTargetPage.this.firePropertyChange("isComplete", isComplete ^ true, isComplete);
        }
    }
}

