/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.runner.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.sort.Sort;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ide.externaltools.macro.MacroPicker;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.externaltools.AntExternalToolType;

public class EnvironmentPanel
extends JPanel {
    private NiceTable table;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private JPanel variablePanel;
    private JTextField variableName;
    private JTextField variableValue;
    private boolean inRemove;
    private static final String HELP_TOPIC = "f1_ant_edit_environment_dlg_html";
    private static final String ADD_VARIABLE_HELP_TOPIC = "f1_ant_add_environmentvar_dlg_html";
    private static final String EDIT_VARIABLE_HELP_TOPIC = "f1_ant_edit_environmentvar_dlg_html";
    private static final int INDEX_NAME = 0;
    private static final int INDEX_VALUE = 1;

    private void $init$() {
        this.inRemove = false;
    }

    public EnvironmentPanel() {
        this.$init$();
        this.jbInit();
    }

    public void setEnvironment(List names, List values) {
        DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
        int i = 0;
        while (i < names.size()) {
            tableModel.addRow(new String[]{(String)names.get(i), (String)values.get(i)});
            ++i;
        }
        if (tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public List getNames() {
        return this.getColumn(0);
    }

    public List getValues() {
        return this.getColumn(1);
    }

    public boolean runDialog() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_TOPIC);
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.table, (String)AntArb.getString(77));
        dialog.setDefaultButton(1);
        return WizardLauncher.runDialog((JDialog)dialog);
    }

    private void jbInit() {
        this.table = new NiceTable();
        this.table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.table.setResizeColumnOnDoubleClick(false);
        this.table.setColumnSelectorAvailable(false);
        this.table.setSorted(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        Object[] columnNames = new Object[]{AntArb.getString(49), AntArb.getString(166)};
        this.table.setModel((TableModel)new 1(columnNames, 0));
        this.table.getSelectionModel().addListSelectionListener(new 2());
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JLabel tableLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)tableLabel, (Component)this.table, (String)AntArb.getString(131));
        ButtonBar buttons = new ButtonBar();
        buttons.setOrientation(1);
        buttons.setAlignment(1);
        JButton addButton = new JButton();
        ResourceUtils.resButton((AbstractButton)addButton, (String)AntArb.getString(81));
        addButton.addActionListener(new 3());
        buttons.add((Component)addButton);
        this.editButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)AntArb.getString(115));
        this.editButton.addActionListener(new 4());
        buttons.add((Component)this.editButton);
        this.removeButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.removeButton, (String)AntArb.getString(4));
        this.removeButton.addActionListener(new 5());
        buttons.add((Component)this.removeButton);
        this.updateButtons();
        this.setLayout(new BorderLayout(8, 3));
        this.add((Component)tableLabel, "North");
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttons, "East");
    }

    private void updateButtons() {
        if (!this.inRemove) {
            int count = this.table.getSelectedRowCount();
            this.removeButton.setEnabled(count > 0);
            this.editButton.setEnabled(count == 1);
        }
    }

    private void addVariable() {
        JEWTDialog dialog = this.createVariableDialog(AntArb.getString(9), ADD_VARIABLE_HELP_TOPIC);
        this.variableName.setText(null);
        this.variableValue.setText(null);
        if (WizardLauncher.runDialog((JDialog)dialog)) {
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            model.addRow(new String[]{this.variableName.getText(), this.variableValue.getText()});
            int row = model.getRowCount() - 1;
            this.table.setRowSelectionInterval(row, row);
            this.table.scrollToSelection();
        }
    }

    private void editVariable() {
        int[] rows = this.table.getSelectedRows();
        if (rows != null) {
            int row = rows[0];
            JEWTDialog dialog = this.createVariableDialog(AntArb.getString(130), EDIT_VARIABLE_HELP_TOPIC);
            DefaultTableModel model = (DefaultTableModel)this.table.getModel();
            this.variableName.setText((String)model.getValueAt(row, 0));
            this.variableValue.setText((String)model.getValueAt(row, 1));
            if (WizardLauncher.runDialog((JDialog)dialog)) {
                model.setValueAt(this.variableName.getText(), row, 0);
                model.setValueAt(this.variableValue.getText(), row, 1);
                this.updateButtons();
            }
        }
    }

    private void removeVariable() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        int[] rows = this.table.getSelectedRows();
        if (rows != null) {
            try {
                this.inRemove = true;
                Sort.qSort((int[])rows, (int)rows.length, (boolean)false);
                int row = 0;
                int i = 0;
                while (i < rows.length) {
                    row = rows[i];
                    model.removeRow(row);
                    ++i;
                }
                if ((row = Math.min(row, this.table.getRowCount() - 1)) >= 0) {
                    this.table.setRowSelectionInterval(row, row);
                    this.table.scrollToSelection();
                }
            }
            finally {
                this.inRemove = false;
                this.updateButtons();
            }
        }
    }

    private List getColumn(int column) {
        DefaultTableModel tableModel = (DefaultTableModel)this.table.getModel();
        int rowCount = tableModel.getRowCount();
        ArrayList<Object> entries = new ArrayList<Object>(rowCount);
        int i = 0;
        while (i < rowCount) {
            entries.add(tableModel.getValueAt(i, column));
            ++i;
        }
        return entries;
    }

    private JEWTDialog createVariableDialog(String title, String helpTopic) {
        if (this.variablePanel == null) {
            this.variablePanel = this.createVariablePanel();
        }
        HelpUtils.setHelpID((JComponent)this.variablePanel, (String)helpTopic);
        JEWTDialog dialog = JEWTDialog.createDialog((Component)this, (String)title, (int)7);
        dialog.addVetoableChangeListener((VetoableChangeListener)new 6());
        dialog.setContent((Component)this.variablePanel);
        dialog.setInitialFocus((Component)this.variableName);
        return dialog;
    }

    private JPanel createVariablePanel() {
        JPanel panel = new JPanel();
        JLabel nameLabel = new JLabel();
        JLabel valueLabel = new JLabel();
        this.variableName = new JTextField(20);
        this.variableValue = new JTextField(20);
        JButton valueMacroButton = new JButton();
        valueMacroButton.addActionListener(new 7());
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.variableName, (String)AntArb.getString(58));
        ResourceUtils.resLabel((JLabel)valueLabel, (Component)this.variableValue, (String)AntArb.getString(80));
        ResourceUtils.resButton((AbstractButton)valueMacroButton, (String)AntArb.getString(5));
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 3, 5);
        gbc.weightx = 0.0;
        panel.add((Component)nameLabel, gbc);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        panel.add((Component)this.variableName, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 3, 5);
        panel.add((Component)valueLabel, gbc);
        gbc.gridwidth = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        panel.add((Component)this.variableValue, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 3, 0);
        panel.add((Component)valueMacroButton, gbc);
        return panel;
    }

    private void chooseMacro(JTextField field) {
        MacroRegistry registry = ExternalToolManager.getExternalToolManager().getMacroRegistry();
        MacroPicker picker = registry.getPicker((ExternalToolType)new AntExternalToolType(), false);
        MacroExpander macro = picker.runDialog((Component)this);
        if (macro != null) {
            try {
                field.getDocument().insertString(field.getCaretPosition(), macro.toMacroString(), null);
            }
            catch (BadLocationException ble) {
                ExceptionDialog.showExceptionDialog((Component)this, (Throwable)ble);
            }
        }
    }

    private void validateVariable(PropertyChangeEvent e) throws PropertyVetoException {
        String name = this.variableName.getText();
        String value = this.variableValue.getText();
        if (name == null || name.length() == 0 || value == null || value.length() == 0) {
            MessageDialog.error((Component)this, (Object)AntArb.getString(129), (String)AntArb.getString(22), null);
            throw new PropertyVetoException("Name or value not specified", e);
        }
    }

    static JTextField ra$variableValue(EnvironmentPanel environmentPanel) {
        return environmentPanel.variableValue;
    }

    static void mav$chooseMacro(EnvironmentPanel environmentPanel, JTextField jTextField) {
        environmentPanel.chooseMacro(jTextField);
    }

    static void mav$validateVariable(EnvironmentPanel environmentPanel, PropertyChangeEvent propertyChangeEvent) {
        environmentPanel.validateVariable(propertyChangeEvent);
    }

    static void mav$updateButtons(EnvironmentPanel environmentPanel) {
        environmentPanel.updateButtons();
    }

    static void mav$addVariable(EnvironmentPanel environmentPanel) {
        environmentPanel.addVariable();
    }

    static void mav$editVariable(EnvironmentPanel environmentPanel) {
        environmentPanel.editVariable();
    }

    static void mav$removeVariable(EnvironmentPanel environmentPanel) {
        environmentPanel.removeVariable();
    }

    final class 1
    extends DefaultTableModel {
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public 1(Object[] objectArray, int n) {
            super(objectArray, n);
        }
    }

    final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            EnvironmentPanel.mav$updateButtons(EnvironmentPanel.this);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            EnvironmentPanel.mav$addVariable(EnvironmentPanel.this);
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            EnvironmentPanel.mav$editVariable(EnvironmentPanel.this);
        }
    }

    final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            EnvironmentPanel.mav$removeVariable(EnvironmentPanel.this);
        }
    }

    final class 6
    implements VetoableChangeListener {
        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)e)) {
                EnvironmentPanel.mav$validateVariable(EnvironmentPanel.this, e);
            }
        }
    }

    final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            EnvironmentPanel.mav$chooseMacro(EnvironmentPanel.this, EnvironmentPanel.ra$variableValue(EnvironmentPanel.this));
        }
    }
}

