/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.validator;

import java.text.MessageFormat;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.validator.AntValidatorCallback;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class JavadocValidator
extends AntValidatorCallback {
    public boolean allRequiredAttributesHaveValue(Element element) {
        return this.hasDestDir(element) && this.hasSourcePath(element);
    }

    private boolean hasDestDir(Element element) {
        if (!this.hasChild(element, "doclet") && !this.hasAttribute(element, "doclet")) {
            return this.hasAttribute(element, "destdir");
        }
        return true;
    }

    private boolean hasSourcePath(Element element) {
        if (!(this.hasChild(element, "sourcepath") || this.hasChild(element, "fileset") || this.hasChild(element, "packageset"))) {
            return this.hasAttribute(element, "sourcepath") || this.hasAttribute(element, "sourcepathref") || this.hasAttribute(element, "sourcefiles");
        }
        return true;
    }

    public void validateElement(Element e, ErrorHandler eh) {
        if (!this.hasDestDir(e)) {
            MessageFormat formatter = new MessageFormat(AntArb.getString(202));
            String message = formatter.format(new Object[]{e.getLocalName()});
            this.error(eh, 0, message, e);
        }
        if (!this.hasSourcePath(e)) {
            MessageFormat formatter = new MessageFormat(AntArb.getString(186));
            String message = formatter.format(new Object[]{e.getLocalName()});
            this.error(eh, 0, message, e);
        }
    }
}

