/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.validator;

import java.text.MessageFormat;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.validator.AntValidatorCallback;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class TypedefValidator
extends AntValidatorCallback {
    public boolean allRequiredAttributesHaveValue(Element element) {
        return this.hasName(element) && this.hasClassname(element);
    }

    private boolean hasFile(Element element) {
        return this.hasAttribute(element, "file") || this.hasAttribute(element, "resource");
    }

    private boolean hasName(Element element) {
        if (!this.hasFile(element)) {
            return this.hasAttribute(element, "name");
        }
        return true;
    }

    private boolean hasClassname(Element element) {
        if (!this.hasFile(element)) {
            return this.hasAttribute(element, "classname");
        }
        return true;
    }

    public void validateElement(Element e, ErrorHandler eh) {
        boolean hasName = this.hasName(e);
        if (!hasName) {
            MessageFormat formatter = new MessageFormat(AntArb.getString(17));
            String message = formatter.format(new Object[]{e.getLocalName()});
            this.error(eh, 0, message, e);
        }
        if (hasName && !this.hasClassname(e)) {
            MessageFormat formatter = new MessageFormat(AntArb.getString(53));
            String message = formatter.format(new Object[]{e.getLocalName()});
            this.error(eh, 0, message, e);
        }
    }
}

