/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.wizard;

import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import oracle.bali.xml.dom.XmlDeclarationInfo;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.ant.AntBuildfile;
import oracle.jdeveloper.ant.AntContext;
import oracle.jdeveloper.ant.AntManager;
import oracle.jdeveloper.ant.AntNode;
import oracle.jdeveloper.ant.Target;
import oracle.jdeveloper.compiler.ant.AntConfiguration;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.AntBuildfileImpl;
import oracle.jdevimpl.ant.AntManagerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class AntGenerator {
    private URL buildfile;
    private Project project;
    private Document document;
    private Element projectElement;
    private URL base;
    private boolean useProjectBuildfile;
    private boolean includeDeploymentTasks;
    private URL propertyFile;

    public AntGenerator(URL buildfile) {
        this(null, false, false, buildfile, null);
    }

    public AntGenerator(Project project, boolean useProjectBuildfile, boolean includeDeploymentTasks, URL buildfile, URL propertyFile) {
        this.project = project;
        this.useProjectBuildfile = useProjectBuildfile;
        this.includeDeploymentTasks = includeDeploymentTasks;
        this.buildfile = buildfile;
        this.propertyFile = propertyFile;
    }

    public void generate(AntNode node) throws IOException {
        XmlModel model = node.getModel(this.project);
        model.getDomModel().setXmlDeclarationInfo(new XmlDeclarationInfo(XmlDeclarationInfo.VERSION_1_0, IdeUtil.getIdeIanaEncoding(), null));
        try {
            model.startTransaction("Generate Ant buildfile");
            this.document = model.getDocument();
            if (this.project != null) {
                this.generateFromProject();
            } else {
                this.generateEmptyProject();
            }
            model.getDomModel().setUnspecifiedAttribute(this.document.getDocumentElement(), "http://www.w3.org/2000/xmlns/", "xmlns", "antlib:org.apache.tools.ant");
        }
        finally {
            try {
                model.commitTransaction();
            }
            catch (XmlCommitException xce) {
                model.rollbackTransaction();
            }
            CommandProcessor.getInstance().flush((Object)node);
        }
        if (this.useProjectBuildfile) {
            this.setProjectBuildfile((Node)node);
        }
    }

    private void generateEmptyProject() throws IOException {
        this.projectElement = this.document.createElementNS("antlib:org.apache.tools.ant", "project");
        this.projectElement.setAttributeNS(null, "default", "init");
        this.document.appendChild(this.projectElement);
        AntBuildfileImpl antFile = new AntBuildfileImpl(this.buildfile, this.document);
        this.createInitTarget(antFile, false);
    }

    private void generateFromProject() throws IOException {
        AntBuildfileImpl antFile = new AntBuildfileImpl(this.buildfile, this.document);
        this.createHeader(antFile);
        this.createProject(antFile);
        this.createPropertyFile(antFile);
        this.createOracleHome(antFile);
        this.createOutputDir(antFile);
        this.createTargets(antFile);
        this.runGenerators(antFile);
        antFile.saveProperties(this.propertyFile);
    }

    private void runGenerators(AntBuildfile buildfile) {
        for (oracle.jdeveloper.ant.AntGenerator generator : ((AntManagerImpl)AntManager.getAntManager()).getGenerators()) {
            generator.generate(this.project, buildfile);
        }
    }

    private void createHeader(AntBuildfile buildfile) {
        this.createComment(this.document, AntArb.getString(38));
        String date = DateFormat.getDateTimeInstance().format(new Date());
        this.createComment(this.document, AntArb.format(128, date));
    }

    private void createProject(AntBuildfile buildfile) {
        String name = URLFileSystem.getName((URL)this.project.getURL());
        this.projectElement = this.document.createElementNS("antlib:org.apache.tools.ant", "project");
        this.projectElement.setAttributeNS(null, "name", name);
        this.projectElement.setAttributeNS(null, "default", "all");
        this.base = URLFileSystem.getParent((URL)this.project.getURL());
        String basedir = buildfile.getRelativePath(this.base);
        this.projectElement.setAttributeNS(null, "basedir", basedir);
        this.document.appendChild(this.projectElement);
    }

    private void createPropertyFile(AntBuildfile buildfile) {
        Element property = this.document.createElementNS("antlib:org.apache.tools.ant", "property");
        property.setAttributeNS(null, "file", buildfile.getRelativePath(this.propertyFile));
        buildfile.appendBeforeTargets(property);
    }

    private void createOracleHome(AntBuildfile buildfile) {
        URL basedir;
        URL oracle = URLFactory.newDirURL((String)Ide.getOracleHomeDirectory());
        String path = URLFileSystem.toRelativeSpec((URL)oracle, (URL)(basedir = URLFileSystem.getParent((URL)this.buildfile)), (boolean)false);
        if (path.equals(oracle.getPath())) {
            path = URLFileSystem.getPlatformPathName((URL)oracle);
        }
        buildfile.addGlobalProperty("oracle.home", path);
    }

    private void createOutputDir(AntBuildfile buildfile) {
        String output = buildfile.getRelativePath(JavaProject.getInstance((Project)this.project).getOutputDirectory());
        buildfile.addGlobalProperty("output.dir", output);
    }

    private void createTargets(AntBuildfile buildfile) {
        this.createInitTarget(buildfile, true);
        buildfile.createTarget("all", "Build the project");
        this.createCleanTarget(buildfile);
        if (this.includeDeploymentTasks) {
            this.createDeployTarget(buildfile);
        }
    }

    private void createInitTarget(AntBuildfile buildfile, boolean createDir) {
        Element target = buildfile.createTarget("init");
        Element tstamp = this.document.createElementNS("antlib:org.apache.tools.ant", "tstamp");
        target.appendChild(tstamp);
        if (createDir) {
            Element mkdir = this.document.createElementNS("antlib:org.apache.tools.ant", "mkdir");
            mkdir.setAttributeNS(null, "dir", buildfile.createPropertyReference("output.dir"));
            target.appendChild(mkdir);
        }
    }

    private void createCleanTarget(AntBuildfile buildfile) {
        Element target = buildfile.createTarget("clean", "Clean the project");
        Element delete = this.document.createElementNS("antlib:org.apache.tools.ant", "delete");
        delete.setAttributeNS(null, "includeemptydirs", "true");
        delete.setAttributeNS(null, "quiet", "true");
        Element fileset = this.document.createElementNS("antlib:org.apache.tools.ant", "fileset");
        fileset.setAttributeNS(null, "dir", buildfile.createPropertyReference("output.dir"));
        fileset.setAttributeNS(null, "includes", "**/*");
        delete.appendChild(fileset);
        target.appendChild(delete);
    }

    private void createDeployTarget(AntBuildfile buildFile) {
        buildFile.createTarget("deploy", "Deploy JDeveloper profiles", new String[]{"init"});
        if (buildFile.getTarget("all") != null) {
            buildFile.addDependency("all", "deploy");
        }
    }

    private void createComment(org.w3c.dom.Node parent, String comment) {
        parent.appendChild(this.document.createComment(comment));
    }

    private void setProjectBuildfile(Node node) {
        AntConfiguration config = AntConfiguration.getAntConfiguration((PropertyStorage)this.project);
        if (config != null) {
            config.setProjectBuildfile(node.getURL());
            config.setMakeTarget("all");
            ArrayList<String> mainTargets = new ArrayList<String>();
            AntContext context = AntManager.getAntManager().getAntContext(node.getURL(), this.project);
            if (context != null) {
                for (Target target : context.getTargets()) {
                    if (target.getDescription() == null) continue;
                    mainTargets.add(target.getName());
                }
            }
            mainTargets.trimToSize();
            Collections.sort(mainTargets);
            config.setTargetList(mainTargets);
            this.project.markDirty(true);
        }
    }
}

