/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.ant.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.ide.component.NewFilePanel;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.file.FileBuilderPanel;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;
import oracle.jdevimpl.ant.AntArb;
import oracle.jdevimpl.ant.wizard.GenerateBuildfileModel;

public class GenerateBuildfilePanel
extends JPanel
implements BaliWizardPanel {
    private FileBuilderPanel filePanel;
    private JCheckBox useProjectBuildfile;
    private JCheckBox includeDeploymentTasks;

    private void $init$() {
        this.filePanel = new FileBuilderPanel();
        this.useProjectBuildfile = new JCheckBox();
        this.includeDeploymentTasks = new JCheckBox();
    }

    public GenerateBuildfilePanel() {
        this.$init$();
        ResourceUtils.resButton((AbstractButton)this.useProjectBuildfile, (String)AntArb.getString(127));
        this.useProjectBuildfile.setSelected(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)((Object)this.filePanel), gbc);
        gbc.gridy = -1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.useProjectBuildfile, gbc);
        ResourceUtils.resButton((AbstractButton)this.includeDeploymentTasks, (String)AntArb.getString(168));
        this.add((Component)this.includeDeploymentTasks, gbc);
    }

    public void initializeFromState(BaliWizardState state) {
        this.filePanel.initializeFromState(state);
        this.initializeDeploymentTaskOption((FileBuilderModel)state);
    }

    public boolean validateAndWriteToState(BaliWizardState state) {
        if (this.filePanel.validateAndWriteToState(state)) {
            GenerateBuildfileModel model = (GenerateBuildfileModel)state;
            model.setUseProjectBuildfile(this.useProjectBuildfile.isSelected());
            model.setAddDeploymentTasks(this.includeDeploymentTasks.isSelected());
            try {
                URL url = this.getPropertyFileURL(model);
                if (url != null) {
                    model.setPropertyFileURL(url);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (TraversalException ex) {
                ex.showMessageDialog((Component)this);
            }
        }
        return false;
    }

    private URL getPropertyFileURL(GenerateBuildfileModel model) throws TraversalException {
        URL buildfile = model.getURL();
        URL propertyFile = URLFactory.newFileURL((String)(URLFileSystem.getPathNoExt((URL)buildfile) + ".properties"));
        return NewFilePanel.validateURL((Component)this, (URL)propertyFile, (String)AntArb.getString(120), (boolean)true);
    }

    private void initializeDeploymentTaskOption(FileBuilderModel model) {
        Project project = model.getProject();
        DeploymentProfiles profiles = DeploymentProfiles.getInstance((DataContainer)project);
        this.includeDeploymentTasks.setEnabled(profiles.getProfileNames().size() != 0);
    }
}

