/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.java;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.parser.java.v2.BindingRegistry;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.NodeBinding;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.scanner.LexerLiteral;

public class ConstantExpressionEvaluator {
    private static final int BINDING_CONSTANT;
    private static final int TYPE_BYTE = 1;
    private static final int TYPE_CHAR = 2;
    private static final int TYPE_SHORT = 3;
    private static final int TYPE_INT = 4;
    private static final int TYPE_LONG = 5;
    private static final int TYPE_FLOAT = 6;
    private static final int TYPE_DOUBLE = 7;
    private static final int TYPE_BOOLEAN = 8;
    private static final int TYPE_STRING = 9;
    private static final int TYPE_INVALID = 10;
    private static final Map TYPES;
    private static final ConstantValue PENDING_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Object evaluate(SourceExpression expression) {
        Object object = ConstantExpressionEvaluator.evaluateCached(expression);
        if (object instanceof CharacterNumber) {
            object = new Character(((CharacterNumber)object).charValue());
        }
        return object;
    }

    public static Object evaluate(JavaVariable variable) {
        if (!variable.isFinal()) {
            return null;
        }
        if (variable instanceof SourceVariable) {
            SourceExpression initializer = ((SourceVariable)variable).getInitializer();
            if (initializer == null) {
                return null;
            }
            return ConstantExpressionEvaluator.evaluate(initializer);
        }
        JavaType type = variable.getResolvedType();
        if (!type.isPrimitive() && !"java.lang.String".equals(type.getQualifiedName())) {
            return null;
        }
        return variable.getConstantValue();
    }

    static {
        $assertionsDisabled = ConstantExpressionEvaluator.class.desiredAssertionStatus() ^ true;
        BINDING_CONSTANT = BindingRegistry.register((String)"audit-constant-value");
        TYPES = new HashMap();
        TYPES.put(Boolean.class, new Integer(8));
        TYPES.put(Byte.class, new Integer(1));
        TYPES.put(Character.class, new Integer(2));
        TYPES.put(CharacterNumber.class, new Integer(2));
        TYPES.put(Short.class, new Integer(3));
        TYPES.put(Integer.class, new Integer(4));
        TYPES.put(Long.class, new Integer(5));
        TYPES.put(Float.class, new Integer(6));
        TYPES.put(Double.class, new Integer(7));
        TYPES.put(String.class, new Integer(9));
        TYPES.put(Boolean.class.getName(), new Integer(8));
        TYPES.put(Byte.class.getName(), new Integer(1));
        TYPES.put(Character.class.getName(), new Integer(2));
        TYPES.put(CharacterNumber.class.getName(), new Integer(2));
        TYPES.put(Short.class.getName(), new Integer(3));
        TYPES.put(Integer.class.getName(), new Integer(4));
        TYPES.put(Long.class.getName(), new Integer(5));
        TYPES.put(Float.class.getName(), new Integer(6));
        TYPES.put(Double.class.getName(), new Integer(7));
        TYPES.put(String.class.getName(), new Integer(9));
        PENDING_VALUE = new ConstantValue(null);
    }

    private static int constantType(Object object) {
        if (object == null) {
            return 10;
        }
        return ConstantExpressionEvaluator.constantType(object.getClass());
    }

    private static int constantType(Class type) {
        Integer code = (Integer)TYPES.get(type);
        if (code == null) {
            return 10;
        }
        return code;
    }

    private static int constantType(JavaType type) {
        if (type == null || !type.isPrimitive()) {
            return 10;
        }
        switch (((PrimitiveType)type).primCode) {
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 0: {
                return 8;
            }
        }
        return 10;
    }

    private static int unaryPromotedType(int operandType) {
        int type = 4;
        if (operandType > type) {
            type = operandType;
        }
        return type;
    }

    private static int binaryPromotedType(int leftType, int rightType) {
        int type = 4;
        if (leftType > type) {
            type = leftType;
        }
        if (rightType > type) {
            type = rightType;
        }
        return type;
    }

    private static Object evaluateCached(SourceExpression expression) {
        if (expression == null) {
            return null;
        }
        ConstantValue binding = (ConstantValue)expression.getBinding(BINDING_CONSTANT);
        if (binding == PENDING_VALUE) {
            return null;
        }
        if (binding != null) {
            return binding.getValue();
        }
        expression.setBinding((NodeBinding)PENDING_VALUE);
        Object value = ConstantExpressionEvaluator.evaluateUncached(expression);
        expression.setBinding((NodeBinding)new ConstantValue(value));
        return value;
    }

    private static Object evaluateUncached(SourceExpression expression) {
        if (expression == null) {
            return null;
        }
        switch (expression.getSymbolKind()) {
            case 52: {
                LexerLiteral literal = ((SourceLiteralExpression)expression).getLiteral();
                if (literal == null) {
                    return null;
                }
                switch (literal.literalToken) {
                    case 12: {
                        return literal.literalBoolean ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 13: {
                        return new CharacterNumber(literal.literalChar);
                    }
                    case 9: {
                        return new Long(literal.literalInteger);
                    }
                    case 8: {
                        return new Integer((int)literal.literalInteger);
                    }
                    case 11: {
                        return new Double(literal.literalFloat);
                    }
                    case 10: {
                        return new Float((float)literal.literalFloat);
                    }
                    case 14: {
                        return literal.literalString;
                    }
                }
                return null;
            }
            case 59: {
                Object operand = ConstantExpressionEvaluator.evaluateCached(expression.getSecondOperand());
                int fromType = ConstantExpressionEvaluator.constantType(operand);
                int toType = ConstantExpressionEvaluator.constantType(expression.getResolvedType());
                switch (toType) {
                    case 8: {
                        switch (fromType) {
                            case 8: {
                                return operand;
                            }
                        }
                        return null;
                    }
                    case 1: {
                        switch (fromType) {
                            case 1: {
                                return operand;
                            }
                            case 2: {
                                return new Byte(((Number)operand).byteValue());
                            }
                            case 3: {
                                return new Byte(((Number)operand).byteValue());
                            }
                            case 4: {
                                return new Byte(((Number)operand).byteValue());
                            }
                            case 5: {
                                return new Byte(((Number)operand).byteValue());
                            }
                            case 6: {
                                return new Byte(((Number)operand).byteValue());
                            }
                            case 7: {
                                return new Byte(((Number)operand).byteValue());
                            }
                        }
                        return null;
                    }
                    case 2: {
                        switch (fromType) {
                            case 1: {
                                return new CharacterNumber((char)((Number)operand).byteValue());
                            }
                            case 2: {
                                if (!$assertionsDisabled && operand instanceof Character) {
                                    throw new AssertionError();
                                }
                                return operand;
                            }
                            case 3: {
                                return new CharacterNumber((char)((Number)operand).shortValue());
                            }
                            case 4: {
                                return new CharacterNumber((char)((Number)operand).intValue());
                            }
                            case 5: {
                                return new CharacterNumber((char)((Number)operand).longValue());
                            }
                            case 6: {
                                return new CharacterNumber((char)((Number)operand).floatValue());
                            }
                            case 7: {
                                return new CharacterNumber((char)((Number)operand).doubleValue());
                            }
                        }
                        return null;
                    }
                    case 3: {
                        switch (fromType) {
                            case 1: {
                                return new Short(((Number)operand).shortValue());
                            }
                            case 2: {
                                return new Short(((Number)operand).shortValue());
                            }
                            case 3: {
                                return operand;
                            }
                            case 4: {
                                return new Short(((Number)operand).shortValue());
                            }
                            case 5: {
                                return new Short(((Number)operand).shortValue());
                            }
                            case 6: {
                                return new Short(((Number)operand).shortValue());
                            }
                            case 7: {
                                return new Short(((Number)operand).shortValue());
                            }
                        }
                        return null;
                    }
                    case 4: {
                        switch (fromType) {
                            case 1: {
                                return new Integer(((Number)operand).intValue());
                            }
                            case 2: {
                                return new Integer(((Number)operand).intValue());
                            }
                            case 3: {
                                return new Integer(((Number)operand).intValue());
                            }
                            case 4: {
                                return operand;
                            }
                            case 5: {
                                return new Integer(((Number)operand).intValue());
                            }
                            case 6: {
                                return new Integer(((Number)operand).intValue());
                            }
                            case 7: {
                                return new Integer(((Number)operand).intValue());
                            }
                        }
                        return null;
                    }
                    case 5: {
                        switch (fromType) {
                            case 1: {
                                return new Long(((Number)operand).longValue());
                            }
                            case 2: {
                                return new Long(((Number)operand).longValue());
                            }
                            case 3: {
                                return new Long(((Number)operand).longValue());
                            }
                            case 4: {
                                return new Long(((Number)operand).longValue());
                            }
                            case 5: {
                                return operand;
                            }
                            case 6: {
                                return new Long(((Number)operand).longValue());
                            }
                            case 7: {
                                return new Long(((Number)operand).longValue());
                            }
                        }
                        return null;
                    }
                    case 6: {
                        switch (fromType) {
                            case 1: {
                                return new Float(((Number)operand).floatValue());
                            }
                            case 2: {
                                return new Float(((Number)operand).floatValue());
                            }
                            case 3: {
                                return new Float(((Number)operand).floatValue());
                            }
                            case 4: {
                                return new Float(((Number)operand).floatValue());
                            }
                            case 5: {
                                return new Float(((Number)operand).floatValue());
                            }
                            case 6: {
                                return operand;
                            }
                            case 7: {
                                return new Float(((Number)operand).floatValue());
                            }
                        }
                        return null;
                    }
                    case 7: {
                        switch (fromType) {
                            case 1: {
                                return new Double(((Number)operand).doubleValue());
                            }
                            case 2: {
                                return new Double(((Number)operand).doubleValue());
                            }
                            case 3: {
                                return new Double(((Number)operand).doubleValue());
                            }
                            case 4: {
                                return new Double(((Number)operand).doubleValue());
                            }
                            case 5: {
                                return new Double(((Number)operand).doubleValue());
                            }
                            case 6: {
                                return new Double(((Number)operand).doubleValue());
                            }
                            case 7: {
                                return operand;
                            }
                        }
                        return null;
                    }
                    case 9: {
                        switch (fromType) {
                            case 9: {
                                return operand;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 60: {
                Object operand = ConstantExpressionEvaluator.evaluateCached(expression.getFirstOperand());
                int type = ConstantExpressionEvaluator.unaryPromotedType(ConstantExpressionEvaluator.constantType(operand));
                switch (expression.getOperatorCode()) {
                    case 44: {
                        switch (type) {
                            case 4: {
                                return new Integer(((Number)operand).intValue());
                            }
                            case 5: {
                                return operand;
                            }
                            case 6: {
                                return operand;
                            }
                            case 7: {
                                return operand;
                            }
                        }
                        return null;
                    }
                    case 37: {
                        switch (type) {
                            case 4: {
                                return new Integer(-((Number)operand).intValue());
                            }
                            case 5: {
                                return new Long(-((Number)operand).longValue());
                            }
                            case 6: {
                                return new Float(-((Number)operand).floatValue());
                            }
                            case 7: {
                                return new Double(-((Number)operand).doubleValue());
                            }
                        }
                        return null;
                    }
                    case 9: {
                        switch (type) {
                            case 4: {
                                return new Integer(~((Number)operand).intValue());
                            }
                            case 5: {
                                return new Long(((Number)operand).longValue() ^ (long)-1);
                            }
                        }
                        return null;
                    }
                    case 41: {
                        switch (type) {
                            case 8: {
                                return (Boolean)operand != false ? Boolean.FALSE : Boolean.TRUE;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 50: {
                Object left = ConstantExpressionEvaluator.evaluateCached(expression.getFirstOperand());
                int leftType = ConstantExpressionEvaluator.constantType(left);
                Object right = ConstantExpressionEvaluator.evaluateCached(expression.getSecondOperand());
                int rightType = ConstantExpressionEvaluator.constantType(right);
                int promotedType = ConstantExpressionEvaluator.binaryPromotedType(leftType, rightType);
                switch (expression.getOperatorCode()) {
                    case 35: {
                        switch (promotedType) {
                            case 4: {
                                return new Integer(((Number)left).intValue() * ((Number)right).intValue());
                            }
                            case 5: {
                                return new Long(((Number)left).longValue() * ((Number)right).longValue());
                            }
                            case 6: {
                                return new Float(((Number)left).floatValue() * ((Number)right).floatValue());
                            }
                            case 7: {
                                return new Double(((Number)left).doubleValue() * ((Number)right).doubleValue());
                            }
                        }
                        return null;
                    }
                    case 17: {
                        switch (promotedType) {
                            case 4: {
                                int i = ((Number)right).intValue();
                                return i != 0 ? new Integer(((Number)left).intValue() / i) : null;
                            }
                            case 5: {
                                long l = ((Number)right).longValue();
                                return l != 0L ? new Long(((Number)left).longValue() / l) : null;
                            }
                            case 6: {
                                float f = ((Number)right).floatValue();
                                return f != 0.0f ? new Float(((Number)left).floatValue() / f) : null;
                            }
                            case 7: {
                                double d = ((Number)right).doubleValue();
                                return d != 0.0 ? new Double(((Number)left).doubleValue() / d) : null;
                            }
                        }
                        return null;
                    }
                    case 33: {
                        switch (promotedType) {
                            case 4: {
                                int i = ((Number)right).intValue();
                                return i != 0 ? new Integer(((Number)left).intValue() % i) : null;
                            }
                            case 5: {
                                long l = ((Number)right).longValue();
                                return l != 0L ? new Long(((Number)left).longValue() % l) : null;
                            }
                            case 6: {
                                float f = ((Number)right).floatValue();
                                return f != 0.0f ? new Float(((Number)left).floatValue() % f) : null;
                            }
                            case 7: {
                                double d = ((Number)right).doubleValue();
                                return d != 0.0 ? new Double(((Number)left).doubleValue() % d) : null;
                            }
                        }
                        return null;
                    }
                    case 1: {
                        switch (promotedType) {
                            case 4: {
                                return new Integer(((Number)left).intValue() + ((Number)right).intValue());
                            }
                            case 5: {
                                return new Long(((Number)left).longValue() + ((Number)right).longValue());
                            }
                            case 6: {
                                return new Float(((Number)left).floatValue() + ((Number)right).floatValue());
                            }
                            case 7: {
                                return new Double(((Number)left).doubleValue() + ((Number)right).doubleValue());
                            }
                            case 9: {
                                return (String.valueOf(left) + String.valueOf(right)).intern();
                            }
                        }
                        return null;
                    }
                    case 31: {
                        switch (promotedType) {
                            case 4: {
                                return new Integer(((Number)left).intValue() - ((Number)right).intValue());
                            }
                            case 5: {
                                return new Long(((Number)left).longValue() - ((Number)right).longValue());
                            }
                            case 6: {
                                return new Float(((Number)left).floatValue() - ((Number)right).floatValue());
                            }
                            case 7: {
                                return new Double(((Number)left).doubleValue() - ((Number)right).doubleValue());
                            }
                        }
                        return null;
                    }
                    case 28: {
                        switch (ConstantExpressionEvaluator.unaryPromotedType(leftType)) {
                            case 4: {
                                if (rightType <= 5) {
                                    return new Integer(((Number)left).intValue() << ((Number)left).intValue());
                                }
                                return null;
                            }
                            case 5: {
                                if (rightType <= 5) {
                                    return new Long(((Number)left).longValue() << ((Number)left).intValue());
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 51: {
                        switch (ConstantExpressionEvaluator.unaryPromotedType(leftType)) {
                            case 4: {
                                if (rightType <= 5) {
                                    return new Integer(((Number)left).intValue() >> ((Number)left).intValue());
                                }
                                return null;
                            }
                            case 5: {
                                if (rightType <= 5) {
                                    return new Long(((Number)left).longValue() >> ((Number)left).intValue());
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 56: {
                        switch (ConstantExpressionEvaluator.unaryPromotedType(leftType)) {
                            case 4: {
                                if (rightType <= 5) {
                                    return new Integer(((Number)left).intValue() >>> ((Number)left).intValue());
                                }
                                return null;
                            }
                            case 5: {
                                if (rightType <= 5) {
                                    return new Long(((Number)left).longValue() >>> ((Number)left).intValue());
                                }
                                return null;
                            }
                        }
                        return null;
                    }
                    case 30: {
                        switch (promotedType) {
                            case 4: {
                                return ((Number)left).intValue() < ((Number)right).intValue();
                            }
                            case 5: {
                                return ((Number)left).longValue() < ((Number)right).longValue();
                            }
                            case 6: {
                                return ((Number)left).floatValue() < ((Number)right).floatValue();
                            }
                            case 7: {
                                return ((Number)left).doubleValue() < ((Number)right).doubleValue();
                            }
                        }
                        return null;
                    }
                    case 25: {
                        switch (promotedType) {
                            case 4: {
                                return ((Number)left).intValue() <= ((Number)right).intValue();
                            }
                            case 5: {
                                return ((Number)left).longValue() <= ((Number)right).longValue();
                            }
                            case 6: {
                                return ((Number)left).floatValue() <= ((Number)right).floatValue();
                            }
                            case 7: {
                                return ((Number)left).doubleValue() <= ((Number)right).doubleValue();
                            }
                        }
                        return null;
                    }
                    case 22: {
                        switch (promotedType) {
                            case 4: {
                                return ((Number)left).intValue() > ((Number)right).intValue();
                            }
                            case 5: {
                                return ((Number)left).longValue() > ((Number)right).longValue();
                            }
                            case 6: {
                                return ((Number)left).floatValue() > ((Number)right).floatValue();
                            }
                            case 7: {
                                return ((Number)left).doubleValue() > ((Number)right).doubleValue();
                            }
                        }
                        return null;
                    }
                    case 21: {
                        switch (promotedType) {
                            case 4: {
                                return ((Number)left).intValue() >= ((Number)right).intValue();
                            }
                            case 5: {
                                return ((Number)left).longValue() >= ((Number)right).longValue();
                            }
                            case 6: {
                                return ((Number)left).floatValue() >= ((Number)right).floatValue();
                            }
                            case 7: {
                                return ((Number)left).doubleValue() >= ((Number)right).doubleValue();
                            }
                        }
                        return null;
                    }
                    case 20: {
                        switch (promotedType) {
                            case 4: {
                                return ((Number)left).intValue() == ((Number)right).intValue();
                            }
                            case 5: {
                                return ((Number)left).longValue() == ((Number)right).longValue();
                            }
                            case 6: {
                                return ((Number)left).floatValue() == ((Number)right).floatValue();
                            }
                            case 7: {
                                return ((Number)left).doubleValue() == ((Number)right).doubleValue();
                            }
                            case 8: {
                                return leftType == rightType ? Boolean.valueOf(left.equals(right)) : null;
                            }
                            case 9: {
                                return leftType == rightType ? Boolean.valueOf(left == right) : null;
                            }
                        }
                        return null;
                    }
                    case 42: {
                        switch (promotedType) {
                            case 4: {
                                return ((Number)left).intValue() != ((Number)right).intValue();
                            }
                            case 5: {
                                return ((Number)left).longValue() != ((Number)right).longValue();
                            }
                            case 6: {
                                return ((Number)left).floatValue() != ((Number)right).floatValue();
                            }
                            case 7: {
                                return ((Number)left).doubleValue() != ((Number)right).doubleValue();
                            }
                            case 8: {
                                return leftType == rightType ? Boolean.valueOf(left.equals(right) ^ true) : null;
                            }
                            case 9: {
                                return leftType == rightType ? Boolean.valueOf(left != right) : null;
                            }
                        }
                        return null;
                    }
                    case 7: {
                        switch (promotedType) {
                            case 4: {
                                return new Integer(((Number)left).intValue() & ((Number)right).intValue());
                            }
                            case 5: {
                                return new Long(((Number)left).longValue() & ((Number)right).longValue());
                            }
                            case 8: {
                                return leftType == rightType ? Boolean.valueOf((Boolean)left & (Boolean)right) : null;
                            }
                        }
                        return null;
                    }
                    case 12: {
                        switch (promotedType) {
                            case 4: {
                                return new Integer(((Number)left).intValue() ^ ((Number)right).intValue());
                            }
                            case 5: {
                                return new Long(((Number)left).longValue() ^ ((Number)right).longValue());
                            }
                            case 8: {
                                return leftType == rightType ? Boolean.valueOf((Boolean)left ^ (Boolean)right) : null;
                            }
                        }
                        return null;
                    }
                    case 10: {
                        switch (promotedType) {
                            case 4: {
                                return new Integer(((Number)left).intValue() | ((Number)right).intValue());
                            }
                            case 5: {
                                return new Long(((Number)left).longValue() | ((Number)right).longValue());
                            }
                            case 8: {
                                return leftType == rightType ? Boolean.valueOf((Boolean)left | (Boolean)right) : null;
                            }
                        }
                        return null;
                    }
                    case 3: {
                        switch (leftType) {
                            case 8: {
                                return rightType == 8 ? Boolean.valueOf((Boolean)left != false && (Boolean)right != false) : null;
                            }
                        }
                        return null;
                    }
                    case 43: {
                        switch (leftType) {
                            case 8: {
                                return rightType == 8 ? Boolean.valueOf((Boolean)left != false || (Boolean)right != false) : null;
                            }
                        }
                        return null;
                    }
                }
                return null;
            }
            case 56: {
                int greaterType;
                Object greater;
                int lesserType;
                Object choice;
                Object condition = ConstantExpressionEvaluator.evaluateCached(expression.getFirstOperand());
                if (ConstantExpressionEvaluator.constantType(condition) != 8) {
                    return null;
                }
                Object left = ConstantExpressionEvaluator.evaluateCached(expression.getSecondOperand());
                int leftType = ConstantExpressionEvaluator.constantType(left);
                Object right = ConstantExpressionEvaluator.evaluateCached(expression.getThirdOperand());
                int rightType = ConstantExpressionEvaluator.constantType(right);
                Object object = choice = (Boolean)condition != false ? left : right;
                if (leftType == rightType) {
                    return choice;
                }
                if (leftType < rightType) {
                    lesserType = leftType;
                    greater = right;
                    greaterType = rightType;
                } else {
                    lesserType = rightType;
                    greater = left;
                    greaterType = leftType;
                }
                switch (greaterType) {
                    case 2: {
                        switch (lesserType) {
                            case 1: {
                                return new Integer(((Number)choice).intValue());
                            }
                        }
                        throw new InternalError();
                    }
                    case 3: {
                        switch (lesserType) {
                            case 1: {
                                return new Short(((Number)choice).shortValue());
                            }
                            case 2: {
                                return new Integer(((Number)choice).intValue());
                            }
                        }
                        throw new InternalError();
                    }
                    case 4: {
                        int value = ((Number)greater).intValue();
                        switch (lesserType) {
                            case 1: {
                                if (value >= -128 && value <= 127) {
                                    return new Byte(((Number)choice).byteValue());
                                }
                                return new Integer(((Number)choice).intValue());
                            }
                            case 2: {
                                if (value >= 0 && value <= 65535) {
                                    return new CharacterNumber((char)((Number)choice).intValue());
                                }
                                return new Integer(((Number)choice).intValue());
                            }
                            case 3: {
                                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                                    return new Short(((Number)choice).shortValue());
                                }
                                return new Integer(((Number)choice).intValue());
                            }
                        }
                        throw new InternalError();
                    }
                    case 5: {
                        return new Long(((Number)choice).longValue());
                    }
                    case 6: {
                        return new Float(((Number)choice).floatValue());
                    }
                    case 7: {
                        return new Double(((Number)choice).doubleValue());
                    }
                }
                return null;
            }
            case 61: {
                return ConstantExpressionEvaluator.evaluateCached(expression.getFirstOperand());
            }
            case 49: 
            case 57: {
                JavaHasType object = expression.getResolvedObject();
                if (!(object instanceof JavaVariable)) {
                    return null;
                }
                JavaVariable variable = (JavaVariable)object;
                if (!variable.isFinal()) {
                    return null;
                }
                if (object instanceof SourceVariable) {
                    return ConstantExpressionEvaluator.evaluateCached(((SourceVariable)object).getInitializer());
                }
                Object value = variable.getConstantValue();
                if (value instanceof Character) {
                    value = new CharacterNumber((Character)value);
                }
                return value;
            }
        }
        return null;
    }

    static int ra$BINDING_CONSTANT() {
        return BINDING_CONSTANT;
    }

    private static class CharacterNumber
    extends Number {
        private final char value;

        public CharacterNumber(char value) {
            this.value = value;
        }

        public CharacterNumber(Character value) {
            this.value = value.charValue();
        }

        public char charValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.value;
        }

        public float floatValue() {
            return this.value;
        }

        public int intValue() {
            return this.value;
        }

        public long longValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ConstantValue
    implements NodeBinding {
        private Object value;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = ConstantValue.class.desiredAssertionStatus() ^ true;
        }

        public ConstantValue(Object value) {
            if (!$assertionsDisabled && value instanceof Character) {
                throw new AssertionError();
            }
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public int getBindingType() {
            return ConstantExpressionEvaluator.ra$BINDING_CONSTANT();
        }
    }
}

