/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.java;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;

public abstract class CreateFileCommand
extends Command {
    private Workspace workspace;
    private Project project;
    private URL url;
    private boolean done;
    private List createdDirectories;

    protected CreateFileCommand(int cmdId, String name, URL url, Project project, Workspace workspace) {
        super(cmdId, 3, name);
        this.workspace = workspace;
        this.project = project;
        this.url = url;
        this.context = new Context();
        this.context.setWorkspace(workspace);
        this.context.setProject(project);
        this.setContext(this.context);
    }

    protected abstract void doCreateContents(URL var1, Project var2, Workspace var3) throws Exception;

    public Node[] getAffectedNodes() {
        if (!this.done) {
            return new Node[0];
        }
        return new Node[]{NodeFactory.find((URL)this.url)};
    }

    public int doit() throws Exception {
        if (URLFileSystem.exists((URL)this.url)) {
            if (!URLFileSystem.isRegularFile((URL)this.url)) {
                return 1;
            }
            Node node = NodeFactory.find((URL)this.url);
            if (node != null) {
                node.close();
            }
            URLFileSystem.delete((URL)this.url);
        }
        this.createdDirectories = new ArrayList();
        try {
            CreateFileCommand.createDirectories(this.url, this.createdDirectories);
            this.doCreateContents(this.url, this.project, this.workspace);
            Node node = NodeFactory.find((URL)this.url);
            if (node == null) {
                int n = 1;
                return n;
            }
            node.save();
            this.done = true;
        }
        catch (Exception e) {
            this.undo();
            throw e;
        }
        return 0;
    }

    public int undo() throws Exception {
        Node node = NodeFactory.find((URL)this.url);
        if (node != null) {
            node.close();
        }
        URLFileSystem.delete((URL)this.url);
        int i = 0;
        while (i < this.createdDirectories.size()) {
            URL url = (URL)this.createdDirectories.get(i);
            URLFileSystem.delete((URL)url);
            ++i;
        }
        this.createdDirectories = null;
        this.done = false;
        return 0;
    }

    private static void createDirectories(URL url, List createdDirectories) throws Exception {
        if (URLFileSystem.exists((URL)(url = URLFileSystem.getParent((URL)url)))) {
            return;
        }
        createdDirectories.add(url);
        CreateFileCommand.createDirectories(url, createdDirectories);
        boolean created = URLFileSystem.mkdir((URL)url);
        if (!created) {
            if ("file".equals(url.getProtocol())) {
                created = new File(URLFileSystem.getPlatformPathName((URL)url)).mkdir();
            }
            if (!created) {
                throw new IOException("directory " + URLFileSystem.getPlatformPathName((URL)url) + " not created");
            }
        }
    }
}

