/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameterList;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceQuestionExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceAssertStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceBlockStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.util.BindingContext;
import oracle.javatools.parser.java.v2.util.Conversions;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.audit.java.ConstantExpressionEvaluator;
import oracle.jdevimpl.audit.java.JavaHasNameSet;
import oracle.jdevimpl.audit.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHelper {
    public static final int _CONVERTIBLE = 4;
    public static final int _CASTABLE = 2;
    public static final int _INCOMPATIBLE = 1;
    public static final int _UNRESOLVED = 0;
    public static final int _CONSTANT = 8;
    public static final int _UNCHECKED = 16;
    public static final int INVOCABLE = 4;
    public static final int INVOCABLE_UNCHECKED = 20;
    public static final int NARROWABLE = 12;
    public static final int UNNARROWABLE = 10;
    public static final int CASTABLE = 2;
    public static final int CASTABLE_UNCHECKED = 18;
    public static final int INCOMPATIBLE_CASTABLE = 3;
    public static final int INCOMPATIBLE = 1;
    public static final int UNKNOWN = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    public static final int ACCESSIBLE = 1;
    public static final int SAME_TOP_LEVEL_CLASS = 2;
    public static final int SAME_PACKAGE = 4;
    public static final int SAME_HIERARCHY = 8;

    private JavaHelper() {
    }

    public static int analyzeAssignmentConversion(JavaType toType, JavaType fromType, SourceExpression fromExpression, JavaProvider provider) {
        int max;
        int min;
        int analysis = JavaHelper.analyzeMethodInvocationConversion(toType, fromType, provider);
        if (analysis != 2 || fromExpression == null || !fromType.isPrimitive()) {
            return analysis;
        }
        PrimitiveType fromPrimitive = (PrimitiveType)fromType;
        switch (fromPrimitive.primCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                return 2;
            }
        }
        PrimitiveType toPrimitive = JavaHelper.unbox(toType);
        if (toPrimitive == null) {
            return 2;
        }
        Object constantObject = ConstantExpressionEvaluator.evaluate(fromExpression);
        if (constantObject == null) {
            return 2;
        }
        switch (toPrimitive.primCode) {
            case 1: {
                min = -128;
                max = 127;
                break;
            }
            case 3: {
                min = Short.MIN_VALUE;
                max = Short.MAX_VALUE;
                break;
            }
            case 2: {
                min = 0;
                max = 65535;
                break;
            }
            case 4: {
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
                break;
            }
            default: {
                return 2;
            }
        }
        int constantInt = constantObject instanceof Character ? ((Character)constantObject).charValue() : ((Number)constantObject).intValue();
        if (min <= constantInt && constantInt <= max) {
            return 12;
        }
        return 10;
    }

    static {
        $assertionsDisabled = JavaHelper.class.desiredAssertionStatus() ^ true;
    }

    public static int analyzeMethodInvocationConversion(JavaType toType, JavaType fromType, JavaProvider provider) {
        if (toType == null || fromType == null) {
            return 0;
        }
        if (fromType == toType) {
            return 4;
        }
        PrimitiveType NULL = PrimitiveType.PRIMITIVE_objects[8];
        if (toType == NULL) {
            return 0;
        }
        if (fromType.isPrimitive()) {
            PrimitiveType fromPrimitive = (PrimitiveType)fromType;
            if (toType.isPrimitive()) {
                if (fromType == NULL) {
                    return 1;
                }
                return JavaHelper.analyzePrimitiveConversion((PrimitiveType)toType, fromPrimitive);
            }
            if (fromType == NULL) {
                return 4;
            }
            if (CommonUtilities.provider2jdkVersion((JavaProvider)provider) >= 3) {
                int analysis;
                JavaType boxedFromType = JavaHelper.box(fromPrimitive, provider);
                if (boxedFromType != null && (analysis = JavaHelper.analyzeReferenceConversion(toType, boxedFromType, provider)) != 1) {
                    return analysis;
                }
                PrimitiveType toPrimitive = JavaHelper.unbox(toType);
                if (toPrimitive != null) {
                    return JavaHelper.analyzePrimitiveConversion(toPrimitive, fromPrimitive);
                }
            }
            return 1;
        }
        if (toType.isPrimitive()) {
            PrimitiveType fromPrimitive;
            if (!$assertionsDisabled && fromType.isPrimitive()) {
                throw new AssertionError();
            }
            if (CommonUtilities.provider2jdkVersion((JavaProvider)provider) >= 3 && (fromPrimitive = JavaHelper.unbox(fromType)) != null) {
                int analysis = JavaHelper.analyzePrimitiveConversion((PrimitiveType)toType, fromPrimitive);
                if (analysis != 2) {
                    return analysis;
                }
                return 3;
            }
            return 1;
        }
        return JavaHelper.analyzeReferenceConversion(toType, fromType, provider);
    }

    public static int analyzeReferenceConversion(JavaType toType, JavaType fromType, JavaProvider provider) {
        if (toType == null || fromType == null) {
            return 0;
        }
        if (toType.equals((Object)fromType)) {
            return 4;
        }
        if (fromType.isArray()) {
            if (toType.isArray()) {
                JavaType toComponent = toType.getComponentType();
                JavaType fromComponent = fromType.getComponentType();
                if (toComponent == null || fromComponent == null) {
                    return 0;
                }
                if (fromComponent == PrimitiveType.PRIMITIVE_objects[8]) {
                    return 4;
                }
                if (toComponent.isPrimitive()) {
                    if (fromComponent.equals((Object)toComponent)) {
                        return 4;
                    }
                    return 1;
                }
                return JavaHelper.analyzeMethodInvocationConversion(toComponent, fromComponent, provider);
            }
            if (toType.isInterface()) {
                String toName = toType.getQualifiedName();
                if ("java.lang.Cloneable".equals(toName) || "java.io.Serializable".equals(toName)) {
                    return 4;
                }
                return 1;
            }
            if ("java.lang.Object".equals(toType.getQualifiedName())) {
                return 4;
            }
            return 1;
        }
        if (fromType.isInterface()) {
            int unchecked = JavaHelper.unchecked(fromType, toType);
            if (toType.isArray()) {
                String toName = toType.getQualifiedName();
                if ("java.lang.Cloneable".equals(toName) || "java.io.Serializable".equals(toName)) {
                    return 4 | unchecked;
                }
                return 1 | unchecked;
            }
            if (toType.isInterface()) {
                if (Conversions.isSubtypeOfImpl((JavaType)fromType, (JavaType)toType)) {
                    return 4 | unchecked;
                }
                return 2 | unchecked;
            }
            if ("java.lang.Object".equals(toType.getQualifiedName())) {
                return 4 | unchecked;
            }
            if (!toType.isFinal() || Conversions.isSubtypeOfImpl((JavaType)toType, (JavaType)fromType)) {
                return 2 | unchecked;
            }
            return 1;
        }
        int unchecked = JavaHelper.unchecked(fromType, toType);
        if (toType.isArray()) {
            if ("java.lang.Object".equals(fromType.getQualifiedName())) {
                return 2 | unchecked;
            }
            return 1 | unchecked;
        }
        if (toType.isInterface()) {
            if (Conversions.isSubtypeOfImpl((JavaType)fromType, (JavaType)toType)) {
                return 4 | unchecked;
            }
            if (!fromType.isFinal()) {
                return 2 | unchecked;
            }
            return 1;
        }
        if (Conversions.isSubtypeOfImpl((JavaType)fromType, (JavaType)toType)) {
            return 4 | unchecked;
        }
        if (Conversions.isSubtypeOfImpl((JavaType)toType, (JavaType)fromType)) {
            return 2 | unchecked;
        }
        return 1;
    }

    private static int unchecked(JavaType fromType, JavaType toType) {
        if (JavaHelper.isRaw(fromType) && toType != null && toType.hasTypeParameters() && toType.hasActualTypeArguments() && !JavaHelper.hasUnboundedWildcardsOnly(toType)) {
            return 16;
        }
        return 0;
    }

    private static boolean hasUnboundedWildcardsOnly(JavaType type) {
        Collection arguments = type.getActualTypeArguments();
        for (JavaType argument : arguments) {
            if (argument instanceof JavaWildcardType) {
                JavaWildcardType wildcard = (JavaWildcardType)argument;
                if (wildcard.getUpperBounds().isEmpty() && wildcard.getLowerBounds().isEmpty()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static int analyzePrimitiveConversion(PrimitiveType toPrimitive, PrimitiveType fromPrimitive) {
        if (fromPrimitive == null || toPrimitive == null) {
            return 0;
        }
        switch (fromPrimitive.primCode) {
            case 0: {
                return toPrimitive.primCode == 0 ? 4 : 1;
            }
            case 1: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 3: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: {
                        return 2;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 2: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 3: {
                        return 2;
                    }
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 4: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        return 2;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 5: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return 2;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 6: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return 2;
                    }
                    case 6: 
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 7: {
                switch (toPrimitive.primCode) {
                    case 0: {
                        return 1;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return 2;
                    }
                    case 7: {
                        return 4;
                    }
                    case 9: {
                        return 1;
                    }
                }
            }
            case 9: {
                return 1;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("from " + fromPrimitive + ", to " + toPrimitive));
        }
        return 0;
    }

    public static JavaType box(PrimitiveType type, JavaProvider provider) {
        switch (type.primCode) {
            case 0: {
                return provider.getClass("java.lang.Boolean");
            }
            case 1: {
                return provider.getClass("java.lang.Byte");
            }
            case 2: {
                return provider.getClass("java.lang.Character");
            }
            case 3: {
                return provider.getClass("java.lang.Short");
            }
            case 4: {
                return provider.getClass("java.lang.Integer");
            }
            case 5: {
                return provider.getClass("java.lang.Long");
            }
            case 6: {
                return provider.getClass("java.lang.Float");
            }
            case 7: {
                return provider.getClass("java.lang.Double");
            }
        }
        return null;
    }

    public static PrimitiveType unbox(JavaType type) {
        if (type.isPrimitive()) {
            return (PrimitiveType)type;
        }
        if ("java.lang".equals(type.getPackageName())) {
            String name = type.getName();
            PrimitiveType[] TYPES = PrimitiveType.PRIMITIVE_objects;
            switch (name.charAt(0)) {
                case 'B': {
                    if ("Boolean".equals(name)) {
                        return TYPES[0];
                    }
                    if (!"Byte".equals(name)) break;
                    return TYPES[1];
                }
                case 'C': {
                    if (!"Character".equals(name)) break;
                    return TYPES[2];
                }
                case 'S': {
                    if (!"Short".equals(name)) break;
                    return TYPES[3];
                }
                case 'I': {
                    if (!"Integer".equals(name)) break;
                    return TYPES[4];
                }
                case 'L': {
                    if (!"Long".equals(name)) break;
                    return TYPES[5];
                }
                case 'F': {
                    if (!"Float".equals(name)) break;
                    return TYPES[6];
                }
                case 'D': {
                    if (!"Double".equals(name)) break;
                    return TYPES[7];
                }
            }
        }
        return null;
    }

    public static SourceExpression createComplementExpression(SourceExpression expression) {
        if (!$assertionsDisabled && expression.getParent() != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !expression.getResolvedType().getQualifiedName().equals("boolean")) {
            throw new AssertionError();
        }
        SourceFactory factory = expression.getOwningSourceFile().getFactory();
        switch (expression.getSymbolKind()) {
            case 52: {
                return factory.createExpression(((SourceLiteralExpression)expression).getLiteral().literalBoolean ? "false" : "true");
            }
            case 60: {
                switch (expression.getOperatorCode()) {
                    case 41: {
                        SourceExpression operand = expression.getFirstOperand();
                        operand.removeSelf();
                        return operand;
                    }
                }
                break;
            }
            case 50: {
                switch (expression.getOperatorCode()) {
                    case 30: {
                        return JavaHelper.createInfixExpression(21, expression, false);
                    }
                    case 25: {
                        return JavaHelper.createInfixExpression(22, expression, false);
                    }
                    case 22: {
                        return JavaHelper.createInfixExpression(25, expression, false);
                    }
                    case 21: {
                        return JavaHelper.createInfixExpression(30, expression, false);
                    }
                    case 20: {
                        return JavaHelper.createInfixExpression(42, expression, false);
                    }
                    case 42: {
                        return JavaHelper.createInfixExpression(20, expression, false);
                    }
                    case 7: {
                        return JavaHelper.createInfixExpression(10, expression, true);
                    }
                    case 3: {
                        return JavaHelper.createInfixExpression(43, expression, true);
                    }
                    case 10: {
                        return JavaHelper.createInfixExpression(7, expression, true);
                    }
                    case 43: {
                        return JavaHelper.createInfixExpression(3, expression, true);
                    }
                    case 12: {
                        return JavaHelper.createInfixExpression(20, expression, false);
                    }
                }
                break;
            }
            case 56: {
                SourceExpression operand0 = expression.getOperandAt(0);
                SourceExpression operand1 = expression.getOperandAt(1);
                SourceExpression operand2 = expression.getOperandAt(2);
                operand0.removeSelf();
                operand1.removeSelf();
                operand2.removeSelf();
                return factory.createQuestionExpression(operand0, JavaHelper.createComplementExpression(operand1), JavaHelper.createComplementExpression(operand2));
            }
            case 49: 
            case 53: 
            case 57: {
                return factory.createUnaryExpression(41, expression);
            }
        }
        return factory.createUnaryExpression(41, (SourceExpression)factory.createWrapperExpression(expression));
    }

    private static SourceInfixExpression createInfixExpression(int operator, SourceExpression expression, boolean complement) {
        SourceExpression lhs = expression.getOperandAt(0);
        SourceExpression rhs = expression.getOperandAt(1);
        lhs.removeSelf();
        rhs.removeSelf();
        if (complement) {
            lhs = JavaHelper.createComplementExpression(lhs);
            rhs = JavaHelper.createComplementExpression(rhs);
        }
        return expression.getOwningSourceFile().getFactory().createInfixExpression(operator, lhs, rhs);
    }

    public static SourceBlockStatement createBlockStatement(SourceStatement statement) {
        if (!$assertionsDisabled && statement.getParent() != null) {
            throw new AssertionError();
        }
        if (statement.getSymbolKind() == 29) {
            return (SourceBlockStatement)statement;
        }
        SourceFactory factory = statement.getOwningSourceFile().getFactory();
        SourceBlock block = factory.createBlock(new SourceElement[]{statement});
        return factory.createBlockStatement(block);
    }

    public static SourceExpressionStatement createAssignmentStatement(String name, SourceExpression expression) {
        SourceFactory factory = expression.getOwningSourceFile().getFactory();
        return factory.createExpressionStatement((SourceExpression)factory.createAssignment(6, (SourceExpression)factory.createSimpleNameExpression(name), expression));
    }

    public static SourceExpression extractInitializer(SourceLocalVariable variable) {
        SourceTypeReference type;
        SourceExpression initializer = variable.getInitializer();
        initializer.removeSelf();
        if (initializer instanceof SourceListExpression && (type = variable.getSourceType()).isArray()) {
            SourceFactory factory = variable.getOwningSourceFile().getFactory();
            initializer = factory.createNewInitializedArrayExpression(factory.createType(type.getName(), type.getArrayDimension()), (SourceListExpression)initializer);
        }
        return initializer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static JavaHasNameSet<JavaType> getHandledExceptions(SourceElement origin) {
        JavaHasNameSet<JavaType> set = new JavaHasNameSet<JavaType>();
        SourceElement element = origin.getParent();
        while (element != null) {
            switch (element.getSymbolKind()) {
                case 44: {
                    List catches = ((SourceTryStatement)element).getCatchClauses();
                    Iterator j = catches.iterator();
                    while (j.hasNext()) {
                        JavaType type;
                        SourceVariable variable = ((SourceCatchClause)j.next()).getCatchVariable();
                        if (variable == null || (type = variable.getResolvedType()) == null) continue;
                        set.add(type);
                    }
                    break;
                }
                case 31: {
                    SourceCatchClause catchClause = (SourceCatchClause)element;
                    element = catchClause.getOwningTry();
                    break;
                }
                case 19: {
                    SourceMethod method = (SourceMethod)element;
                    Iterator iterator = method.getExceptions().iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        set.add((JavaType)e);
                    }
                    return set;
                }
            }
            element = element.getParent();
        }
        return set;
    }

    public static SourceMethod createConstructor(SourceClass type, String[] parameterTypes) {
        SourceFactory factory = type.getOwningSourceFile().getFactory();
        SourceLocalVariable[] variables = new SourceLocalVariable[parameterTypes.length];
        int i = 0;
        while (i < variables.length) {
            String typeName = parameterTypes[i];
            if (typeName == null) {
                typeName = "java.lang.Object";
            }
            SourceTypeReference parameterType = factory.createType(Strings.lastToken((String)typeName, (char)'.'));
            String parameterName = "p" + i;
            variables[i] = factory.createLocalVariable(parameterType, parameterName);
            ++i;
        }
        SourceFormalParameterList parameters = factory.createFormalParameterList(variables);
        SourceBlock block = factory.createBlock();
        SourceMethod constructor = factory.createConstructor(parameters, null, block);
        type.getSourceConstructors().add(constructor);
        constructor.setModifiers(type.getModifiers() & 7);
        return constructor;
    }

    public static SourceMethod createMethod(SourceClass type, String methodName, String returnTypeName, String[] parameterTypeNames, String[] parameterNames) {
        SourceFactory factory = type.getOwningSourceFile().getFactory();
        SourceTypeReference returnType = null;
        if (returnTypeName != null) {
            returnType = factory.createType(returnTypeName);
        }
        SourceLocalVariable[] parameters = new SourceLocalVariable[parameterTypeNames.length];
        int i = 0;
        while (i < parameters.length) {
            String typeName = parameterTypeNames[i];
            if (typeName == null || typeName.equals("null")) {
                typeName = "java.lang.Object";
            }
            SourceTypeReference parameterType = factory.createType(typeName);
            String parameterName = parameterNames[i];
            parameters[i] = factory.createLocalVariable(parameterType, parameterName);
            ++i;
        }
        SourceBlock block = !type.isInterface() ? factory.createBlock() : null;
        SourceMethod method = factory.createMethod(returnType, methodName, factory.createFormalParameterList(parameters), null, block);
        type.getSourceMethods().add(method);
        method.setModifiers(1);
        return method;
    }

    private static void getMethods(HashSet processed, Collection methodList, JavaType typeIn, boolean checkIfErasedType, boolean eraseTypes) {
        if (typeIn == null) {
            return;
        }
        if (processed.contains(typeIn)) {
            return;
        }
        processed.add(typeIn);
        if (checkIfErasedType) {
            if (typeIn.hasTypeParameters() && !typeIn.hasActualTypeArguments()) {
                eraseTypes = true;
            } else if (!typeIn.hasTypeParameters()) {
                eraseTypes = false;
            }
        }
        Object type = eraseTypes ? typeIn.getTypeErasure() : typeIn;
        methodList.addAll(type.getDeclaredMethods());
        JavaType superType = typeIn.getSuperclass();
        JavaHelper.getMethods(processed, methodList, superType, true, eraseTypes);
        Collection interfaces = typeIn.getInterfaces();
        for (JavaType oneInterface : interfaces) {
            JavaHelper.getMethods(processed, methodList, oneInterface, true, eraseTypes);
        }
    }

    public static Collection getUnimplementedMethods(SourceClass type) {
        HashSet<String> signatures = new HashSet<String>();
        LinkedHashMap<String, JavaMethod> methods = new LinkedHashMap<String, JavaMethod>();
        ArrayList list = new ArrayList();
        HashSet processed = new HashSet();
        JavaHelper.getMethods(processed, list, (JavaType)type, false, false);
        for (JavaMethod method : list) {
            String signature;
            if (method.isPrivate() || method.isStatic()) continue;
            String name = method.getName();
            Collection parameters = method.getParameters();
            if (parameters.isEmpty()) {
                signature = name;
            } else {
                StringBuffer buffer = new StringBuffer(name);
                Iterator t = parameters.iterator();
                while (t.hasNext()) {
                    buffer.append(',');
                    JavaVariable parameter = (JavaVariable)t.next();
                    JavaType parameterType = parameter.getResolvedType();
                    if (parameterType != null) {
                        JavaClass erasure = parameterType.getTypeErasure();
                        String erasureName = erasure.getQualifiedName();
                        buffer.append(erasureName);
                        continue;
                    }
                    buffer.append(parameter.getUnresolvedType().getSimplifiedName());
                }
                signature = buffer.toString();
            }
            if (signatures.add(signature)) {
                if (!method.isAbstract()) continue;
                methods.put(signature, method);
                continue;
            }
            if (method.isAbstract()) continue;
            methods.remove(signature);
        }
        return methods.values();
    }

    public static String getParameterName(String suggestedName, JavaHasType hasType, Set usedNames) {
        JavaType type = hasType.getResolvedType();
        String typeName = type != null ? type.getName() : hasType.getUnresolvedType().getSimplifiedName();
        return JavaHelper.getParameterName(suggestedName, typeName, usedNames);
    }

    public static String getParameterName(String suggestedName, String typeName, Set usedNames) {
        if (suggestedName == null) {
            if ("boolean".equals(typeName = Strings.lastToken((String)typeName, (char)'.')) || "byte".equals(typeName) || "short".equals(typeName) || "char".equals(typeName) || "short".equals(typeName) || "int".equals(typeName) || "long".equals(typeName) || "float".equals(typeName) || "double".equals(typeName)) {
                suggestedName = typeName.substring(0, 1);
            } else if (typeName.endsWith("]")) {
                suggestedName = Strings.decapitalize((String)typeName.substring(0, typeName.indexOf(91)));
                if (!suggestedName.endsWith("s")) {
                    suggestedName = suggestedName + 's';
                }
            } else {
                suggestedName = Strings.decapitalize((String)typeName);
            }
        }
        CodingStyleManager manager = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions style = manager.getCodingStyleOptions();
        String name = suggestedName;
        int suffix = 0;
        while (usedNames.contains(name = style.getParameterName(name)) || IdeUtil.isJavaReservedWord((String)name)) {
            name = suggestedName + ++suffix;
        }
        usedNames.add(name);
        return name;
    }

    public static String getParameterName(JavaVariable variable, Set usedNames) {
        SourceVariable sourceVariable = (SourceVariable)variable.getSourceElement();
        String parameterName = sourceVariable != null ? sourceVariable.getName() : null;
        return JavaHelper.getParameterName(parameterName, (JavaHasType)variable, usedNames);
    }

    public static SourceExpression getDefaultInitializer(SourceFactory factory, JavaType type) {
        return JavaHelper.getDefaultInitializer(factory, type.getQualifiedName());
    }

    public static SourceExpression getDefaultInitializer(SourceFactory factory, String type) {
        String text;
        int bracket = type.lastIndexOf(91);
        if (bracket > 0) {
            text = "new " + JavaHelper.arrayName(type);
        } else if (type.equals("boolean")) {
            text = "false";
        } else if (type.equals("byte")) {
            text = "0";
        } else if (type.equals("char")) {
            text = "0";
        } else if (type.equals("short")) {
            text = "0";
        } else if (type.equals("int")) {
            text = "0";
        } else if (type.equals("long")) {
            text = "0L";
        } else if (type.equals("float")) {
            text = "0.0f";
        } else if (type.equals("double")) {
            text = "0.0";
        } else if ("java.util.List".equals(type)) {
            switch (factory.getSourceFile().getLanguageVersion()) {
                case 1: 
                case 2: {
                    text = "java.util.Collections.EMPTY_LIST";
                    break;
                }
                default: {
                    text = "java.util.Collections.emptyList()";
                    break;
                }
            }
        } else if ("java.util.Set".equals(type)) {
            switch (factory.getSourceFile().getLanguageVersion()) {
                case 1: 
                case 2: {
                    text = "java.util.Collections.EMPTY_SET";
                    break;
                }
                default: {
                    text = "java.util.Collections.emptySet()";
                    break;
                }
            }
        } else if ("java.util.Map".equals(type)) {
            switch (factory.getSourceFile().getLanguageVersion()) {
                case 1: 
                case 2: {
                    text = "java.util.Collections.EMPTY_MAP";
                    break;
                }
                default: {
                    text = "java.util.Collections.emptyMap()";
                    break;
                }
            }
        } else {
            text = "null";
        }
        return factory.createExpression(text);
    }

    public static SourceExpression getDefaultInitializer(SourceFactory factory, UnresolvedType type) {
        String typeName = type.getSimplifiedName();
        String text = typeName.indexOf(91) >= 0 ? "new " + JavaHelper.arrayName(typeName) : "null";
        return factory.createExpression(text);
    }

    private static String arrayName(String type) {
        int index = type.lastIndexOf(91);
        if (index >= 0) {
            return JavaHelper.arrayName(type.substring(0, index)) + "[0]";
        }
        return type;
    }

    private static Collection<JavaType> singletonOrEmptyList(JavaType type) {
        return type == null ? Collections.emptyList() : Collections.singletonList(type);
    }

    public static Collection<JavaType> getExpectedType(SourceExpression expression, Collection exceptions) {
        SourceElement parent = expression.getParent();
        switch (parent.getSymbolKind()) {
            case 7: 
            case 10: 
            case 17: {
                return JavaHelper.singletonOrEmptyList(((SourceVariable)parent).getResolvedType());
            }
            case 28: {
                SourceAssertStatement asser = (SourceAssertStatement)parent;
                if (expression == asser.getExpression()) {
                    return JavaHelper.singletonOrEmptyList((JavaType)CommonUtilities.getPrimitiveType((String)"boolean"));
                }
                return Collections.emptyList();
            }
            case 33: 
            case 39: 
            case 45: {
                return JavaHelper.singletonOrEmptyList((JavaType)CommonUtilities.getPrimitiveType((String)"boolean"));
            }
            case 38: {
                SourceForStatement loop = (SourceForStatement)parent;
                if (expression == loop.getForConditional()) {
                    return JavaHelper.singletonOrEmptyList((JavaType)CommonUtilities.getPrimitiveType((String)"boolean"));
                }
                return Collections.emptyList();
            }
            case 40: {
                SourceMethod method = JavaHelper.getEnclosingMethod(parent);
                if (method != null) {
                    JavaType type = method.getReturnType();
                    if (type == null || "void".equals(type.getName())) {
                        return Collections.emptyList();
                    }
                    return JavaHelper.singletonOrEmptyList(type);
                }
                return Collections.emptyList();
            }
            case 43: {
                return exceptions != null ? exceptions : JavaHelper.getHandledExceptions(parent);
            }
            case 48: {
                SourceAssignmentExpression assignment = (SourceAssignmentExpression)parent;
                SourceExpression lhs = assignment.getFirstOperand();
                if (expression == lhs) {
                    Collection<JavaType> expectedTypes = JavaHelper.getExpectedType((SourceExpression)assignment, exceptions);
                    if (expectedTypes.isEmpty()) {
                        expectedTypes = JavaHelper.singletonOrEmptyList(assignment.getSecondOperand().getResolvedType());
                    }
                    return expectedTypes;
                }
                return JavaHelper.singletonOrEmptyList(lhs.getResolvedType());
            }
            case 49: {
                return JavaHelper.getExpectedType((SourceExpression)parent, exceptions);
            }
            case 50: {
                SourceInfixExpression infix = (SourceInfixExpression)parent;
                switch (infix.getOperatorCode()) {
                    case 20: {
                        SourceExpression other = expression == infix.getFirstOperand() ? infix.getSecondOperand() : infix.getFirstOperand();
                        if (other.getText().equals("null")) {
                            return Collections.emptyList();
                        }
                        return JavaHelper.singletonOrEmptyList(other.getResolvedType());
                    }
                }
                return Collections.emptyList();
            }
            case 51: {
                SourceListExpression list = (SourceListExpression)parent;
                int index = list.getOperands().indexOf(expression);
                if (index < 0) {
                    return Collections.emptyList();
                }
                SourceElement grandParent = parent.getParent();
                switch (grandParent.getSymbolKind()) {
                    case 7: {
                        return JavaHelper.getExpectedTypesFromConstructors(((SourceEnumConstant)parent).getResolvedType(), index);
                    }
                    case 53: {
                        SourceMethodCallExpression invocation = (SourceMethodCallExpression)grandParent;
                        JavaMethod method = invocation.getResolvedMethod();
                        if (method != null) {
                            JavaType[] parameterTypes = method.getParameterTypes();
                            if (index < parameterTypes.length && parameterTypes[index] != null) {
                                JavaType type = new BindingContext(expression.getOwningSourceFile().getProvider(), (JavaIsGeneric)method, JavaHelper.getSearchType((SourceInvokeExpression)invocation)).bind(parameterTypes[index]);
                                return JavaHelper.singletonOrEmptyList(type);
                            }
                            return Collections.emptyList();
                        }
                        return Collections.emptyList();
                    }
                    case 55: {
                        SourceNewClassExpression invocation = (SourceNewClassExpression)grandParent;
                        JavaMethod method = invocation.getResolvedMethod();
                        if (method != null) {
                            JavaType[] parameterTypes = method.getParameterTypes();
                            if (index < parameterTypes.length && parameterTypes[index] != null) {
                                JavaType type = new BindingContext(expression.getOwningSourceFile().getProvider(), (JavaIsGeneric)method, JavaHelper.getSearchType((SourceInvokeExpression)invocation)).bind(parameterTypes[index]);
                                return JavaHelper.singletonOrEmptyList(type);
                            }
                            return Collections.emptyList();
                        }
                        return JavaHelper.getExpectedTypesFromConstructors(invocation.getResolvedType(), index);
                    }
                    case 1: {
                        return Collections.emptyList();
                    }
                    case 38: {
                        return Collections.emptyList();
                    }
                }
                if ('{' == list.getOwningSourceFile().getTextBuffer().getChar(list.getStartOffset())) {
                    Collection<JavaType> arrayTypes = JavaHelper.getExpectedType((SourceExpression)list, exceptions);
                    if (arrayTypes.isEmpty()) {
                        return arrayTypes;
                    }
                    ArrayList<JavaType> types = new ArrayList<JavaType>(arrayTypes.size());
                    for (JavaType arrayType : arrayTypes) {
                        if (!arrayType.isArray()) continue;
                        types.add(arrayType.getComponentType());
                    }
                    return types;
                }
                return Collections.emptyList();
            }
            case 53: 
            case 55: {
                SourceInvokeExpression invocation = (SourceInvokeExpression)parent;
                JavaMethod method = invocation.getResolvedMethod();
                SourceExpression lhs = invocation.getLhsOperand();
                if (expression == lhs) {
                    if (method != null) {
                        return Collections.singletonList((JavaType)method.getOwningClass());
                    }
                    return Collections.emptyList();
                }
                return Collections.emptyList();
            }
            case 56: {
                JavaType otherType;
                SourceQuestionExpression question = (SourceQuestionExpression)parent;
                if (expression == question.getFirstOperand()) {
                    return Collections.singletonList((JavaType)CommonUtilities.getPrimitiveType((String)"boolean"));
                }
                SourceExpression other = null;
                if (expression == question.getSecondOperand()) {
                    other = question.getThirdOperand();
                } else if (expression == question.getThirdOperand()) {
                    other = question.getSecondOperand();
                }
                if (other != null && (otherType = other.getResolvedType()) != null) {
                    return Collections.singletonList(otherType);
                }
                return JavaHelper.getExpectedType((SourceExpression)question, exceptions);
            }
            case 59: {
                return Collections.singletonList(((SourceTypecastExpression)parent).getResolvedType());
            }
            case 60: {
                return JavaHelper.getExpectedType((SourceExpression)parent, exceptions);
            }
            case 61: {
                return JavaHelper.getExpectedType((SourceExpression)parent, exceptions);
            }
        }
        return Collections.emptyList();
    }

    private static Collection<JavaType> getExpectedTypesFromConstructors(JavaType type, int index) {
        if (type == null) {
            return Collections.emptyList();
        }
        HashSet<JavaType> types = new HashSet<JavaType>();
        for (JavaMethod constructor : (List)type.getDeclaredConstructors()) {
            JavaType[] parameters = constructor.getParameterTypes();
            if (parameters.length <= index || parameters[index] == null) continue;
            types.add(parameters[index]);
        }
        return types;
    }

    public static SourceClass getEnclosingType(SourceElement construct) {
        SourceElement element = construct.getParent();
        while (element != null) {
            if (element.getSymbolKind() == 3) {
                return (SourceClass)element;
            }
            element = element.getParent();
        }
        return null;
    }

    public static SourceMethod getEnclosingMethod(SourceElement construct) {
        SourceElement element = construct.getParent();
        while (element != null) {
            switch (element.getSymbolKind()) {
                case 6: 
                case 19: {
                    return (SourceMethod)element;
                }
            }
            element = element.getParent();
        }
        return null;
    }

    public static SourceMember getEnclosingMember(SourceElement construct) {
        SourceElement element = construct.getParent();
        while (element != null) {
            switch (element.getSymbolKind()) {
                case 3: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 19: {
                    return (SourceMember)element;
                }
            }
            element = element.getParent();
        }
        return null;
    }

    public static String[] getQualifiedNames(JavaType[] types) {
        if (types == null) {
            return null;
        }
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            JavaType type = types[i];
            if (type != null) {
                names[i] = type.getQualifiedName();
            }
            ++i;
        }
        return names;
    }

    public static String[] getQualifiedNames(Collection<JavaType> types) {
        if (types == null) {
            return null;
        }
        String[] names = new String[types.size()];
        int index = 0;
        for (JavaType type : types) {
            if (type != null) {
                names[index] = type.getQualifiedName();
            }
            ++index;
        }
        return names;
    }

    public static String[] getNames(JavaType[] types) {
        if (types == null) {
            return null;
        }
        String[] names = new String[types.length];
        int i = 0;
        while (i < types.length) {
            JavaType type = types[i];
            if (type != null) {
                names[i] = type.getName();
            }
            ++i;
        }
        return names;
    }

    public static JavaType[] getTypes(String[] typeNames, JavaManager manager) {
        int length = typeNames.length;
        JavaType[] types = new JavaType[length];
        int i = 0;
        while (i < length) {
            JavaClass type = manager.getClass(typeNames[i]);
            if (type == null) {
                return null;
            }
            types[i] = type;
            ++i;
        }
        return types;
    }

    public static String getSimplifiedName(JavaHasType hasType) {
        JavaType type = hasType.getResolvedType();
        if (type != null) {
            if (JavaHelper.isRaw(type)) {
                return type.getTypeErasure().getName();
            }
            int dimensions = 0;
            while (type.isArray()) {
                type = type.getComponentType();
                ++dimensions;
            }
            StringBuffer buffer = new StringBuffer();
            switch (type.getElementKind()) {
                case 3: {
                    if (type.hasTypeParameters()) {
                        if (type.hasActualTypeArguments()) {
                            buffer.append(type.getName());
                            buffer.append('<');
                            Collection parameters = type.getActualTypeArguments();
                            String separator = "";
                            Iterator i = parameters.iterator();
                            while (i.hasNext()) {
                                buffer.append(separator);
                                JavaType parameterType = (JavaType)i.next();
                                buffer.append(JavaHelper.getSimplifiedName((JavaHasType)parameterType));
                                separator = ",";
                            }
                            buffer.append('>');
                            break;
                        }
                        buffer.append(type.getTypeErasure().getName());
                        break;
                    }
                    buffer.append(type.getName());
                    break;
                }
                case 11: {
                    JavaWildcardType wildcard = (JavaWildcardType)type;
                    Collection upper = wildcard.getUpperBounds();
                    Collection lower = wildcard.getLowerBounds();
                    if (!upper.isEmpty()) {
                        buffer.append("? extends ");
                        buffer.append(JavaHelper.getSimplifiedName((JavaHasType)((JavaType)upper.iterator().next())));
                        break;
                    }
                    if (!lower.isEmpty()) {
                        buffer.append("? super ");
                        buffer.append(JavaHelper.getSimplifiedName((JavaHasType)((JavaType)lower.iterator().next())));
                        break;
                    }
                    buffer.append('?');
                    break;
                }
                default: {
                    buffer.append(type.getName());
                    break;
                }
            }
            while (--dimensions >= 0) {
                buffer.append("[]");
            }
            return buffer.toString();
        }
        return hasType.getUnresolvedType().getSimplifiedName();
    }

    public static boolean isRaw(JavaType type) {
        return type != null && type.hasTypeParameters() && !type.hasActualTypeArguments();
    }

    public static String getQualifiedName(JavaType type) {
        if (type == null) {
            return null;
        }
        return type.getQualifiedName();
    }

    public static SourceImport addImport(SourceFile file, String typeName) {
        return JavaHelper.addImport(file, typeName, false);
    }

    /*
     * Unable to fully structure code
     */
    public static SourceImport addImport(SourceFile file, String typeName, boolean returnExistingImport) {
        if (typeName == null) {
            return null;
        }
        if (typeName.equals("void")) {
            return null;
        }
        if (typeName.equals("int")) {
            return null;
        }
        if (typeName.equals("short")) {
            return null;
        }
        if (typeName.equals("long")) {
            return null;
        }
        if (typeName.equals("boolean")) {
            return null;
        }
        if (typeName.equals("float")) {
            return null;
        }
        if (typeName.equals("char")) {
            return null;
        }
        if (typeName.equals("byte")) {
            return null;
        }
        if (!typeName.equals("double")) ** GOTO lbl22
        return null;
lbl-1000:
        // 1 sources

        {
            typeName = typeName.substring(0, typeName.length() - 2);
lbl22:
            // 2 sources

            ** while (typeName.endsWith((String)"[]"))
        }
lbl23:
        // 1 sources

        packageName = "";
        dot = typeName.lastIndexOf(46);
        if (dot > 0 && (packageName = typeName.substring(0, dot)).equals("java.lang")) {
            return null;
        }
        if (packageName.equals(file.getPackageName())) {
            return null;
        }
        index = 0;
        imports = file.getSourceImports();
        narrowedTargetImports = new ArrayList<SourceImport>();
        if (!imports.isEmpty()) {
            i = 0;
            n = imports.size();
            while (i < n) {
                impor = (SourceImport)imports.get(i);
                if (!impor.isStatic()) {
                    existingName = impor.getName();
                    if (typeName.compareTo(existingName) > 0) {
                        index = i + 1;
                    }
                    if (existingName.endsWith(".*")) {
                        if ((existingName = existingName.substring(0, existingName.length() - 2)).equals(packageName)) {
                            return returnExistingImport != false ? impor : null;
                        }
                    } else {
                        if (existingName.equals(typeName)) {
                            return returnExistingImport != false ? impor : null;
                        }
                        dotIndex = existingName.lastIndexOf(46);
                        if (dotIndex > 0 && packageName.equals(imporPackageName = existingName.substring(0, dotIndex))) {
                            narrowedTargetImports.add(impor);
                        }
                    }
                }
                ++i;
            }
        }
        if ((options = CodingStyleManager.getCodingStyleManager().getCodingStyleOptions()).getUseWideImports() && narrowedTargetImports.size() + 1 >= options.getWideImportThreshold()) {
            impor = file.getFactory().createImportDeclaration(packageName + ".*");
            imports.add(index, impor);
            imports.removeAll(narrowedTargetImports);
            return impor;
        }
        impor = file.getFactory().createImportDeclaration(typeName);
        imports.add(index, impor);
        return impor;
    }

    public static DeclarationClassification getClassification(JavaHasType declaration) {
        if (declaration == null) {
            return DeclarationClassification.NONE;
        }
        if (declaration.isSourceElement()) {
            switch (declaration.getSourceElement().getSymbolKind()) {
                case 1: {
                    return DeclarationClassification.ANNOTATION;
                }
                case 3: {
                    return DeclarationClassification.CLASS;
                }
                case 7: {
                    return DeclarationClassification.FIELD;
                }
                case 6: {
                    return DeclarationClassification.METHOD;
                }
                case 10: {
                    return DeclarationClassification.FIELD;
                }
                case 13: {
                    return DeclarationClassification.PARAMETER;
                }
                case 17: {
                    return DeclarationClassification.VARIABLE;
                }
                case 19: {
                    return DeclarationClassification.METHOD;
                }
            }
        } else {
            switch (declaration.getElementKind()) {
                case 2: {
                    return DeclarationClassification.ANNOTATION;
                }
                case 3: {
                    return DeclarationClassification.CLASS;
                }
                case 5: {
                    return DeclarationClassification.FIELD;
                }
                case 7: {
                    return DeclarationClassification.VARIABLE;
                }
                case 8: {
                    return DeclarationClassification.METHOD;
                }
            }
        }
        return DeclarationClassification.NONE;
    }

    public static JavaType[] getArgumentTypes(SourceInvokeExpression methodCall) {
        int count = methodCall.getArgumentCount();
        JavaType[] types = new JavaType[count];
        int i = 0;
        while (i < types.length) {
            SourceExpression argument = methodCall.getArgumentAt(i);
            types[i] = argument.getResolvedType();
            ++i;
        }
        return types;
    }

    public static JavaType[] getNonsyntheticParameterTypes(JavaMethod method) {
        JavaVariable parameter;
        Collection parameters = method.getParameters();
        Iterator iterator = parameters.iterator();
        int size = parameters.size();
        if (size == 0) {
            return JavaType.EMPTY_ARRAY;
        }
        while ((parameter = (JavaVariable)iterator.next()).isSynthetic()) {
            --size;
            if (iterator.hasNext()) continue;
        }
        JavaType[] types = new JavaType[size];
        if (size > 0) {
            types[0] = parameter.getResolvedType();
        }
        int i = 1;
        while (i < size) {
            types[i] = ((JavaVariable)iterator.next()).getResolvedType();
            ++i;
        }
        return types;
    }

    public static boolean isSuperclassOf(JavaType supertype, JavaType subtype) {
        return subtype.isSubtypeOf(supertype);
    }

    public static boolean isSubclassOf(JavaType subtype, JavaType supertype) {
        return subtype.isSubtypeOf(supertype);
    }

    public static JavaType getTopLevelType(JavaMember member) {
        if (member == null) {
            return null;
        }
        JavaType type = member instanceof JavaType ? (JavaType)member : member.getOwningClass();
        JavaClass parent = type.getOwningClass();
        while (parent != null) {
            type = parent;
            parent = type.getOwningClass();
        }
        return type;
    }

    public static boolean isAccessibleFrom(JavaMember declaration, SourceElement referringElement) {
        int modifiers = declaration.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            return true;
        }
        return (JavaHelper.analyzeMemberAccess(declaration, referringElement) & 1) != 0;
    }

    public static int analyzeMemberAccess(JavaMember declaration, SourceElement referringElement) {
        boolean sameHierarchy;
        JavaType declarationType = declaration instanceof JavaType ? (JavaType)declaration : declaration.getOwningClass();
        SourceClass referringType = JavaHelper.getEnclosingType(referringElement);
        boolean sameTopLevelClass = JavaHelper.getTopLevelType((JavaMember)referringType).equals((Object)JavaHelper.getTopLevelType(declaration));
        boolean samePackage = referringType.getPackage().equals(declarationType.getPackage());
        block0: while (true) {
            JavaType superclass = declarationType;
            while (!(sameHierarchy = JavaHelper.isSuperclassOf(superclass, (JavaType)referringType))) {
                if ((superclass = superclass.getOwningClass()) != null) continue;
                if ((referringType = referringType.getOwningClass()) != null) continue block0;
            }
            break;
        }
        int modifiers = declaration.getModifiers();
        boolean accessible = Modifier.isPublic(modifiers) | sameTopLevelClass | (samePackage && !Modifier.isPrivate(modifiers)) | (sameHierarchy && Modifier.isProtected(modifiers));
        int bits = 0;
        if (accessible) {
            bits |= 1;
        }
        if (sameHierarchy) {
            bits |= 8;
        }
        if (samePackage) {
            bits |= 4;
        }
        if (sameTopLevelClass) {
            bits |= 2;
        }
        return bits;
    }

    public static JavaType getSearchType(SourceInvokeExpression methodCall) {
        SourceExpression lhs;
        Object searchType = methodCall instanceof SourceNewClassExpression ? methodCall.getResolvedType() : ((lhs = methodCall.getLhsOperand()) != null ? lhs.getResolvedType() : JavaHelper.getEnclosingType((SourceElement)methodCall));
        return searchType;
    }

    public static boolean isStatic(SourceMethodCallExpression invocation, SourceMember enclosingMember) {
        JavaHasType lhs = invocation.getResolvedLhs();
        if (lhs != null) {
            return lhs instanceof JavaType;
        }
        return enclosingMember == null || enclosingMember.isStatic();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DeclarationClassification
    extends Enum<DeclarationClassification> {
        private static final /* synthetic */ DeclarationClassification[] $v;
        public static final /* enum */ DeclarationClassification NONE;
        public static final /* enum */ DeclarationClassification ANNOTATION;
        public static final /* enum */ DeclarationClassification CLASS;
        public static final /* enum */ DeclarationClassification METHOD;
        public static final /* enum */ DeclarationClassification FIELD;
        public static final /* enum */ DeclarationClassification PARAMETER;
        public static final /* enum */ DeclarationClassification VARIABLE;

        public static DeclarationClassification valueOf(String string) {
            return Enum.valueOf(DeclarationClassification.class, string);
        }

        public static final DeclarationClassification[] values() {
            return (DeclarationClassification[])$v.clone();
        }

        static {
            DeclarationClassification[] declarationClassificationArray = new DeclarationClassification[7];
            declarationClassificationArray[6] = VARIABLE = new DeclarationClassification("VARIABLE", 6);
            declarationClassificationArray[5] = PARAMETER = new DeclarationClassification("PARAMETER", 5);
            declarationClassificationArray[4] = FIELD = new DeclarationClassification("FIELD", 4);
            declarationClassificationArray[3] = METHOD = new DeclarationClassification("METHOD", 3);
            declarationClassificationArray[2] = CLASS = new DeclarationClassification("CLASS", 2);
            declarationClassificationArray[1] = ANNOTATION = new DeclarationClassification("ANNOTATION", 1);
            declarationClassificationArray[0] = NONE = new DeclarationClassification("NONE", 0);
            $v = declarationClassificationArray;
        }

        private DeclarationClassification(String string2, int n2) {
        }
    }
}

