/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.java;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;

public class MoveFileCommand
extends Command {
    private boolean done;
    private URL sourceURL;
    private URL targetURL;
    private List targetDirectories;

    private void $init$() {
        this.targetDirectories = new ArrayList();
    }

    protected MoveFileCommand(String name, URL sourceURL, URL targetURL, Project project, Workspace workspace) {
        super(Ide.findOrCreateCmdID((String)name), 3, name);
        this.$init$();
        this.sourceURL = sourceURL;
        this.targetURL = targetURL;
        this.context = new Context();
        this.context.setWorkspace(workspace);
        this.context.setProject(project);
        Node node = NodeFactory.find((URL)sourceURL);
        this.context.setNode(node);
        this.setContext(this.context);
    }

    public Node[] getAffectedNodes() {
        if (!this.done) {
            return null;
        }
        return new Node[]{NodeFactory.find((URL)this.targetURL)};
    }

    public int doit() throws Exception {
        if (this.done) {
            throw new IllegalStateException("done and not undone");
        }
        Node node = NodeFactory.find((URL)this.sourceURL);
        if (node == null) {
            return 1;
        }
        node.save();
        this.targetDirectories = new ArrayList();
        this.createDirectories(this.targetURL);
        boolean ok = URLFileSystem.renameTo((URL)this.sourceURL, (URL)this.targetURL);
        if (!ok) {
            this.deleteDirectories();
            return 1;
        }
        this.done = true;
        return 0;
    }

    public int undo() throws Exception {
        if (!this.done) {
            throw new IllegalStateException("not done");
        }
        Node node = NodeFactory.find((URL)this.targetURL);
        if (node.isDirty()) {
            return 1;
        }
        boolean ok = URLFileSystem.renameTo((URL)this.targetURL, (URL)this.sourceURL);
        if (!ok) {
            return 1;
        }
        this.deleteDirectories();
        this.done = false;
        return 0;
    }

    private void createDirectories(URL url) throws Exception {
        if (URLFileSystem.exists((URL)(url = URLFileSystem.getParent((URL)url)))) {
            return;
        }
        this.targetDirectories.add(url);
        this.createDirectories(url);
        boolean created = URLFileSystem.mkdir((URL)url);
        if (!created) {
            if ("file".equals(url.getProtocol())) {
                created = new File(URLFileSystem.getPlatformPathName((URL)url)).mkdir();
            }
            if (!created) {
                throw new IOException("directory " + URLFileSystem.getPlatformPathName((URL)url) + " not created");
            }
        }
    }

    private void deleteDirectories() {
        int i = 0;
        while (i < this.targetDirectories.size()) {
            URL url = (URL)this.targetDirectories.get(i);
            boolean deleted = URLFileSystem.delete((URL)url);
            if (!deleted) {
                new File(URLFileSystem.getPlatformPathName((URL)url)).delete();
            }
            ++i;
        }
    }
}

