/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.refactoring.RefactoringManager;
import oracle.jdeveloper.refactoring.criteria.ChangeMethodCriteria;
import oracle.jdeveloper.refactoring.criteria.MetParam;

public class RemoveUnusedParameterCommand
extends Command {
    private boolean done;
    private SourceMethod method;
    private SourceFormalParameter parameter;
    private URL sourceURL;
    private Node node;

    protected RemoveUnusedParameterCommand(String name, SourceFormalParameter parameter, SourceMethod method, Project project, Workspace workspace) {
        super(Ide.findOrCreateCmdID((String)name), 3, name);
        this.context = new Context();
        this.context.setWorkspace(workspace);
        this.context.setProject(project);
        this.method = method;
        this.parameter = parameter;
        this.sourceURL = method.getOwningSourceFile().getURL();
        this.node = NodeFactory.find((URL)this.sourceURL);
        this.context.setNode(this.node);
        this.setContext(this.context);
    }

    public int doit() {
        List parameters = this.method.getFormalParameterList().getSourceParameters();
        ArrayList<MetParam> metParams = new ArrayList<MetParam>();
        int i = 0;
        while (i < parameters.size()) {
            SourceVariable param = (SourceVariable)parameters.get(i);
            if (!this.parameter.equals(param)) {
                metParams.add(new MetParam(i, null, null, null));
            }
            ++i;
        }
        RefactoringManager manager = RefactoringManager.getRefactoringManager();
        ChangeMethodCriteria criteria = new ChangeMethodCriteria(this.method, metParams.toArray(new MetParam[metParams.size()]));
        criteria.setContext(this.context);
        criteria.setParametersToBeChecked(new SourceFormalParameter[]{this.parameter});
        criteria.setSafeRefactoring(true);
        manager.changeMethod(this.context, criteria);
        return 0;
    }

    public int undo() {
        return 0;
    }

    public Node[] getAffectedNodes() {
        if (!this.done) {
            return null;
        }
        return new Node[]{this.node};
    }
}

