/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtEvent;
import oracle.jdeveloper.cmt.CmtEventSet;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdevimpl.cmtimpl.JbComponent;
import oracle.jdevimpl.cmtimpl.JbEvent;
import oracle.jdevimpl.cmtimpl.JbFeature;

final class JbEventSet
extends JbFeature
implements CmtEventSet {
    static final String LISTENER = "Listener";
    static final String ADAPTER = "Adapter";
    static final String ADD = "add";
    static final String REMOVE = "remove";
    int adapterType;
    boolean unicast;
    private JavaMethod adder;
    private String adderName;
    private JavaMethod remover;
    private String removerName;
    private JavaClass iface;
    private String ifaceName;
    private JavaClass adapterClass;
    private boolean adapterChecked;
    ArrayList exposed;
    ArrayList events;
    HashMap eventMap;

    private void $init$() {
        this.adapterType = -1;
        this.exposed = null;
    }

    public JbEventSet(JbComponent component, String name) {
        super(component, name);
        this.$init$();
    }

    public JbEventSet(JbComponent component, EventSetDescriptor esd) {
        super(component, esd);
        this.$init$();
        this.ifaceName = esd.getListenerType().getName();
        Method alm = esd.getAddListenerMethod();
        this.adderName = alm.getName();
        Method rlm = esd.getRemoveListenerMethod();
        this.removerName = rlm.getName();
        Method[] lm = esd.getListenerMethods();
        if (lm != null) {
            this.exposed = new ArrayList();
            int i = 0;
            while (i < lm.length) {
                if (lm[i] != null) {
                    this.exposed.add(lm[i].getName());
                }
                ++i;
            }
        }
    }

    public JavaClass getAdapterClass() {
        if (!this.adapterChecked) {
            this.adapterChecked = true;
            String adapterClassName = this.ifaceName;
            int trim = adapterClassName.indexOf(LISTENER);
            adapterClassName = (trim >= 0 ? adapterClassName.substring(0, trim) : adapterClassName) + ADAPTER;
            this.adapterClass = this.component.getComponents().getPackages().getClass(adapterClassName);
        }
        return this.adapterClass;
    }

    public JavaClass getListenerType() {
        if (this.iface == null && this.ifaceName != null) {
            this.iface = this.component.getComponents().getPackages().getClass(this.ifaceName);
        }
        return this.iface;
    }

    public void setListenerType(JavaClass cl) {
        this.iface = cl;
        this.ifaceName = cl != null ? cl.getQualifiedName() : null;
    }

    public JavaMethod[] getListenerMethods() {
        JavaMethod[] methods;
        block5: {
            int count;
            block4: {
                if (this.events == null) {
                    this.buildEvents();
                }
                count = this.events.size();
                methods = null;
                if (this.exposed != null) break block4;
                methods = new JavaMethod[count];
                int i = 0;
                while (i < count) {
                    methods[i] = ((JbEvent)this.events.get((int)i)).listener;
                    ++i;
                }
                break block5;
            }
            methods = new JavaMethod[this.exposed.size()];
            if (methods.length <= 0) break block5;
            int j = methods.length;
            int i = 0;
            while (i < count && j > 0) {
                JavaMethod method = ((JbEvent)this.events.get((int)i)).listener;
                if (this.exposed.contains(method.getName())) {
                    methods[--j] = method;
                }
                ++i;
            }
        }
        return methods;
    }

    public JavaMethod getAddListenerMethod() {
        if (this.adder == null && this.adderName != null) {
            JavaClass jClass = this.getListenerType();
            JavaType[] types = new JavaType[]{jClass != null ? jClass.getResolvedType() : null};
            this.adder = this.component.getType().getMethod(this.adderName, types);
        }
        return this.adder;
    }

    public String getAddListenerMethodName() {
        return this.adderName;
    }

    public JavaMethod getRemoveListenerMethod() {
        if (this.remover == null && this.removerName != null) {
            JavaClass jClass = this.getListenerType();
            JavaType[] types = new JavaType[]{jClass != null ? jClass.getResolvedType() : null};
            this.remover = this.component.getType().getMethod(this.removerName, types);
        }
        return this.remover;
    }

    public String getRemoveListenerMethodName() {
        return this.removerName;
    }

    void addMethod(JavaMethod method) {
        if (method.getName().startsWith(ADD)) {
            this.adder = method;
            this.adderName = method != null ? method.getName() : null;
        } else {
            this.remover = method;
            String string = this.removerName = method != null ? method.getName() : null;
        }
        if (this.ifaceName == null) {
            JavaVariable parameter1;
            Collection collection = method.getParameters();
            Iterator cIter = collection != null ? collection.iterator() : null;
            JavaVariable javaVariable = parameter1 = cIter != null && cIter.hasNext() ? (JavaVariable)cIter.next() : null;
            if (parameter1 != null) {
                JavaType jType = parameter1.getResolvedType();
                JavaClass jClass = this.component.getComponents().getPackages().getClass(jType.getQualifiedName());
                this.setListenerType(jClass);
            }
        }
    }

    boolean createFinish() {
        return this.adderName != null && this.removerName != null;
    }

    public boolean isUnicast() {
        return this.unicast;
    }

    public void setUnicast(boolean unicast) {
        this.unicast = unicast;
    }

    public CmtEvent[] getEvents() {
        if (this.events == null) {
            this.buildEvents();
        }
        CmtEvent[] es = new JbEvent[this.events.size()];
        this.events.toArray(es);
        return es;
    }

    public CmtEvent getEvent(String name) {
        if (this.eventMap == null) {
            this.buildEvents();
        }
        return (JbEvent)this.eventMap.get(name);
    }

    int getEventIndex(JbEvent event) {
        if (this.eventMap == null) {
            this.buildEvents();
        }
        return this.events.indexOf(event);
    }

    int getEventCount() {
        if (this.eventMap == null) {
            this.buildEvents();
        }
        return this.events.size();
    }

    void buildEvents() {
        this.events = new ArrayList();
        this.eventMap = new HashMap(5);
        JavaClass cls = this.getListenerType();
        Collection methods = cls != null ? cls.getMethods() : null;
        Iterator mIter = methods != null ? methods.iterator() : null;
        CmtPackages mgr = this.component.getComponents().getPackages();
        JavaClass listenerClass = mgr.getClass("java.util.EventListener");
        if (mIter != null) {
            while (mIter.hasNext()) {
                JavaMethod method = (JavaMethod)mIter.next();
                JavaClass declaringClass = method.getOwningClass();
                if (!declaringClass.isInterface() || !listenerClass.isAssignableFrom((JavaType)declaringClass)) continue;
                JbEvent event = new JbEvent(this, method);
                this.events.add(event);
                this.eventMap.put(event.getName(), event);
            }
        }
    }

    public static String extractName(CmtComponents manager, JavaMethod method, boolean checkModifiers) {
        if (checkModifiers && (method.getModifiers() & 9) != 1) {
            return null;
        }
        String methodName = method.getName();
        if (methodName.length() <= 3) {
            return null;
        }
        JavaType retType = method.getReturnType();
        if (retType == null || !retType.getQualifiedName().equals("void")) {
            return null;
        }
        Collection params = method.getParameters();
        if (params != null && params.size() == 1) {
            JavaClass listenerClass = manager.getPackages().getClass("java.util.EventListener");
            Iterator pIter = params.iterator();
            JavaVariable param = (JavaVariable)pIter.next();
            JavaClass paramClass = manager.getPackages().getClass(param.getResolvedType().getQualifiedName());
            if (paramClass == null) {
                return null;
            }
            if (paramClass.isInterface() && listenerClass.isAssignableFrom((JavaType)paramClass)) {
                String rawName;
                if (methodName.startsWith(ADD)) {
                    rawName = methodName.substring(3);
                } else if (methodName.startsWith(REMOVE)) {
                    rawName = methodName.substring(6);
                } else {
                    return null;
                }
                int trim = rawName.indexOf(LISTENER);
                String string = rawName = trim >= 0 ? rawName.substring(0, trim) : rawName;
                if (rawName.length() == 0) {
                    return null;
                }
                return Introspector.decapitalize(rawName);
            }
        }
        return null;
    }
}

