/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLPath;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.java.clients.uieditor.CustomJavaManager;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.uieditor.UIManager;

class JbPackages
extends IdeSubject
implements CmtPackages,
Observer,
BuildSystemListener {
    private CustomJavaManager jManager;
    private Project jProject;
    private URLPath paths = UIManager.getProxyPath(null);

    JbPackages(Project project) {
        this.jProject = project;
        this.jManager = CustomJavaManager.newInstance(this.jProject, this.paths);
        this.jProject.attach((Observer)this);
        Compiler.getCompiler().addBuildSystemListener((BuildSystemListener)this);
    }

    public JavaClass getClass(SourceFile srcFile, String shortName) {
        JavaClass jCls = this.jManager.getClass(shortName);
        if (jCls == null) {
            Iterator iIter;
            List imports = srcFile.getSourceImports();
            Iterator iterator = iIter = imports != null ? imports.iterator() : null;
            if (iIter != null) {
                shortName = "." + shortName;
                while (iIter.hasNext()) {
                    SourceImport i = (SourceImport)iIter.next();
                    String name = i.getName();
                    if (name.endsWith(shortName)) {
                        jCls = this.jManager.getClass(name);
                    } else if (name.endsWith(".*")) {
                        name = name.substring(0, name.length() - 2);
                        jCls = this.jManager.getClass(name + shortName);
                    }
                    if (jCls == null) continue;
                    return jCls;
                }
            }
            jCls = this.jManager.getClass("java.lang" + shortName);
        }
        return jCls;
    }

    public Project getProject() {
        return this.jProject;
    }

    public ClassLoader getClassLoader() {
        return this.jManager.getClassLoader();
    }

    public Class loadClass(String clsName, boolean resolve) throws ClassNotFoundException {
        try {
            Class cls = JotNames.primitiveClassForName(clsName);
            if (cls != null) {
                Class clazz = cls;
                return clazz;
            }
            Class<?> clazz = this.getClassLoader().loadClass(clsName);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Class clazz = null;
            return clazz;
        }
    }

    public void flushCache() {
        this.jManager.reloadProjectPaths();
    }

    public void addDesignTimePath(URLPath path) {
        if (path != null) {
            URL[] entries = path.getEntries();
            if (entries != null) {
                int i = 0;
                while (i < entries.length) {
                    if (entries[i] != null && !this.paths.contains(entries[i])) {
                        this.paths.add(entries[i]);
                    }
                    ++i;
                }
            }
            if (this.paths.isDirty()) {
                this.paths.markDirty(false);
                this.jManager = CustomJavaManager.newInstance(this.jProject, this.paths);
            }
        }
    }

    public JavaClass getClass(String fqName) {
        return this.jManager.getClass(fqName);
    }

    public JavaClass getClass(String fqPrefix, String name) {
        return this.jManager.getClass(fqPrefix, name);
    }

    public JavaClass getClassByVMName(String fqVmName) {
        return this.jManager.getClassByVMName(fqVmName);
    }

    public JavaType getArrayType(JavaType componentType, int dimensions) {
        return this.jManager.getArrayType(componentType, dimensions);
    }

    public SourceClass getSourceClass(String fqName) {
        return this.jManager.getSourceClass(fqName);
    }

    public JavaPackage getPackage(String fqPrefix) {
        return this.jManager.getPackage(fqPrefix);
    }

    public TextBuffer getTextBuffer(URL url) {
        return this.jManager.getTextBuffer(url);
    }

    public JavaFile getFile(URL url) {
        return this.jManager.getFile(url);
    }

    public SourceFile getSourceFile(URL sourceURL) {
        return this.jManager.getSourceFile(sourceURL);
    }

    public SourceFile createSourceFile(URL sourceURL) throws IOException, IllegalArgumentException {
        return this.jManager.createSourceFile(sourceURL);
    }

    public SourceFile getSourceFile(TextBuffer textBuffer) {
        return this.jManager.getSourceFile(textBuffer);
    }

    public boolean commitTransaction(SourceTransaction trans, TransactionDescriptor descriptor) {
        return this.jManager.commitTransaction(trans, descriptor);
    }

    public void update(Object observed, UpdateMessage change) {
        if (this.jProject == null || observed != this.jProject) {
            return;
        }
        int id = change.getMessageID();
        if (id == UpdateMessage.OBJECT_CLOSED) {
            Compiler.getCompiler().removeBuildSystemListener((BuildSystemListener)this);
            this.jProject.detach((Observer)this);
            UpdateMessage.fireObjectClosed((Subject)this);
            this.jProject = null;
        } else if (id == UpdateMessage.PROPERTY_SET) {
            if (change.containsProperty("classPath")) {
                UpdateMessage msg = new UpdateMessage(CmtPackages.CLASSPATH_CHANGED, (Object)this);
                this.notifyObservers(this, msg);
            }
            if (change.containsProperty("sourcePath") || change.containsProperty("projectSourcePath")) {
                UpdateMessage msg = new UpdateMessage(CmtPackages.SOURCEPATH_CHANGED, (Object)this);
                this.notifyObservers(this, msg);
            }
        } else if (id == UpdateMessage.OBJECT_OPENED || id == UpdateMessage.OBJECT_RELOADED) {
            SwingUtilities.invokeLater(new 1());
        }
    }

    public void buildWillStart(Context context) throws BuildSystemVetoException {
    }

    public void buildFinished(int errorCount, int warningCount, int infoCount) throws BuildSystemVetoException {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new 2());
        } else {
            this.sendInternalUpdate();
        }
    }

    public void cleanWillStart(Context context) throws BuildSystemVetoException {
    }

    public void cleanFinished(Context context) throws BuildSystemVetoException {
    }

    private void sendInternalUpdate() {
        UpdateMessage msg = new UpdateMessage(UpdateMessage.PROPERTY_SET, (Object)this.jProject);
        PropertyChangeEvent evt = new PropertyChangeEvent(this.jProject, "classPath", null, null);
        msg.setProperty("classPath", (Object)evt);
        this.update(this.jProject, msg);
    }

    static void mav$sendInternalUpdate(JbPackages jbPackages) {
        jbPackages.sendInternalUpdate();
    }

    final class 1
    implements Runnable {
        public void run() {
            UpdateMessage msg = new UpdateMessage(CmtPackages.SOURCEPATH_CHANGED, (Object)JbPackages.this);
            JbPackages.this.notifyObservers(JbPackages.this, msg);
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            JbPackages.mav$sendInternalUpdate(JbPackages.this);
        }
    }
}

