/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.cmt.CmtSelectionEvent;
import oracle.jdeveloper.cmt.CmtSelectionListener;
import oracle.jdeveloper.cmt.CmtSelectionModel;
import oracle.jdevimpl.cmtimpl.JbComponent;

public final class JbSelectionModel
implements CmtSelectionModel {
    private ArrayList selection;
    private ArrayList listeners;
    private JbComponent owner;
    private boolean stale;

    private void $init$() {
        this.selection = new ArrayList();
        this.listeners = new ArrayList();
    }

    public JbSelectionModel(JbComponent owner) {
        this.$init$();
        this.owner = owner;
    }

    public boolean isSelected(CmtModelNode node) {
        this.refresh();
        return node != null && this.selection.contains(node);
    }

    public int getSelectionCount() {
        this.refresh();
        return this.selection.size();
    }

    public CmtModelNode[] getSelection() {
        this.refresh();
        CmtModelNode[] result = new CmtModelNode[this.selection.size()];
        this.selection.toArray(result);
        return result;
    }

    public void clearSelection() {
        this.refresh();
        if (this.selection.size() > 0) {
            this.selection.clear();
            if (!this.stale) {
                this.owner.setLastDesignedNodes(null, null);
            }
            this.fireSelectionChanged(new CmtSelectionEvent(this));
        }
    }

    public void setSelection(CmtModelNode[] newSelection) {
        Assert.check((boolean)(this.stale ^ true), (String)"Stale JbSelectionModel");
        this.refresh();
        boolean different = false;
        if (newSelection != null) {
            if (newSelection.length == this.selection.size()) {
                int i = 0;
                while (i < newSelection.length) {
                    if (newSelection[i] != this.selection.get(i)) {
                        different = true;
                        break;
                    }
                    ++i;
                }
            } else {
                different = true;
            }
        } else if (this.selection.size() > 0) {
            different = true;
        }
        if (different) {
            this.selection.clear();
            if (newSelection != null) {
                int i = 0;
                while (i < newSelection.length) {
                    this.selection.add(newSelection[i]);
                    ++i;
                }
            }
            this.owner.setLastDesignedNodes(null, (Element[])newSelection);
            this.fireSelectionChanged(new CmtSelectionEvent(this));
        }
    }

    public void addCmtSelectionListener(CmtSelectionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeCmtSelectionListener(CmtSelectionListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    void release() {
        this.stale = true;
        this.selection.clear();
    }

    private void refresh() {
        CmtModelNode[] nodes;
        if (this.stale && !this.owner.isStale() && (nodes = (CmtModelNode[])this.owner.getLastDesignedNodes(null)) != null) {
            int i = 0;
            while (i < nodes.length) {
                this.selection.add(nodes[i]);
                ++i;
            }
            this.stale = false;
        }
    }

    private void fireSelectionChanged(CmtSelectionEvent e) {
        List list = (List)this.listeners.clone();
        int count = list.size();
        int i = 0;
        while (i < count) {
            ((CmtSelectionListener)list.get(i)).selectionChanged(e);
            ++i;
        }
    }
}

