/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import oracle.ide.util.Assert;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceArrayAccessExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInfixExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewArrayExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceUnaryExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceWrapperExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.cmt.CmtComponent;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtParseException;
import oracle.jdeveloper.cmt.CmtSubcomponent;
import oracle.jdeveloper.cmt.CmtValue;
import oracle.jdeveloper.java.legacy.Jot2Utils;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.uieditor.UIManager;
import oracle.jdevimpl.cmtimpl.JbMethodCall;
import oracle.jdevimpl.cmtimpl.Res;

final class JbValue
implements CmtValue {
    CmtComponent outer;
    SourceExpression value;
    CmtSubcomponent subcomponent;
    private static URL UNKNOWN_IMAGE;

    public JbValue(CmtComponent c, SourceExpression v, CmtSubcomponent s) {
        this.outer = c;
        this.value = v;
        this.subcomponent = s;
    }

    public JbValue(CmtComponent c, SourceExpression v) {
        this.outer = c;
        this.value = v;
        if (this.outer != null) {
            this.subcomponent = this.outer.getSubcomponent(this.value.getText());
        }
    }

    public CmtSubcomponent getSubcomponent() {
        return this.subcomponent;
    }

    public SourceExpression getExpression() {
        return this.value;
    }

    public String getText() {
        if (this.subcomponent != null) {
            return this.subcomponent.getName();
        }
        if (this.value != null) {
            return this.value.getText();
        }
        return null;
    }

    public void setText(String text) {
        try {
            SourceFile jFile = this.value.getOwningSourceFile();
            SourceTransaction transaction = jFile.getTransaction();
            boolean transactionCreated = false;
            if (transaction == null) {
                jFile.beginTransaction();
                transactionCreated = true;
            }
            SourceFactory jFactory = jFile.getFactory();
            SourceExpression jExpr = jFactory.createExpressionFromText(text);
            this.value.replaceSelf((SourceElement)jExpr);
            jFile.getTransaction().savepoint();
            if (transactionCreated) {
                jFile.getTransaction().commit();
            }
            this.value = jExpr;
            this.subcomponent = this.outer.getSubcomponent(this.value.getText());
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private static Class loadClass(CmtComponent outer, String type) {
        JavaClass clazz = outer.getComponents().getPackages().getClass(type);
        if (clazz == null) {
            return null;
        }
        String sigName = JotNames.typeToDotSignature(clazz.getQualifiedName());
        Class c = null;
        try {
            c = outer.getComponents().getPackages().loadClass(sigName, true);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (c == null) {
            try {
                sigName = JotNames.typeToDotSignature(JotNames.getShortClassName(clazz.getQualifiedName()));
                c = outer.getComponents().getPackages().loadClass(sigName, true);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        if (c == null) {
            try {
                sigName = clazz.getVMName().replace('/', '.');
                c = outer.getComponents().getPackages().loadClass(sigName, true);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return c;
    }

    public Object getValue(JavaType type) throws CmtParseException {
        if (this.subcomponent != null) {
            return this.subcomponent.getLiveInstance();
        }
        if (this.value != null && type != null && type.getQualifiedName() != null) {
            return JbValue.getValue(this.value, type.getQualifiedName(), this.outer);
        }
        return null;
    }

    public static synchronized Object getValue(SourceExpression value, String type, CmtComponent outer) throws CmtParseException {
        switch (value.getSymbolKind()) {
            case 47: {
                Iterator iIter;
                SourceArrayAccessExpression jRef = (SourceArrayAccessExpression)value;
                Object lhs = JbValue.getValue(jRef.getLhsOperand(), "java.lang.Object", outer);
                SourceListExpression eList = (SourceListExpression)jRef.getSecondOperand();
                List indices = eList.getOperands();
                Iterator iterator = iIter = indices != null ? indices.iterator() : null;
                if (iIter != null && iIter.hasNext()) {
                    while (iIter.hasNext()) {
                        SourceExpression jExpr = (SourceExpression)iIter.next();
                        Object index = JbValue.getValue(jExpr, "int", outer);
                        if (lhs != null && lhs.getClass().isArray() && index instanceof Integer) {
                            lhs = Array.get(lhs, (Integer)index);
                            continue;
                        }
                        return null;
                    }
                    return lhs;
                }
                return null;
            }
            case 54: {
                SourceNewArrayExpression jArrayAlloc = (SourceNewArrayExpression)value;
                return JbValue.evaluateArrayInitializer(jArrayAlloc, outer);
            }
            case 48: {
                SourceAssignmentExpression jAssignment = (SourceAssignmentExpression)value;
                int operator = 0;
                switch (jAssignment.getOperatorCode()) {
                    case 2: {
                        operator = 1;
                        break;
                    }
                    case 32: {
                        operator = 31;
                        break;
                    }
                    case 36: {
                        operator = 35;
                        break;
                    }
                    case 18: {
                        operator = 17;
                        break;
                    }
                    case 34: {
                        operator = 33;
                        break;
                    }
                    case 8: {
                        operator = 7;
                        break;
                    }
                    case 11: {
                        operator = 10;
                        break;
                    }
                    case 13: {
                        operator = 12;
                        break;
                    }
                    case 29: {
                        operator = 28;
                        break;
                    }
                    case 52: {
                        operator = 51;
                        break;
                    }
                    case 57: {
                        operator = 56;
                        break;
                    }
                    default: {
                        return JbValue.getValue(jAssignment.getSecondOperand(), type, outer);
                    }
                }
                SourceFile jFile = jAssignment.getOwningSourceFile();
                SourceFactory jFactory = jFile.getFactory();
                SourceInfixExpression inExpr = jFactory.createInfixExpression(operator, (SourceExpression)jAssignment.getFirstOperand().cloneSelf(jFile), (SourceExpression)jAssignment.getSecondOperand().cloneSelf(jFile));
                return JbValue.evaluateOperation((SourceExpression)inExpr, type, outer);
            }
            case 55: {
                SourceNewClassExpression jClsAlloc = (SourceNewClassExpression)value;
                SourceClass jCls = jClsAlloc.getAnonymousClass();
                if (jCls != null) {
                    outer.logMessage(Res.format(49, new String[]{jCls.getResolvedType().getQualifiedName()}), jClsAlloc.getStartOffset(), jClsAlloc.getEndOffset(), 0);
                }
                return JbValue.evaluateClassAllocation(jClsAlloc, outer);
            }
            case 49: {
                SourceDotExpression jDot = (SourceDotExpression)value;
                String name = jDot.getName();
                SourceExpression jExpr = jDot.getLhsOperand();
                Object lhs = JbValue.getValue(jExpr, "java.lang.Object", outer);
                try {
                    if (lhs instanceof JavaPackage) {
                        CmtPackages jMgr = outer.getComponents().getPackages();
                        JavaClass jCls = jMgr.getClass(value.getText());
                        if (jCls != null) {
                            Class clazz = jMgr.loadClass(value.getText(), true);
                            return clazz;
                        }
                        lhs = jMgr.getPackage(value.getText());
                        if (lhs != null) {
                            Object object = lhs;
                            return object;
                        }
                        Object var49_26 = null;
                        return var49_26;
                    }
                    Field field = JbValue.getField(lhs, name);
                    Object object = field.get(lhs);
                    return object;
                }
                catch (Exception e) {
                    String clsName = lhs instanceof Class ? ((Class)lhs).getName() : lhs.getClass().getName();
                    outer.logMessage(Res.format(43, new String[]{name, clsName}), value.getStartOffset(), value.getEndOffset(), 2);
                    return null;
                }
            }
            case 50: {
                return JbValue.evaluateOperation(value, type, outer);
            }
            case 51: {
                int code = value.getExpressionCode();
                if (code == 5) {
                    int[] dimensions = Jot2Utils.getDimensions(type);
                    int offset = type.indexOf("[");
                    if (offset > 0) {
                        type = type.substring(0, offset);
                    }
                    Class c = null;
                    try {
                        c = outer.getComponents().getPackages().loadClass(JotNames.typeToDotSignature(type), true);
                    }
                    catch (Throwable t) {
                        Assert.printStackTrace((Throwable)t);
                    }
                    return JbValue.createArrayFromInitializer((SourceListExpression)value, dimensions, c, type, outer);
                }
                Assert.printStackTrace((boolean)true, (String)"Trying to evaluate a list!");
                return null;
            }
            case 52: {
                return JbValue.evaluatePrimaryExpression((SourceLiteralExpression)value, outer);
            }
            case 53: {
                SourceMethodCallExpression jMethodCall = (SourceMethodCallExpression)value;
                return JbValue.callMethod(jMethodCall, outer, true);
            }
            case 57: {
                String name = ((SourceSimpleNameExpression)value).getName();
                CmtSubcomponent sub = outer.getSubcomponent(name);
                if (sub != null) {
                    return sub.getLiveInstance();
                }
                CmtPackages jMgr = outer.getComponents().getPackages();
                JavaClass jCls = jMgr.getClass((SourceFile)outer.getFile(), name);
                if (jCls != null) {
                    try {
                        Class clazz = jMgr.loadClass(jCls.getQualifiedName(), true);
                        return clazz;
                    }
                    catch (Exception e) {
                        Object var52_43 = null;
                        return var52_43;
                    }
                }
                JavaPackage jPkg = jMgr.getPackage(name);
                if (jPkg != null) {
                    return jPkg;
                }
                outer.logMessage(Res.format(43, new String[]{name, outer.getType().getQualifiedName()}), value.getStartOffset(), value.getEndOffset(), 2);
                return null;
            }
            case 56: {
                return null;
            }
            case 58: {
                SourceTypeExpression jExpr = (SourceTypeExpression)value;
                SourceTypeReference jType = jExpr.getSourceType();
                String name = jType.getResolvedType().getQualifiedName();
                CmtPackages jMgr = outer.getComponents().getPackages();
                try {
                    Class clazz = jMgr.loadClass(name, false);
                    return clazz;
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                    Object var54_51 = null;
                    return var54_51;
                }
            }
            case 59: {
                SourceTypecastExpression jTypecast = (SourceTypecastExpression)value;
                return JbValue.getValue(jTypecast.getSecondOperand(), type, outer);
            }
            case 60: {
                return JbValue.evaluateOperation(value, type, outer);
            }
            case 61: {
                SourceWrapperExpression jWrapper = (SourceWrapperExpression)value;
                List list = jWrapper.getOperands();
                if (list != null && list.size() == 1) {
                    return JbValue.getValue((SourceExpression)list.get(0), type, outer);
                }
                Assert.printStackTrace((boolean)true, (String)"More than one element in wrapper!");
                return null;
            }
        }
        Assert.printStackTrace((boolean)true, (String)"Unrecognized SourceExpression element type");
        return null;
    }

    private static Object evaluateClassAllocation(SourceNewClassExpression jClsAlloc, CmtComponent outer) {
        try {
            List list;
            String clsName = jClsAlloc.getSourceType().getResolvedType().getQualifiedName();
            String proxy = UIManager.getConcreteProxy(clsName);
            Class c = null;
            if (proxy != null) {
                if (outer != null) {
                    CmtPackages pkgs = outer.getComponents().getPackages();
                    pkgs.addDesignTimePath(UIManager.getProxyPath(clsName));
                }
                c = JbValue.loadClass(outer, proxy);
            }
            if (c == null) {
                c = JbValue.loadClass(outer, clsName);
            }
            Assert.printStackTrace(((list = jClsAlloc.getOperands()) == null || list.size() > 1 ? 1 : 0) != 0, (String)"Unexpected constructor arguments!");
            SourceListExpression args = list != null ? (SourceListExpression)list.get(0) : null;
            SourceExpression[] clsAllocArgs = new SourceExpression[args != null ? args.getOperandCount() : 0];
            String[] clsAllocArgTypes = new String[clsAllocArgs.length];
            Constructor<?>[] ctors = c.getConstructors();
            if (clsAllocArgs.length > 0) {
                Iterator lIter;
                list = args.getOperands();
                Iterator iterator = lIter = list != null ? list.iterator() : null;
                if (lIter != null) {
                    int i = 0;
                    while (lIter.hasNext()) {
                        clsAllocArgs[i] = (SourceExpression)lIter.next();
                        clsAllocArgTypes[i] = JbValue.getTypeOfExpression(clsAllocArgs[i], outer);
                        if (clsAllocArgTypes[i] != null && clsAllocArgTypes[i].equals("null")) {
                            clsAllocArgTypes[i] = null;
                        }
                        ++i;
                    }
                }
            }
            int ci = 0;
            while (ci < ctors.length) {
                block32: {
                    Class<?>[] ctorParamTypes;
                    int modifiers = ctors[ci].getModifiers();
                    if (Modifier.isPublic(modifiers) && (ctorParamTypes = ctors[ci].getParameterTypes()).length == clsAllocArgs.length) {
                        Object[] liveArgs = new Object[ctorParamTypes.length];
                        int ai = 0;
                        while (ai < ctorParamTypes.length) {
                            Class foundClass;
                            String ctorParamType = ctorParamTypes[ai].getName();
                            String clsAllocArgType = clsAllocArgTypes[ai];
                            if (clsAllocArgType != null && !JbValue.typesMatch(ctorParamTypes[ai], foundClass = JbValue.loadClass(outer, clsAllocArgType), clsAllocArgs[ai].getText())) {
                                clsAllocArgType = null;
                                if (ctorParamTypes[ai].isPrimitive() && foundClass.isPrimitive()) {
                                    if (ctorParamTypes[ai] == Double.TYPE) {
                                        clsAllocArgType = ctorParamType;
                                    } else if (ctorParamTypes[ai] == Float.TYPE) {
                                        if (foundClass != Double.TYPE) {
                                            clsAllocArgType = ctorParamType;
                                        }
                                    } else if (ctorParamTypes[ai] == Long.TYPE) {
                                        if (foundClass != Double.TYPE && foundClass != Float.TYPE) {
                                            clsAllocArgType = ctorParamType;
                                        }
                                    } else if (ctorParamTypes[ai] == Integer.TYPE) {
                                        if (foundClass != Double.TYPE && foundClass != Float.TYPE && foundClass != Long.TYPE) {
                                            clsAllocArgType = ctorParamType;
                                        }
                                    } else if (ctorParamTypes[ai] == Short.TYPE && foundClass == Byte.TYPE) {
                                        clsAllocArgType = ctorParamType;
                                    }
                                }
                                if (clsAllocArgType == null) break block32;
                            }
                            if (clsAllocArgType == null) {
                                clsAllocArgType = ctorParamType;
                            }
                            if (ctorParamTypes[ai] != null && !ctorParamTypes[ai].isPrimitive() && !ctorParamTypes[ai].isArray() && Modifier.isAbstract(ctorParamTypes[ai].getModifiers())) {
                                ctorParamType = clsAllocArgType;
                            }
                            try {
                                liveArgs[ai] = JbValue.getValue(clsAllocArgs[ai], clsAllocArgType, outer);
                            }
                            catch (CmtParseException e) {
                                liveArgs[ai] = null;
                            }
                            ++ai;
                        }
                        try {
                            Object obj = ctors[ci].newInstance(liveArgs);
                            return obj;
                        }
                        catch (Exception x) {
                            Assert.println((String)("Failed trying " + ctors[ci] + "trying alternate construction..."));
                            if (!ImageIcon.class.isAssignableFrom(c)) break block32;
                            ImageIcon imageIcon = new ImageIcon(JbValue.getUnknownImageURL());
                            return imageIcon;
                        }
                    }
                }
                ++ci;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private static Object evaluatePrimaryExpression(SourceLiteralExpression jPrimary, CmtComponent outer) throws CmtParseException {
        String strValue = jPrimary.getText();
        char charValue = '\u0000';
        int type = jPrimary.getTokenValue();
        try {
            if (strValue != null && strValue.startsWith("'") && strValue.endsWith("'")) {
                charValue = FastStringBuffer.charFromString((String)strValue.substring(1));
            }
            switch (type) {
                case 12: {
                    Boolean bl = new Boolean(strValue);
                    return bl;
                }
                case 13: {
                    Character c = new Character(charValue);
                    return c;
                }
                case 8: {
                    if (charValue != '\u0000') {
                        Integer n = new Integer(charValue);
                        return n;
                    }
                    char lastChar = strValue.charAt(strValue.length() - 1);
                    if (!Character.isDigit(lastChar)) {
                        strValue = strValue.substring(0, strValue.length() - 1);
                    }
                    Integer n = Integer.valueOf(strValue);
                    return n;
                }
                case 9: {
                    if (charValue != '\u0000') {
                        Long l = new Long(charValue);
                        return l;
                    }
                    char lastChar = strValue.charAt(strValue.length() - 1);
                    if (!Character.isDigit(lastChar)) {
                        strValue = strValue.substring(0, strValue.length() - 1);
                    }
                    Long l = Long.valueOf(strValue);
                    return l;
                }
                case 10: {
                    if (charValue != '\u0000') {
                        Float f = new Float(charValue);
                        return f;
                    }
                    char lastChar = strValue.charAt(strValue.length() - 1);
                    if (!Character.isDigit(lastChar)) {
                        strValue = strValue.substring(0, strValue.length() - 1);
                    }
                    Float f = Float.valueOf(strValue);
                    return f;
                }
                case 11: {
                    if (charValue != '\u0000') {
                        Double d = new Double(charValue);
                        return d;
                    }
                    char lastChar = strValue.charAt(strValue.length() - 1);
                    if (!Character.isDigit(lastChar)) {
                        strValue = strValue.substring(0, strValue.length() - 1);
                    }
                    Double d = Double.valueOf(strValue);
                    return d;
                }
                case 14: {
                    String string = FastStringBuffer.sourceToText((String)strValue).toString();
                    return string;
                }
                case 15: {
                    Object var22_20 = null;
                    return var22_20;
                }
            }
            throw new CmtParseException(strValue);
        }
        catch (CmtParseException e) {
            throw e;
        }
        catch (Exception e) {
            Object var23_23 = null;
            return var23_23;
        }
    }

    private static Object evaluateOperationGetValue(SourceExpression jExpr, String type, CmtComponent outer) throws CmtParseException {
        if (jExpr == null) {
            return null;
        }
        switch (jExpr.getSymbolKind()) {
            case 50: 
            case 59: 
            case 60: {
                return JbValue.evaluateOperation(jExpr, type, outer);
            }
        }
        return JbValue.getValue(jExpr, type, outer);
    }

    private static Object evaluateOperation(SourceExpression jExpr, String type, CmtComponent outer) throws CmtParseException {
        try {
            if (jExpr == null) {
                Object var50_3 = null;
                return var50_3;
            }
            switch (jExpr.getSymbolKind()) {
                case 60: {
                    Class<?> cls;
                    SourceUnaryExpression jUnary = (SourceUnaryExpression)jExpr;
                    int op = jUnary.getOperatorCode();
                    Object o = JbValue.getValue(jUnary.getFirstOperand(), type, outer);
                    Class<?> clazz = cls = o != null ? o.getClass() : null;
                    if (op == 14) {
                        Class<?> clazz2 = cls;
                        return clazz2;
                    }
                    if (cls != null) {
                        if (cls == Boolean.class) {
                            switch (op) {
                                case 41: {
                                    Boolean bl = (Boolean)o != false ? Boolean.FALSE : Boolean.TRUE;
                                    return bl;
                                }
                            }
                        } else if (cls == Character.class) {
                            switch (op) {
                                case 9: {
                                    Integer n = new Integer(~((Character)o).charValue());
                                    return n;
                                }
                                case 37: {
                                    Integer n = new Integer(-((Character)o).charValue());
                                    return n;
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    Object object = o;
                                    return object;
                                }
                                case 47: {
                                    char c = ((Character)o).charValue();
                                    c = (char)(c - '\u0001');
                                    Character c2 = new Character(c);
                                    return c2;
                                }
                                case 48: {
                                    char c = ((Character)o).charValue();
                                    c = (char)(c + '\u0001');
                                    Character c3 = new Character(c);
                                    return c3;
                                }
                            }
                        } else if (cls == Byte.class) {
                            switch (op) {
                                case 9: {
                                    Integer n = new Integer(~((Byte)o).byteValue());
                                    return n;
                                }
                                case 37: {
                                    Integer n = new Integer(-((Byte)o).byteValue());
                                    return n;
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    Object object = o;
                                    return object;
                                }
                                case 47: {
                                    byte b = (Byte)o;
                                    b = (byte)(b - 1);
                                    Byte by = new Byte(b);
                                    return by;
                                }
                                case 48: {
                                    byte b = (Byte)o;
                                    b = (byte)(b + 1);
                                    Byte by = new Byte(b);
                                    return by;
                                }
                            }
                        } else if (cls == Short.class) {
                            switch (op) {
                                case 9: {
                                    Integer n = new Integer(~((Short)o).shortValue());
                                    return n;
                                }
                                case 37: {
                                    Integer n = new Integer(-((Short)o).shortValue());
                                    return n;
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    Object object = o;
                                    return object;
                                }
                                case 47: {
                                    short s = (Short)o;
                                    s = (short)(s - 1);
                                    Short s2 = new Short(s);
                                    return s2;
                                }
                                case 48: {
                                    short s = (Short)o;
                                    s = (short)(s + 1);
                                    Short s3 = new Short(s);
                                    return s3;
                                }
                            }
                        } else if (cls == Integer.class) {
                            switch (op) {
                                case 9: {
                                    Integer n = new Integer(~((Integer)o).intValue());
                                    return n;
                                }
                                case 37: {
                                    Integer n = new Integer(-((Integer)o).intValue());
                                    return n;
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    Object object = o;
                                    return object;
                                }
                                case 47: {
                                    int i = (Integer)o;
                                    Integer n = new Integer(--i);
                                    return n;
                                }
                                case 48: {
                                    int i = (Integer)o;
                                    Integer n = new Integer(++i);
                                    return n;
                                }
                            }
                        } else if (cls == Long.class) {
                            switch (op) {
                                case 9: {
                                    Long l = new Long((Long)o ^ (long)-1);
                                    return l;
                                }
                                case 37: {
                                    Long l = new Long(-((Long)o).longValue());
                                    return l;
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    Object object = o;
                                    return object;
                                }
                                case 47: {
                                    long l = (Long)o;
                                    Long l2 = new Long(--l);
                                    return l2;
                                }
                                case 48: {
                                    long l = (Long)o;
                                    Long l3 = new Long(++l);
                                    return l3;
                                }
                            }
                        } else if (cls == Float.class) {
                            switch (op) {
                                case 37: {
                                    Float f = new Float(-((Float)o).floatValue());
                                    return f;
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    Object object = o;
                                    return object;
                                }
                                case 47: {
                                    float f = ((Float)o).floatValue();
                                    Float f2 = new Float(f -= 1.0f);
                                    return f2;
                                }
                                case 48: {
                                    float f = ((Float)o).floatValue();
                                    Float f3 = new Float(f += 1.0f);
                                    return f3;
                                }
                            }
                        } else if (cls == Double.class) {
                            switch (op) {
                                case 37: {
                                    Double d = new Double(-((Double)o).doubleValue());
                                    return d;
                                }
                                case 44: 
                                case 45: 
                                case 46: {
                                    Object object = o;
                                    return object;
                                }
                                case 47: {
                                    double d = (Double)o;
                                    Double d2 = new Double(d -= 1.0);
                                    return d2;
                                }
                                case 48: {
                                    double d = (Double)o;
                                    Double d3 = new Double(d += 1.0);
                                    return d3;
                                }
                            }
                        }
                    }
                    Object object = o;
                    return object;
                }
                case 59: {
                    SourceTypecastExpression jTypecast = (SourceTypecastExpression)jExpr;
                    Object object = JbValue.getValue(jTypecast.getSecondOperand(), type, outer);
                    return object;
                }
                case 50: {
                    SourceInfixExpression binOp = (SourceInfixExpression)jExpr;
                    int operator = binOp.getOperatorCode();
                    SourceExpression lhs = binOp.getFirstOperand();
                    SourceExpression rhs = binOp.getSecondOperand();
                    Object o1 = JbValue.evaluateOperationGetValue(lhs, type, outer);
                    Object o2 = JbValue.evaluateOperationGetValue(rhs, type, outer);
                    if (o1 == null && o2 == null) {
                        Object var88_66 = null;
                        return var88_66;
                    }
                    if (type.equals("java.lang.String")) {
                        if (operator == 1) {
                            String s;
                            String string = s = o1 == null ? o2.toString() : (o2 == null ? o1.toString() : o1.toString() + o2.toString());
                            return string;
                        }
                    } else if (type.equals("int")) {
                        switch (operator) {
                            case 1: {
                                try {
                                    int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 + (Integer)o2);
                                    Integer n = new Integer(result);
                                    return n;
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                    Object var91_72 = null;
                                    return var91_72;
                                }
                            }
                            case 31: {
                                try {
                                    int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 - (Integer)o2);
                                    Integer n = new Integer(result);
                                    return n;
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                    Object var93_76 = null;
                                    return var93_76;
                                }
                            }
                            case 35: {
                                try {
                                    int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 * (Integer)o2);
                                    Integer n = new Integer(result);
                                    return n;
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                    Object var95_80 = null;
                                    return var95_80;
                                }
                            }
                            case 33: {
                                try {
                                    int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 % (Integer)o2);
                                    Integer n = new Integer(result);
                                    return n;
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                    Object var97_84 = null;
                                    return var97_84;
                                }
                            }
                            case 17: {
                                try {
                                    int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 / (Integer)o2);
                                    Integer n = new Integer(result);
                                    return n;
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                    Object var99_88 = null;
                                    return var99_88;
                                }
                            }
                            case 10: {
                                try {
                                    int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 | (Integer)o2);
                                    Integer n = new Integer(result);
                                    return n;
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                    Object var101_92 = null;
                                    return var101_92;
                                }
                            }
                            case 7: {
                                try {
                                    int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 & (Integer)o2);
                                    Integer n = new Integer(result);
                                    return n;
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                    Object var103_96 = null;
                                    return var103_96;
                                }
                            }
                            case 12: {
                                try {
                                    int result = o1 == null ? (Integer)o2 : (o2 == null ? (Integer)o1 : (Integer)o1 ^ (Integer)o2);
                                    Integer n = new Integer(result);
                                    return n;
                                }
                                catch (Exception e) {
                                    Assert.printStackTrace((Throwable)e);
                                    Object var105_100 = null;
                                    return var105_100;
                                }
                            }
                        }
                        Assert.println((String)("*** currently no support for " + jExpr.getText()));
                    }
                    break;
                }
            }
        }
        catch (Throwable t) {
            Assert.printStackTrace((Throwable)t);
        }
        return null;
    }

    private static Field getField(Object base, String name) throws NoSuchFieldException {
        if (base instanceof Class) {
            return ((Class)base).getField(name);
        }
        if (base != null) {
            return base.getClass().getField(name);
        }
        return null;
    }

    private static boolean typesMatch(Class expectedClass, Class foundClass, String sourceText) {
        if (expectedClass == null) {
            return false;
        }
        if (expectedClass.isAssignableFrom(foundClass)) {
            return true;
        }
        Field[] fields = foundClass.getFields();
        int i = 0;
        while (i < fields.length) {
            String shortName = JotNames.getShortClassName(fields[i].getName());
            if ((sourceText.indexOf(shortName) >= 0 || sourceText.indexOf(fields[i].getName()) >= 0) && expectedClass.isAssignableFrom(fields[i].getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getTypeOfExpression(SourceExpression e, CmtComponent outer) {
        if (e != null) {
            JavaType jType = e.getResolvedType();
            return jType != null ? jType.getQualifiedName() : null;
        }
        return null;
    }

    public String toString() {
        return this.getText();
    }

    static void fillArray(Object array, SourceExpression[] elements, int[] dimensions, int nDim, String type, CmtComponent outer, Class c) {
        block8: {
            try {
                if (nDim + 1 >= dimensions.length) {
                    int i = 0;
                    while (i < elements.length) {
                        try {
                            Array.set(array, i, JbValue.getValue(elements[i], type, outer));
                        }
                        catch (CmtParseException e) {
                            Array.set(array, i, null);
                        }
                        ++i;
                    }
                    break block8;
                }
                int j = 0;
                while (j < dimensions[nDim]) {
                    SourceExpression[] elems;
                    SourceListExpression expr = elements != null ? (SourceListExpression)elements[j] : null;
                    List list = expr != null ? expr.getOperands() : null;
                    SourceExpression[] sourceExpressionArray = elems = list != null && list.size() > 0 ? new SourceExpression[list.size()] : null;
                    if (elems != null) {
                        list.toArray(elems);
                    }
                    JbValue.fillArray(Array.get(array, j), elems, dimensions, nDim + 1, type, outer, c);
                    ++j;
                }
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }
    }

    static int getDimensionality(SourceExpression[] elements, int[] dimensions, int nDimensions) {
        if (dimensions != null) {
            dimensions[nDimensions] = elements.length;
        }
        ++nDimensions;
        if (elements != null && elements.length > 0 && elements[0] != null && elements[0].getSymbolKind() == 51) {
            List list = ((SourceListExpression)elements[0]).getOperands();
            SourceExpression[] sourceExpressionArray = elements = list.size() > 0 ? new SourceExpression[list.size()] : null;
            if (elements != null) {
                list.toArray(elements);
            }
            return JbValue.getDimensionality(elements, dimensions, nDimensions);
        }
        return nDimensions;
    }

    static Object evaluateArrayInitializer(SourceNewArrayExpression jotNew, CmtComponent outer) {
        List init;
        JavaType jType = jotNew.getResolvedType();
        String name = jType.getQualifiedName();
        int[] dimensions = Jot2Utils.getDimensions(name);
        int offset = name.indexOf("[");
        if (offset > 0) {
            name = name.substring(0, offset);
        }
        SourceListExpression expr = (init = jotNew.getOperands()) != null && init.size() == 1 ? (SourceListExpression)init.get(0) : null;
        Class c = null;
        try {
            c = outer.getComponents().getPackages().loadClass(JotNames.typeToDotSignature(name), true);
        }
        catch (Throwable t) {
            Assert.printStackTrace((Throwable)t);
        }
        return JbValue.createArrayFromInitializer(expr, dimensions, c, name, outer);
    }

    static Object createArrayFromInitializer(SourceListExpression init, int[] dimensions, Class c, String type, CmtComponent outer) {
        try {
            List list = init != null ? init.getOperands() : null;
            SourceExpression[] elements = null;
            if (list != null && list.size() > 0) {
                SourceExpression elem = (SourceExpression)list.get(0);
                int kind = elem.getSymbolKind();
                if (kind == 61) {
                    int i = 0;
                    while (i < dimensions.length) {
                        elem = (SourceExpression)list.get(i);
                        dimensions[i] = (Integer)JbValue.getValue(elem, type, outer);
                        ++i;
                    }
                } else {
                    elements = new SourceExpression[list.size()];
                    list.toArray(elements);
                    JbValue.getDimensionality(elements, dimensions, 0);
                }
            }
            Object array = Array.newInstance(c, dimensions);
            if (elements != null) {
                JbValue.fillArray(array, elements, dimensions, 0, type, outer, c);
            }
            Object object = array;
            return object;
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
            Object var13_13 = null;
            return var13_13;
        }
    }

    static Object callMethod(SourceMethodCallExpression jMethodCall, CmtComponent outer, boolean doInvoke) {
        Object result = null;
        try {
            if (jMethodCall == null) {
                Object var6_4 = null;
                return var6_4;
            }
            JbMethodCall jbMethodCall = new JbMethodCall(jMethodCall, outer);
            Object object = doInvoke ? jbMethodCall.invoke() : jbMethodCall.getReturnType();
            return object;
        }
        catch (Throwable t) {
            Assert.println((String)("** Failed trying to invoke: " + jMethodCall.getText()));
            return result;
        }
    }

    private static URL getUnknownImageURL() {
        if (UNKNOWN_IMAGE == null) {
            UNKNOWN_IMAGE = CmtValue.class.getResource("images/unknownImage.gif");
        }
        return UNKNOWN_IMAGE;
    }
}

