/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ant;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.model.Node;
import oracle.ide.runner.SmartDataProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.jdeveloper.ant.AntNode;

public class AntSmartDataProvider
implements SmartDataProvider {
    public boolean canUnderstand(Node node) {
        return node instanceof AntNode;
    }

    public void getExpressions(ReadTextBuffer tb, int startOffset, int endOffset, List expressions) {
        tb.readLock();
        try {
            String input = tb.getString(startOffset, endOffset - startOffset);
            int startTag = input.indexOf("<");
            int endTag = input.indexOf("/>");
            if (endTag != -1 && (startTag == -1 || startTag > endTag)) {
                startTag = -1;
                int i = startOffset;
                while (--i >= 0) {
                    char c = tb.getChar(i);
                    if (c == '<') {
                        startTag = i;
                        break;
                    }
                    if (c == '>') break;
                }
                if (startTag != -1) {
                    input = tb.getString(startTag, endOffset - startTag);
                }
            }
            Pattern pattern = Pattern.compile("(?:^|[^\\$])(\\$\\{(.+?)\\})");
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                String property = matcher.group(2);
                expressions.add(property);
            }
        }
        finally {
            tb.readUnlock();
        }
    }
}

