/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ant;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.log.MessagePage;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.debugger.ant.DebugAntArb;
import oracle.jdevimpl.debugger.ant.DebugAntBreakpoint;
import oracle.jdevimpl.debugger.ant.DebugAntBreakpointFileLine;
import oracle.jdevimpl.debugger.ant.DebugAntBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.ant.DebugAntClassInfo;
import oracle.jdevimpl.debugger.ant.DebugAntDataInfo;
import oracle.jdevimpl.debugger.ant.DebugAntMethodInfo;
import oracle.jdevimpl.debugger.ant.DebugAntStackFrameInfo;
import oracle.jdevimpl.debugger.ant.DebugAntThreadGroupInfo;
import oracle.jdevimpl.debugger.ant.DebugAntThreadInfo;
import oracle.jdevimpl.debugger.ant.DebugAntTransport;
import oracle.jdevimpl.debugger.ant.DebugAntVariableInfo;
import oracle.jdevimpl.debugger.shared.DebugEventMulticaster;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedLocation;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointAllocationThreshold;
import oracle.jdevimpl.debugger.support.DebugBreakpointClass;
import oracle.jdevimpl.debugger.support.DebugBreakpointClassLoad;
import oracle.jdevimpl.debugger.support.DebugBreakpointDeadlock;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;
import oracle.jdevimpl.debugger.support.DebugBreakpointFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointLogListener;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethod;
import oracle.jdevimpl.debugger.support.DebugBreakpointMethodBytecode;
import oracle.jdevimpl.debugger.support.DebugBreakpointPackageFileLine;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugListener;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.UserSelectedURLCacher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugAnt
implements DebugVirtualMachine,
DebugCapabilities {
    private volatile Thread runningThread;
    private boolean stopped;
    private boolean terminated;
    private boolean terminateRequested;
    private boolean disconnectRequested;
    private boolean pauseRequested;
    private Map properties;
    private DebugBreakpointLogListener bpLogListener;
    private DebugListener debugListener;
    private DebugAntTransport transport;
    private DebugAntVariableInfo[] variables;
    private IntHashMap breakpoints;
    private IntHashMap threads;
    protected int stoppedCount;
    private DebugStackFrameInfo currentStackFrame;
    private DebugAntThreadGroupInfo threadGroup;
    public static final int RESPONSE_Ok = 1;
    public static final int RESPONSE_NotOk = 2;
    public static final int COMMAND_Start = -1;
    public static final int COMMAND_Quit = 34;
    public static final int COMMAND_GetCurrentBreakpoint = 39;
    public static final int COMMAND_GetCurrentThread = 40;
    public static final int COMMAND_Run = 64;
    public static final int COMMAND_StepInto = 65;
    public static final int COMMAND_StepOver = 66;
    public static final int COMMAND_StepOut = 69;
    public static final int COMMAND_DidStepFinish = 71;
    public static final int COMMAND_ContinueStep = 72;
    public static final int COMMAND_GetThreads = 160;
    public static final int COMMAND_GetStackFrame = 165;
    public static final int COMMAND_PutBreakpointFileLine = 80;
    public static final int COMMAND_RemoveBreakpoint = 97;
    public static final int COMMAND_RemoveAllBreakpoints = 98;
    public static final int COMMAND_SetBreakpointThread = 99;
    public static final int COMMAND_SetBreakpointEnabled = 100;
    public static final int COMMAND_SetBreakpointStop = 101;
    public static final int COMMAND_SetBreakpointLog = 102;
    public static final int COMMAND_SetBreakpointName = 103;
    public static final int COMMAND_SetBreakpointEnableOtherBPs = 104;
    public static final int COMMAND_SetBreakpointDisableOtherBPs = 105;
    public static final int COMMAND_SetBreakpointPassCount = 106;
    public static final int COMMAND_SetBreakpointCondition = 107;
    public static final int COMMAND_SetBreakpointThreadNot = 108;
    public static final int COMMAND_GetStackFrames = 166;
    public static final int COMMAND_GetStackFrameCount = 175;
    public static final int COMMAND_GetLocals = 177;
    public static final int COMMAND_ModifyString = 191;
    public static final int NOTIFICATION_ProgramStopped = 240;
    public static final int NOTIFICATION_ProgramTerminated = 241;
    public static final int NOTIFICATION_DoYouWantToPause = 242;
    public static final int NOTIFICATION_BreakpointLog = 246;
    public static final int NOTIFICATION_BreakpointCondition = 251;
    public static final int NOTIFICATION_BreakpointEnabled = 255;
    private UserSelectedURLCacher userUrlCacher;

    private void $init$() {
        this.properties = new HashMap();
        this.breakpoints = new IntHashMap();
        this.threads = new IntHashMap();
        this.threadGroup = new DebugAntThreadGroupInfo(this);
        this.userUrlCacher = null;
    }

    public DebugAnt(DebugAntTransport transport) {
        this.$init$();
        this.transport = transport;
    }

    public DebugAntThreadGroupInfo getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public DebugCapabilities getCapabilities() {
        return this;
    }

    @Override
    public void afterConnection(MessagePage logPage) {
    }

    @Override
    public synchronized void addDebugListener(DebugListener l) {
        this.debugListener = DebugEventMulticaster.add(this.debugListener, l);
    }

    @Override
    public synchronized void removeDebugListener(DebugListener l) {
        this.debugListener = DebugEventMulticaster.remove(this.debugListener, l);
    }

    @Override
    public synchronized void addBreakpointLogListener(DebugBreakpointLogListener l) {
        this.bpLogListener = DebugEventMulticaster.add(this.bpLogListener, l);
    }

    @Override
    public synchronized void removeBreakpointLogListener(DebugBreakpointLogListener l) {
        this.bpLogListener = DebugEventMulticaster.remove(this.bpLogListener, l);
    }

    @Override
    public boolean isConnected() {
        return this.transport.isConnected();
    }

    @Override
    public boolean isRunning() {
        return this.runningThread != null;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public boolean wasRunning() {
        return false;
    }

    @Override
    public void disconnect() {
        this.disconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(boolean terminate) {
        if (this.isRunning()) {
            this.terminateRequested = terminate;
            this.disconnectRequested = true;
        } else {
            DebugAnt debugAnt = this;
            synchronized (debugAnt) {
                if (this.isConnected()) {
                    if (!this.terminated) {
                        this.transport.sendMessage(34, terminate);
                    }
                    this.transport.disconnect();
                    this.incrementStoppedCount();
                }
            }
        }
    }

    @Override
    public void addConnectionLog(Object connectionLog) {
    }

    @Override
    public void removeConnectionLog(Object connectionLog) {
    }

    @Override
    public String getName() {
        return "Apache Ant";
    }

    @Override
    public int getLanguages() {
        return 8;
    }

    @Override
    public String[] redefineClasses(Map nameToGuts) {
        return null;
    }

    @Override
    public void setNonDebuggablePackages(String nonDebuggablePackages) {
    }

    @Override
    public void setDebuggablePackages(String debuggablePackages, String nonDebuggablePackages) {
    }

    @Override
    public void requestCodeCoverage(String pkg, String filename) {
    }

    @Override
    public void unrequestCodeCoverage(String pkg, String filename) {
    }

    @Override
    public void discardCodeCoverage() {
    }

    @Override
    public synchronized DebugBreakpointPackageFileLine putBreakpointPackageFileLine(String pkg, String filename, int line) {
        DebugAntBreakpointPackageFileLine bp = new DebugAntBreakpointPackageFileLine(this, pkg, filename, line);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public synchronized DebugBreakpointFileLine putBreakpointFileLine(String filename, int line) {
        DebugAntBreakpointFileLine bp = new DebugAntBreakpointFileLine(this, filename, line);
        this.putBreakpoint(bp);
        return bp;
    }

    @Override
    public DebugBreakpointMethodBytecode putBreakpointMethodBytecode(String method, int bytecodeOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointMethod putBreakpointMethod(String method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointClass putBreakpointClass(String classname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointException putBreakpointException(String exception) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointException putBreakpointException(String exception, boolean caught, boolean uncaught) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointClassLoad putBreakpointClassLoad(String classname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointAllocationThreshold putBreakpointAllocationThreshold(int threshold) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointAllocationClass putBreakpointAllocationClass(String classname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointDeadlock putBreakpointDeadlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public DebugBreakpointWatchpoint putBreakpointWatchpoint(String className, String fieldName, boolean access, boolean modify) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void removeAllBreakpoints() {
        this.throwIfRunning();
        this.transport.sendMessage(98);
    }

    @Override
    public void setPauseInterval(int i) {
    }

    @Override
    public void pauseProgram() {
        this.pauseRequested = true;
    }

    @Override
    public void cancelPauseProgram() {
        this.pauseRequested = false;
    }

    @Override
    public synchronized void resume() {
        this.doRunCommand(64, null);
    }

    @Override
    public void start(boolean stepOverClassInit) {
        this.doRunCommand(-1, null);
    }

    @Override
    public synchronized boolean didStepFinish() {
        this.throwIfRunning();
        this.transport.sendMessage(71);
        return this.transport.receiveBoolean();
    }

    @Override
    public synchronized void continueStep() {
        this.doRunCommand(72, null);
    }

    private synchronized void doRunCommand(int command, DebugAntThreadInfo thread) {
        this.stopped = false;
        this.incrementStoppedCount();
        this.runningThread = new RunThread(command, thread);
        this.runningThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointLog() {
        DebugStackFrameInfo[] stack;
        DebugAntThreadInfo thread;
        int cookie;
        DebugAnt debugAnt = this;
        synchronized (debugAnt) {
            cookie = this.transport.receiveInteger();
            thread = this.receiveThread();
            stack = this.receiveStack(thread);
        }
        DebugAntBreakpointFileLine breakpoint = (DebugAntBreakpointFileLine)this.breakpoints.get(cookie);
        if (breakpoint != null) {
            if (stack.length > 0) {
                breakpoint.location = stack[0].getLocation();
                if (this.debugListener != null) {
                    this.debugListener.breakpointChanged(breakpoint);
                }
            }
            this.bpLogListener.logBreakpoint(breakpoint, thread, stack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointCondition() {
        DebugStackFrameInfo[] stack;
        DebugAntThreadInfo thread;
        int cookie;
        DebugAnt debugAnt = this;
        synchronized (debugAnt) {
            cookie = this.transport.receiveInteger();
            thread = this.receiveThread();
            stack = this.receiveStack(thread);
            this.variables = this.receiveVariableInfos();
        }
        boolean result = false;
        DebugAntBreakpointFileLine breakpoint = (DebugAntBreakpointFileLine)this.breakpoints.get(cookie);
        if (breakpoint != null && breakpoint.condition != null) {
            result = breakpoint.condition.checkBreakpointCondition(breakpoint, this, thread, stack);
        }
        DebugAnt debugAnt2 = this;
        synchronized (debugAnt2) {
            this.transport.sendMessage(result ? 1 : 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifiedBreakpointEnabled() {
        boolean enabled;
        int cookie;
        DebugAnt debugAnt = this;
        synchronized (debugAnt) {
            cookie = this.transport.receiveInteger();
            enabled = this.transport.receiveBoolean();
        }
        DebugAntBreakpointFileLine breakpoint = (DebugAntBreakpointFileLine)this.breakpoints.get(cookie);
        if (breakpoint != null) {
            breakpoint.enabled = enabled;
            if (this.debugListener != null) {
                this.debugListener.breakpointChanged(breakpoint);
            }
        }
    }

    @Override
    public int getCurrentStatus() {
        if (this.stopped) {
            DebugBreakpoint bp = this.getCurrentBreakpoint();
            return bp != null ? 1 : 7;
        }
        return 0;
    }

    @Override
    public synchronized DebugBreakpoint getCurrentBreakpoint() {
        this.throwIfRunning();
        this.transport.sendMessage(39);
        return this.findBreakpoint(this.transport.receiveInteger());
    }

    @Override
    public synchronized DebugThreadInfo getCurrentThread() {
        this.throwIfRunning();
        this.transport.sendMessage(40);
        return this.receiveThread();
    }

    @Override
    public DebugDataObjectInfo getCurrentThrow() {
        return null;
    }

    @Override
    public boolean isCurrentThrowHandled() {
        return false;
    }

    @Override
    public DebugLocation getCurrentThrowHandler() {
        return null;
    }

    @Override
    public DebugDataObjectInfo getWatchpointObject() {
        return null;
    }

    @Override
    public DebugFieldInfo getWatchpointField() {
        return null;
    }

    @Override
    public DebugDataInfo getWatchpointFieldFutureValue() {
        return null;
    }

    @Override
    public synchronized DebugThreadInfo[] listThreads() {
        this.throwIfRunning();
        this.transport.sendMessage(160);
        return this.receiveThreads();
    }

    @Override
    public DebugMonitorInfo[] listMonitorsInUse() {
        return null;
    }

    @Override
    public DebugThreadInfo[] listWaitingThreads() {
        return null;
    }

    @Override
    public DebugThreadInfo[] listBlockedThreads() {
        return null;
    }

    @Override
    public DebugClassInfo[] listClasses() {
        return new DebugClassInfo[0];
    }

    @Override
    public DebugClassInfo[] listClasses(boolean fast) {
        return new DebugClassInfo[0];
    }

    @Override
    public int countClasses() {
        return 0;
    }

    @Override
    public DebugClassInfo findFirstClassByName(String name) {
        return null;
    }

    @Override
    public DebugClassInfo findFirstClassByName(String name, boolean nameWithoutPackage) {
        return null;
    }

    @Override
    public DebugClassLoaderInfo[] listClassLoaders() {
        return new DebugClassLoaderInfo[0];
    }

    @Override
    public int countHeap(DebugHeapSubset subset) {
        return 0;
    }

    @Override
    public DebugHeapInfo getHeap(DebugHeapSubset subset) {
        return null;
    }

    @Override
    public DebugHeapInfo getHeap(DebugHeapSubset subset, int sort) {
        return null;
    }

    @Override
    public int getSizeOfAddress() {
        return 0;
    }

    @Override
    public boolean isHeapAddressValid(long address) {
        return false;
    }

    @Override
    public DebugHeapObjectInfo getHeapObjectAtAddress(long address) {
        return null;
    }

    @Override
    public void doGarbageCollection() {
    }

    protected synchronized void removeBreakpoint(DebugAntBreakpoint breakpoint) {
        this.throwIfRunning();
        this.breakpoints.remove(breakpoint.cookie);
        this.transport.sendMessage(97, breakpoint.cookie);
    }

    protected synchronized void setBreakpointEnabled(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(100, bp.cookie, bp.enabled);
    }

    protected synchronized void setBreakpointStop(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(101, bp.cookie, bp.stop);
    }

    protected synchronized void setBreakpointLog(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(102, bp.cookie, bp.log);
    }

    protected synchronized void setBreakpointName(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(103, bp.name, bp.cookie);
    }

    protected synchronized void setBreakpointPassCount(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(106, bp.cookie, bp.passCount);
    }

    protected synchronized void setBreakpointThread(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(99, bp.threadname, bp.cookie);
    }

    protected synchronized void setBreakpointThreadNot(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(108, bp.threadnameNot, bp.cookie);
    }

    protected synchronized void setBreakpointCondition(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(107, bp.cookie, bp.condition != null);
    }

    protected synchronized void setBreakpointEnableOtherBPs(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(104, bp.enableOtherBPs, bp.cookie);
    }

    protected synchronized void setBreakpointDisableOtherBPs(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        this.transport.sendMessage(105, bp.disableOtherBPs, bp.cookie);
    }

    @Override
    public DebugThreadInfo[][] getDeadlockedThreads() {
        return DebugShared.getDeadlockedThreads(this);
    }

    @Override
    public DebugThreadGroupInfo[] listTopThreadGroups() {
        return this.listAllThreadGroups();
    }

    @Override
    public DebugThreadGroupInfo[] listAllThreadGroups() {
        return new DebugThreadGroupInfo[]{this.threadGroup};
    }

    @Override
    public boolean canPutBreakpointPackageFileLine() {
        return true;
    }

    @Override
    public boolean canPutBreakpointFileLine() {
        return true;
    }

    @Override
    public boolean canPutBreakpointMethodBytecode() {
        return false;
    }

    @Override
    public boolean canPutBreakpointMethod() {
        return false;
    }

    @Override
    public boolean canPutBreakpointClass() {
        return false;
    }

    @Override
    public boolean canPutBreakpointException() {
        return false;
    }

    @Override
    public boolean canPutBreakpointClassLoad() {
        return false;
    }

    @Override
    public boolean canPutBreakpointAllocationThreshold() {
        return false;
    }

    @Override
    public boolean canPutBreakpointAllocationClass() {
        return false;
    }

    @Override
    public boolean canPutBreakpointDeadlock() {
        return false;
    }

    @Override
    public boolean canPutBreakpointWatchpoint() {
        return false;
    }

    @Override
    public boolean canSetDebuggablePackages() {
        return false;
    }

    @Override
    public boolean canPauseProgram() {
        return true;
    }

    @Override
    public boolean canRedefineClasses() {
        return false;
    }

    @Override
    public boolean canCountObjectsOfClass() {
        return false;
    }

    @Override
    public boolean canCountMemoryOfClass() {
        return false;
    }

    @Override
    public boolean canSetDebuggableClass() {
        return false;
    }

    @Override
    public boolean canGetHeap() {
        return false;
    }

    @Override
    public boolean canDoGarbageCollection() {
        return false;
    }

    @Override
    public boolean canDoCodeCoverage() {
        return false;
    }

    @Override
    public boolean canDisassembleMethod() {
        return false;
    }

    @Override
    public boolean canGetBytecodes() {
        return false;
    }

    @Override
    public boolean canInvokeMethod() {
        return false;
    }

    @Override
    public boolean canGetMonitors() {
        return false;
    }

    @Override
    public boolean canGetMonitorEntryLocation() {
        return false;
    }

    @Override
    public boolean canListSlots() {
        return false;
    }

    @Override
    public boolean canPopFrames() {
        return false;
    }

    @Override
    public boolean canSuspendThread() {
        return false;
    }

    @Override
    public boolean canResumeThread() {
        return false;
    }

    @Override
    public boolean canInterruptThread() {
        return false;
    }

    @Override
    public boolean canDebuggerStopThread() {
        return false;
    }

    @Override
    public boolean canListRegisters() {
        return false;
    }

    @Override
    public boolean canListFloatRegisters() {
        return false;
    }

    @Override
    public boolean canStepToEndOfMethod() {
        return false;
    }

    @Override
    public boolean canStepIntoMethod() {
        return false;
    }

    @Override
    public boolean canContinueStep() {
        return false;
    }

    @Override
    public boolean canGetReturnValue() {
        return false;
    }

    @Override
    public boolean canGetReturnedValue() {
        return false;
    }

    @Override
    public boolean canSetLocation() {
        return false;
    }

    @Override
    public boolean canPin() {
        return false;
    }

    @Override
    public boolean canGetAddresses() {
        return false;
    }

    @Override
    public boolean canGetUniqueIDs() {
        return false;
    }

    protected synchronized String getValue(DebugAntDataInfo data) {
        if (this.properties.isEmpty()) {
            this.listLocals();
        }
        return (String)this.properties.get(data.getName());
    }

    protected synchronized boolean modifyString(DebugAntDataInfo data, String newValue) {
        this.throwIfRunning();
        this.transport.sendMessage(191, data.getName(), newValue);
        this.properties.put(data.getName(), newValue);
        return true;
    }

    protected void stepInto(DebugAntThreadInfo thread) {
        this.doRunCommand(65, thread);
    }

    protected void stepOver(DebugAntThreadInfo thread) {
        this.doRunCommand(66, thread);
    }

    protected void stepOut(DebugAntThreadInfo thread) {
        this.doRunCommand(69, thread);
    }

    private void connectionLost() {
        if (this.debugListener != null) {
            this.debugListener.connectionLost();
        }
        this.breakpoints.clear();
    }

    private void throwIfRunning() {
        if (this.runningThread != null) {
            throw new IllegalStateException(DebugAntArb.getString(1));
        }
    }

    private DebugAntBreakpoint findBreakpoint(int cookie) {
        if (cookie != 0) {
            return (DebugAntBreakpoint)this.breakpoints.get(cookie);
        }
        return null;
    }

    protected synchronized int getStackFrameCount(DebugAntThreadInfo thread) {
        this.throwIfRunning();
        this.transport.sendMessage(175, thread.id);
        return this.transport.receiveInteger();
    }

    protected synchronized DebugAntStackFrameInfo getStackFrame(DebugAntThreadInfo thread, int frame) {
        this.throwIfRunning();
        this.transport.sendMessage(165, thread.id, frame);
        int message = this.transport.receiveMessage();
        return message == 1 ? this.receiveStackFrame(thread, frame) : null;
    }

    protected synchronized DebugAntVariableInfo[] listLocals() {
        if (this.isRunning()) {
            return this.variables;
        }
        this.transport.sendMessage(177);
        return this.receiveVariableInfos();
    }

    protected synchronized DebugAntStackFrameInfo[] listStack(DebugAntThreadInfo thread) {
        this.throwIfRunning();
        this.transport.sendMessage(166, thread.id);
        int message = this.transport.receiveMessage();
        return message == 1 ? this.receiveStack(thread) : null;
    }

    private synchronized DebugAntStackFrameInfo receiveStackFrame(DebugAntThreadInfo thread, int frame) {
        DebugLocation location = this.receiveLocation();
        return new DebugAntStackFrameInfo(this, thread, frame, location);
    }

    private synchronized DebugAntStackFrameInfo[] receiveStack(DebugAntThreadInfo thread) {
        int size = this.transport.receiveInteger();
        DebugAntStackFrameInfo[] stack = new DebugAntStackFrameInfo[size];
        int i = 0;
        while (i < size) {
            stack[i] = this.receiveStackFrame(thread, i);
            ++i;
        }
        return stack;
    }

    private synchronized DebugAntVariableInfo[] receiveVariableInfos() {
        this.properties.clear();
        String className = DebugAntArb.getString(4);
        DebugAntClassInfo clazz = new DebugAntClassInfo(this, null, className, true);
        int size = this.transport.receiveInteger();
        DebugAntVariableInfo[] infos = new DebugAntVariableInfo[size];
        int i = 0;
        while (i < size) {
            String name = this.transport.receiveString();
            String value = this.transport.receiveString();
            this.properties.put(name, value);
            DebugAntDataInfo data = new DebugAntDataInfo(this, clazz, name);
            infos[i] = new DebugAntVariableInfo(this, clazz, name, data);
            ++i;
        }
        return infos;
    }

    private void putBreakpoint(DebugAntBreakpoint bp) {
        this.throwIfRunning();
        if (bp instanceof DebugAntBreakpointFileLine) {
            DebugAntBreakpointFileLine bpfl = (DebugAntBreakpointFileLine)bp;
            this.transport.sendMessage(80, bpfl.getFilename(), bpfl.getLine());
        }
        bp.cookie = this.transport.receiveInteger();
        this.breakpoints.put(bp.cookie, (Object)bp);
    }

    private synchronized boolean checkDisconnect() {
        if (this.disconnectRequested) {
            boolean terminate = this.terminateRequested;
            this.disconnect(terminate);
            return true;
        }
        return false;
    }

    private synchronized DebugAntThreadInfo[] receiveThreads() {
        int count = this.transport.receiveInteger();
        DebugAntThreadInfo[] infos = new DebugAntThreadInfo[count];
        int i = 0;
        while (i < count) {
            infos[i] = this.receiveThread();
            ++i;
        }
        return infos;
    }

    private synchronized DebugAntThreadInfo receiveThread() {
        int id = this.transport.receiveInteger();
        String name = this.transport.receiveString();
        DebugAntThreadInfo info = (DebugAntThreadInfo)this.threads.get(id);
        if (info == null) {
            info = new DebugAntThreadInfo(this, id, name);
            this.threads.put(id, (Object)info);
        }
        return info;
    }

    private synchronized DebugLocation receiveLocation() {
        String filename = this.transport.receiveString();
        int line = this.transport.receiveInteger();
        String target = this.transport.receiveString();
        File file = new File(filename);
        DebugAntClassInfo classInfo = new DebugAntClassInfo(this, file.getName(), file.getName(), false);
        return new DebugSharedLocation(new DebugAntMethodInfo(this, target, classInfo), 0L, 0, false, file.getPath(), filename, line, true);
    }

    private void incrementStoppedCount() {
        this.properties.clear();
        ++this.stoppedCount;
    }

    @Override
    public boolean canStopOnException() {
        return false;
    }

    @Override
    public boolean canStopOnError() {
        return false;
    }

    @Override
    public boolean canStopOnDebuggerStatement() {
        return false;
    }

    @Override
    public boolean canTransferErrors() {
        return false;
    }

    @Override
    public boolean getStopOnException() {
        return false;
    }

    @Override
    public boolean getStopOnError() {
        return false;
    }

    @Override
    public boolean getStopOnDebuggerStatement() {
        return false;
    }

    @Override
    public boolean getTransferErrors() {
        return false;
    }

    @Override
    public void setStopOnException(boolean b) {
    }

    @Override
    public void setStopOnError(boolean b) {
    }

    @Override
    public void setStopOnDebuggerStatement(boolean b) {
    }

    @Override
    public void setTransferErrors(boolean b) {
    }

    @Override
    public void setCurrentStackFrame(DebugStackFrameInfo sfInfo) {
        this.currentStackFrame = sfInfo;
    }

    @Override
    public DebugStackFrameInfo getCurrentStackFrame() {
        return this.currentStackFrame;
    }

    @Override
    public boolean canStopInChrome() {
        return false;
    }

    @Override
    public boolean getStopInChrome() {
        return false;
    }

    @Override
    public void setStopInChrome(boolean b) {
    }

    @Override
    public Object newObject(String typeName, List<Object> parameters) throws Exception {
        throw new Exception("Unable to evaluate source expression: new object");
    }

    @Override
    public void cacheUserFoundURL(String lookedFor, URL foundUrl) {
        if (this.userUrlCacher == null) {
            this.userUrlCacher = new UserSelectedURLCacher();
        }
        this.userUrlCacher.addCachedURL(lookedFor, foundUrl);
    }

    @Override
    public URL getChachedUserFoundLocation(String lookingFor) {
        if (this.userUrlCacher == null) {
            return null;
        }
        return this.userUrlCacher.getCachedUrl(lookingFor);
    }

    static DebugAntTransport ra$transport(DebugAnt debugAnt) {
        return debugAnt.transport;
    }

    static void mav$notifiedBreakpointLog(DebugAnt debugAnt) {
        debugAnt.notifiedBreakpointLog();
    }

    static void wa$stopped(DebugAnt debugAnt, boolean bl) {
        debugAnt.stopped = bl;
    }

    static void wa$terminated(DebugAnt debugAnt, boolean bl) {
        debugAnt.terminated = bl;
    }

    static DebugListener ra$debugListener(DebugAnt debugAnt) {
        return debugAnt.debugListener;
    }

    static boolean ra$pauseRequested(DebugAnt debugAnt) {
        return debugAnt.pauseRequested;
    }

    static boolean ra$disconnectRequested(DebugAnt debugAnt) {
        return debugAnt.disconnectRequested;
    }

    static void wa$pauseRequested(DebugAnt debugAnt, boolean bl) {
        debugAnt.pauseRequested = bl;
    }

    static void mav$notifiedBreakpointCondition(DebugAnt debugAnt) {
        debugAnt.notifiedBreakpointCondition();
    }

    static void mav$notifiedBreakpointEnabled(DebugAnt debugAnt) {
        debugAnt.notifiedBreakpointEnabled();
    }

    static boolean ra$stopped(DebugAnt debugAnt) {
        return debugAnt.stopped;
    }

    static boolean ra$terminated(DebugAnt debugAnt) {
        return debugAnt.terminated;
    }

    static void wa$runningThread(DebugAnt debugAnt, Thread thread) {
        debugAnt.runningThread = thread;
    }

    static void mav$incrementStoppedCount(DebugAnt debugAnt) {
        debugAnt.incrementStoppedCount();
    }

    static boolean mav$checkDisconnect(DebugAnt debugAnt) {
        return debugAnt.checkDisconnect();
    }

    static boolean ra$terminateRequested(DebugAnt debugAnt) {
        return debugAnt.terminateRequested;
    }

    static void mav$connectionLost(DebugAnt debugAnt) {
        debugAnt.connectionLost();
    }

    private class RunThread
    extends Thread {
        private int command;
        private DebugAntThreadInfo thread;

        public RunThread(int command, DebugAntThreadInfo thread) {
            super("Ant Event Processor");
            this.command = command;
            this.thread = thread;
        }

        public void run() {
            if (this.thread != null) {
                DebugAnt.ra$transport(DebugAnt.this).sendMessage(this.command, this.thread.id);
            } else {
                DebugAnt.ra$transport(DebugAnt.this).sendMessage(this.command);
            }
            do {
                int message = DebugAnt.ra$transport(DebugAnt.this).receiveMessage();
                switch (message) {
                    case 246: {
                        DebugAnt.mav$notifiedBreakpointLog(DebugAnt.this);
                        break;
                    }
                    case 240: {
                        DebugAnt.wa$stopped(DebugAnt.this, true);
                        break;
                    }
                    case 241: {
                        DebugAnt.wa$terminated(DebugAnt.this, true);
                        if (DebugAnt.ra$debugListener(DebugAnt.this) != null) {
                            DebugAnt.ra$debugListener(DebugAnt.this).programTerminating();
                        }
                        DebugAnt.ra$transport(DebugAnt.this).sendMessage(1);
                        break;
                    }
                    case 242: {
                        boolean shouldPause = DebugAnt.ra$pauseRequested(DebugAnt.this);
                        if (!shouldPause) {
                            shouldPause = DebugAnt.ra$disconnectRequested(DebugAnt.this);
                        }
                        DebugAnt.wa$pauseRequested(DebugAnt.this, false);
                        DebugAnt.ra$transport(DebugAnt.this).sendBoolean(shouldPause);
                        DebugAnt.ra$transport(DebugAnt.this).flush();
                        break;
                    }
                    case 251: {
                        DebugAnt.mav$notifiedBreakpointCondition(DebugAnt.this);
                        break;
                    }
                    case 255: {
                        DebugAnt.mav$notifiedBreakpointEnabled(DebugAnt.this);
                        break;
                    }
                }
            } while (DebugAnt.this.isConnected() && !DebugAnt.ra$stopped(DebugAnt.this) && !DebugAnt.ra$terminated(DebugAnt.this));
            DebugAnt.wa$runningThread(DebugAnt.this, null);
            DebugAnt.mav$incrementStoppedCount(DebugAnt.this);
            if (DebugAnt.mav$checkDisconnect(DebugAnt.this)) {
                if (DebugAnt.ra$terminateRequested(DebugAnt.this) && DebugAnt.ra$debugListener(DebugAnt.this) != null) {
                    DebugAnt.ra$debugListener(DebugAnt.this).programTerminated();
                }
            } else if (DebugAnt.ra$terminated(DebugAnt.this)) {
                if (DebugAnt.ra$debugListener(DebugAnt.this) != null) {
                    DebugAnt.ra$debugListener(DebugAnt.this).programTerminated();
                }
                DebugAnt.this.disconnect(false);
            } else if (DebugAnt.ra$stopped(DebugAnt.this)) {
                if (DebugAnt.ra$debugListener(DebugAnt.this) != null) {
                    DebugAnt.ra$debugListener(DebugAnt.this).programStopped();
                }
            } else {
                DebugAnt.mav$connectionLost(DebugAnt.this);
            }
        }
    }
}

