/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ant;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import oracle.jdevimpl.debugger.ant.DebugAnt;
import oracle.jdevimpl.debugger.ant.DebugAntArb;
import oracle.jdevimpl.debugger.ant.DebugAntConnectArg;
import oracle.jdevimpl.debugger.ant.DebugAntTransport;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class DebugAntConnector
implements DebugConnector {
    public static String getVersion() {
        return "1.6.5";
    }

    public DebugConnectArg[] getConnectArgs() {
        DebugConnectArg[] args = new DebugAntConnectArg[]{new DebugAntConnectArg("hostname", DebugAntArb.getString(3), true), new DebugAntConnectArg("port", DebugAntArb.getString(0), false), new DebugAntConnectArg("timeout", DebugAntArb.getString(2), true)};
        return args;
    }

    public DebugVirtualMachine connect(DebugConnectArg[] connectArgs) throws Exception {
        int timeout;
        String host = connectArgs[0].getValue();
        int port = Integer.parseInt(connectArgs[1].getValue());
        try {
            timeout = Integer.parseInt(connectArgs[2].getValue()) * 1000;
        }
        catch (NumberFormatException nfe) {
            timeout = 0;
        }
        Socket socket = new Socket();
        InetAddress address = InetAddress.getByName(host);
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        socket.connect(socketAddress, timeout);
        socket.setTcpNoDelay(true);
        DebugAntTransport transport = new DebugAntTransport(socket, true);
        return new DebugAnt(transport);
    }

    public synchronized void startListening(DebugConnectArg[] connectArgs, DebugConnectionListener connectionListener) throws Exception {
        throw new UnsupportedOperationException("Listening not supported.");
    }

    public synchronized void stopListening() {
        throw new UnsupportedOperationException("Listening not supported.");
    }
}

