/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class DebugAntTransport {
    private Socket socket;
    private boolean isDebugger;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private Object inputLock;
    private Object outputLock;
    private static final int HANDSHAKE_TIMEOUT = 3000;
    private static final String HANDSHAKE = "JDEV-ANT-DEBUGGER";

    private void $init$() {
        this.inputLock = new Object();
        this.outputLock = new Object();
    }

    public DebugAntTransport(Socket socket, boolean isDebugger) throws IOException {
        this.$init$();
        this.socket = socket;
        this.isDebugger = isDebugger;
        this.doHandshake();
        socket.setTcpNoDelay(true);
        this.inputStream = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.outputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public boolean isConnected() {
        return this.inputStream != null && this.outputStream != null;
    }

    public void disconnect() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.inputStream = null;
        this.outputStream = null;
        this.socket = null;
    }

    public void sendMessage(int message) {
        try {
            this.outputStream.writeByte(message);
            this.flush();
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.disconnect();
        }
    }

    public int receiveMessage() {
        int m = 0;
        try {
            m = this.inputStream.readUnsignedByte();
        }
        catch (IOException e) {
            this.disconnect();
        }
        return m;
    }

    public boolean receiveBoolean() {
        boolean b = false;
        try {
            b = this.inputStream.readBoolean();
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return b;
    }

    public int receiveInteger() {
        int i = 0;
        try {
            i = this.inputStream.readInt();
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return i;
    }

    public String receiveString() {
        String s = "";
        try {
            int length = this.inputStream.readInt();
            if (length > 0) {
                byte[] b = new byte[length];
                this.inputStream.readFully(b);
                s = new String(b, "UTF-8");
            }
        }
        catch (IOException ioe) {
            this.disconnect();
        }
        return s;
    }

    public void sendMessage(int message, int i) {
        this.sendMessage(message);
        this.sendInteger(i);
        this.flush();
    }

    public void sendMessage(int message, boolean b) {
        this.sendMessage(message);
        this.sendBoolean(b);
        this.flush();
    }

    public void sendMessage(int message, int i, boolean b) {
        this.sendMessage(message);
        this.sendInteger(i);
        this.sendBoolean(b);
        this.flush();
    }

    public void sendMessage(int message, String s) {
        this.sendMessage(message);
        this.sendString(s);
        this.flush();
    }

    public void sendMessage(int message, String s1, String s2) {
        this.sendMessage(message);
        this.sendString(s1);
        this.sendString(s2);
        this.flush();
    }

    public void sendMessage(int message, int i1, int i2) {
        this.sendMessage(message);
        this.sendInteger(i1);
        this.sendInteger(i2);
        this.flush();
    }

    public void sendMessage(int message, String s, int i) {
        this.sendMessage(message);
        this.sendString(s);
        this.sendInteger(i);
        this.flush();
    }

    public void sendMessage(int message, String s, int i1, int i2) {
        this.sendMessage(message);
        this.sendString(s);
        this.sendInteger(i1);
        this.sendInteger(i2);
        this.flush();
    }

    public void sendBoolean(boolean b) {
        try {
            this.outputStream.writeBoolean(b);
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void sendInteger(int i) {
        try {
            this.outputStream.writeInt(i);
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    public void sendString(String s) {
        try {
            if (s != null) {
                byte[] b = s.getBytes("UTF-8");
                this.outputStream.writeInt(b.length);
                this.outputStream.write(b);
            } else {
                this.outputStream.writeInt(0);
            }
        }
        catch (IOException ioe) {
            this.disconnect();
        }
    }

    private void doHandshake() throws IOException {
        this.socket.setSoTimeout(3000);
        byte[] handshake = HANDSHAKE.getBytes("UTF-8");
        if (this.isDebugger) {
            this.socket.getOutputStream().write(handshake);
        }
        int len = handshake.length;
        byte[] b = new byte[len];
        int read = 0;
        InputStream inputStream = this.socket.getInputStream();
        while (read < len) {
            int n = inputStream.read(b, read, len - read);
            if (n < 0) {
                this.socket.close();
                throw new IOException("Handshake failed.");
            }
            read += n;
        }
        int i = 0;
        while (i < len) {
            if (b[i] != handshake[i]) {
                throw new IOException("Handshake failed.");
            }
            ++i;
        }
        if (!this.isDebugger) {
            this.socket.getOutputStream().write(handshake);
        }
        this.socket.setSoTimeout(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(byte[] packet) throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Transport not connected.");
        }
        Object object = this.outputLock;
        synchronized (object) {
            this.outputStream.write(packet);
            this.outputStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] receivePacket() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("Transport not connected.");
        }
        Object object = this.inputLock;
        synchronized (object) {
            byte[] b = new byte[4];
            int i = this.inputStream.read();
            if (i < 0) {
                this.disconnect();
                byte[] byArray = null;
                return byArray;
            }
            b[0] = (byte)i;
            this.inputStream.read(b, 1, 3);
            int len = this.getInt(b, 0);
            byte[] packet = new byte[len];
            System.arraycopy(b, 0, packet, 0, 4);
            int read = 0;
            i = 4;
            while (i < len) {
                read = this.inputStream.read(packet, i, len - i);
                if (read < 0) {
                    throw new IOException("Incomplete packet.");
                }
                i += read;
            }
            byte[] byArray = packet;
            return byArray;
        }
    }

    public int getMessage(byte[] b) {
        return this.getMessage(b, 4);
    }

    public int getMessage(byte[] b, int offset) {
        return (b[offset] << 8) + (b[offset + 1] << 0);
    }

    public void putMessage(byte[] b, int offset, int message) {
        b[offset] = (byte)(message >>> 8 & 0xFF);
        b[offset + 1] = (byte)(message >>> 0 & 0xFF);
    }

    public int getInt(byte[] b, int offset) {
        return (b[offset] << 24) + (b[offset + 1] << 16) + (b[offset + 2] << 8) + (b[offset + 3] << 0);
    }

    public void putInt(byte[] b, int offset, int value) {
        b[offset] = (byte)(value >>> 24 & 0xFF);
        b[offset + 1] = (byte)(value >>> 16 & 0xFF);
        b[offset + 2] = (byte)(value >>> 8 & 0xFF);
        b[offset + 3] = (byte)(value >>> 0 & 0xFF);
    }

    public String getString(byte[] b, int offset) {
        int len = this.getInt(b, offset);
        return new String(b, offset + 4, len);
    }
}

