/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ant;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdevimpl.ant.runner.AntLocation;
import oracle.jdevimpl.debugger.ant.DebugAntTransport;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class DebugBuildListener
implements BuildListener {
    private boolean suspended;
    private Object suspendLock;
    private int breakpoint;
    private DebugAntTransport transport;
    private HashMap breakpoints;
    private HashMap locations;
    private HashMap names;
    private HashMap threads;
    private HashMap ids;
    private int threadCount;
    private int breakpointCount;
    private int buildCount;
    private static Pattern sequencePattern;
    private static Method getTargetLocation;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.suspendLock = new Object();
        this.breakpoints = new HashMap();
        this.locations = new HashMap();
        this.names = new HashMap();
        this.threads = new HashMap();
        this.ids = new HashMap();
        this.threadCount = 1;
        this.breakpointCount = 1;
    }

    static {
        $assertionsDisabled = DebugBuildListener.class.desiredAssertionStatus() ^ true;
        sequencePattern = Pattern.compile("Build sequence for target(?:\\(s\\))? `(?:.*)' is \\[(.*)\\]");
        try {
            getTargetLocation = Target.class.getMethod("getLocation", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.setCurrentProject(buildEvent.getProject());
        if (this.buildCount++ == 0) {
            try {
                this.connect();
                this.suspend();
            }
            catch (IOException ioe) {
                buildEvent.setException((Throwable)ioe);
            }
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        if (--this.buildCount == 0) {
            this.transport.sendMessage(241);
            this.transport.receiveMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetStarted(BuildEvent buildEvent) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkSuspended();
            this.setCurrentProject(buildEvent.getProject());
            this.updateThreads();
            Target target = buildEvent.getTarget();
            if (target != null) {
                this.popImplicitTarget();
                this.pushDependencyTargets(target);
                AntLocation location = this.getTargetLocation(target);
                this.push(target, location);
                boolean stepFinished = this.checkIfStepFinished(location);
                if (!this.checkForBreakpoint(location) && !this.checkPaused() && stepFinished) {
                    this.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void targetFinished(BuildEvent buildEvent) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkSuspended();
            this.updateThreads();
            Target target = buildEvent.getTarget();
            if (target != null) {
                this.pop(target);
                this.popDependencyTargets();
            }
            this.checkPaused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskStarted(BuildEvent buildEvent) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkSuspended();
            this.setCurrentProject(buildEvent.getProject());
            this.updateThreads();
            Task task = buildEvent.getTask();
            if (task != null) {
                Target target = this.getOwningTarget(task);
                if (target == null) {
                    this.pushImplicitTarget();
                }
                AntLocation location = new AntLocation(task.getLocation());
                this.updateLocation(target, location);
                boolean stepFinished = this.checkIfStepFinished(location);
                if (!this.checkForBreakpoint(location) && !this.checkPaused() && stepFinished) {
                    this.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskFinished(BuildEvent buildEvent) {
        Object object = this.suspendLock;
        synchronized (object) {
            this.checkSuspended();
            this.setCurrentProject(buildEvent.getProject());
            this.updateThreads();
            this.checkPaused();
        }
    }

    public void messageLogged(BuildEvent buildEvent) {
        Matcher matcher = sequencePattern.matcher(buildEvent.getMessage());
        if (matcher.matches()) {
            ThreadInfo info = this.getCurrentThreadInfo();
            String[] targets = matcher.group(1).split(", ");
            info.setTargetOrder(targets);
        }
    }

    private Target getOwningTarget(Task task) {
        Target target = task.getOwningTarget();
        if (target != null && target.getName().length() == 0) {
            target = null;
        }
        return target;
    }

    private void push(Target target, AntLocation location) {
        this.push(target, location, false);
    }

    private void push(Target target, AntLocation location, boolean dependency) {
        StackFrame frame;
        Stack stack = this.getCurrentStack();
        if (!stack.isEmpty() && (frame = (StackFrame)stack.peek()).getTarget() == target) {
            frame.setLocation(location);
            return;
        }
        stack.push(new StackFrame(target, location, dependency));
    }

    private boolean checkLocation(AntLocation location) {
        return location != null && location != AntLocation.UNKNOWN_LOCATION && location.getFileName() != null && location.getFileName().length() != 0;
    }

    private void updateLocation(Target target, AntLocation location) {
        if (this.checkLocation(location)) {
            Stack stack = this.getCurrentStack();
            if (!$assertionsDisabled && stack.isEmpty()) {
                throw new AssertionError((Object)"Stack is empty.");
            }
            StackFrame frame = (StackFrame)stack.peek();
            if (!$assertionsDisabled && frame.getTarget() != target) {
                throw new AssertionError((Object)"Stack frame mismatch.");
            }
            frame.setLocation(location);
        }
    }

    private void pushImplicitTarget() {
        StackFrame frame;
        Stack stack = this.getCurrentStack();
        if (!stack.isEmpty() && (frame = (StackFrame)stack.peek()).getTarget() == null) {
            return;
        }
        stack.push(new StackFrame(null, AntLocation.UNKNOWN_LOCATION, false));
    }

    private void popImplicitTarget() {
        StackFrame frame;
        Stack stack = this.getCurrentStack();
        if (!stack.isEmpty() && (frame = (StackFrame)stack.peek()).getTarget() == null) {
            stack.pop();
            this.stepFinished(frame);
        }
    }

    private void pop(Target target) {
        Stack stack = this.getCurrentStack();
        if (!stack.isEmpty()) {
            StackFrame frame = (StackFrame)stack.pop();
            if (!$assertionsDisabled && frame.getTarget() != target) {
                throw new AssertionError((Object)"Stack frame mismatch.");
            }
            this.stepFinished(frame);
        }
    }

    private void stepFinished(StackFrame frame) {
        ThreadInfo info = this.getCurrentThreadInfo();
        if (info.isStepping() && info.getStepFrame() == frame) {
            info.setStepFinished(true);
        }
    }

    private void pushDependencyTargets(Target target) {
        Stack<Target> dependencies = new Stack<Target>();
        Project project = this.getCurrentProject();
        Hashtable targets = project.getTargets();
        String[] targetOrder = this.getCurrentThreadInfo().getTargetOrder();
        Target child = null;
        int i = 0;
        while (i < targetOrder.length) {
            Target current = (Target)targets.get(targetOrder[i]);
            if (child != null) {
                if (this.dependsOn(current, child)) {
                    dependencies.push(current);
                    child = current;
                }
            } else if (target == current) {
                child = target;
            }
            ++i;
        }
        while (!dependencies.isEmpty()) {
            Target current = (Target)dependencies.pop();
            AntLocation location = this.getTargetLocation(current);
            if (location == AntLocation.UNKNOWN_LOCATION) continue;
            this.push(current, this.getTargetLocation(current), true);
        }
    }

    private void popDependencyTargets() {
        Stack stack = this.getCurrentStack();
        while (!stack.isEmpty()) {
            StackFrame frame = (StackFrame)stack.peek();
            if (!frame.isDependency()) break;
            stack.pop();
        }
    }

    private void updateThreads() {
        ArrayList deadThreads = new ArrayList();
        Set keys = this.threads.keySet();
        Iterator<Object> iterator = keys.iterator();
        Thread current = Thread.currentThread();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            ThreadInfo info = (ThreadInfo)this.threads.get(key);
            Thread thread = info.getThread();
            if (thread == current || thread.isAlive()) continue;
            deadThreads.add(key);
        }
        for (Object key : deadThreads) {
            this.threads.remove(key);
        }
    }

    private void connect() throws IOException {
        int port = Integer.getInteger("jdev.ant.debug.port", 4000);
        ServerSocket ss = new ServerSocket(port);
        Socket socket = ss.accept();
        this.transport = new DebugAntTransport(socket, false);
    }

    private boolean isConnected() {
        return this.transport.isConnected();
    }

    private void stop() {
        this.transport.sendMessage(240);
        this.suspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspend() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (!this.suspended) {
                this.suspended = true;
                this.processMessages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        Object object = this.suspendLock;
        synchronized (object) {
            if (this.suspended) {
                this.suspended = false;
                this.suspendLock.notifyAll();
            }
        }
        this.breakpoint = 0;
    }

    private boolean checkPaused() {
        this.transport.sendMessage(242);
        boolean paused = this.transport.receiveBoolean();
        if (paused) {
            this.transport.sendMessage(240);
            this.suspend();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSuspended() {
        boolean wasSuspended;
        Object object = this.suspendLock;
        synchronized (object) {
            wasSuspended = this.suspended;
            while (this.suspended) {
                try {
                    this.suspendLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return wasSuspended;
    }

    private boolean checkIfStepFinished(AntLocation location) {
        ThreadInfo info;
        if (this.checkLocation(location) && (info = this.getCurrentThreadInfo()).isStepping()) {
            if (info.getStepCommand() == 66) {
                StackFrame frame = (StackFrame)info.getStack().peek();
                if (info.getStepFrame() == frame) {
                    info.setStepFinished(true);
                }
            } else if (info.getStepCommand() == 65) {
                info.setStepFinished(true);
            }
            if (info.isStepFinished()) {
                info.setStepping(false);
                info.setStepCommand(0);
                return true;
            }
        }
        return false;
    }

    private boolean checkForBreakpoint(AntLocation location) {
        BreakPointLocation bpl;
        BreakPoint breakpoint;
        if (this.checkLocation(location) && (breakpoint = (BreakPoint)this.locations.get(bpl = new BreakPointLocation(location))) != null && breakpoint.isEnabled()) {
            this.breakpoint = breakpoint.getCookie();
            String currentThread = Thread.currentThread().getName();
            String threadname = breakpoint.getThreadname();
            String threadnameNot = breakpoint.getThreadnameNot();
            if (!(threadname != null && !currentThread.equals(threadname) || threadnameNot != null && currentThread.equals(threadnameNot) || breakpoint.getCondition() && !this.checkCondition(breakpoint))) {
                int passed = breakpoint.getPassed() + 1;
                breakpoint.setPassed(passed);
                int passCount = breakpoint.getPassCount();
                if (passCount == 0 || passed % passCount == 0) {
                    if (breakpoint.isLog()) {
                        this.transport.sendMessage(246);
                        this.transport.sendInteger(breakpoint.getCookie());
                        this.sendCurrentThread();
                        this.sendCurrentStack();
                        this.transport.flush();
                    }
                    this.enableOtherBreakpoints(true, breakpoint.getEnableOtherBPs());
                    this.enableOtherBreakpoints(false, breakpoint.getDisableOtherBPs());
                    if (breakpoint.isStop()) {
                        this.transport.sendMessage(240);
                        this.suspend();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkCondition(BreakPoint breakpoint) {
        this.transport.sendMessage(251, BreakPoint.ra$cookie(breakpoint));
        this.sendCurrentThread();
        this.sendCurrentStack();
        this.sendProperties();
        this.transport.flush();
        int message = this.transport.receiveMessage();
        return message == 1;
    }

    private void enableOtherBreakpoints(boolean enabled, String name) {
        List list;
        if (name != null && (list = (List)this.names.get(name)) != null) {
            for (BreakPoint other : list) {
                other.setEnabled(enabled);
                this.transport.sendMessage(255, BreakPoint.ra$cookie(other), enabled);
            }
        }
    }

    public void processMessages() {
        block27: do {
            int message = this.transport.receiveMessage();
            switch (message) {
                case 64: 
                case 72: {
                    this.resume();
                    break;
                }
                case 65: 
                case 66: 
                case 69: {
                    int id = this.transport.receiveInteger();
                    ThreadInfo info = (ThreadInfo)this.ids.get(new Integer(id));
                    if (info != null) {
                        info.setStepping(true);
                        info.setStepCommand(message);
                    }
                    this.resume();
                    break;
                }
                case 71: {
                    this.transport.sendBoolean(this.getCurrentThreadInfo().isStepping() ^ true);
                    this.transport.flush();
                    break;
                }
                case 40: {
                    this.sendCurrentThread();
                    this.transport.flush();
                    break;
                }
                case 39: {
                    this.transport.sendInteger(this.breakpoint);
                    this.transport.flush();
                    break;
                }
                case 175: {
                    int id = this.transport.receiveInteger();
                    ThreadInfo info = (ThreadInfo)this.ids.get(new Integer(id));
                    int count = 0;
                    if (info != null) {
                        count = info.getStack().size();
                    }
                    this.transport.sendInteger(count);
                    this.transport.flush();
                    break;
                }
                case 165: {
                    Stack stack;
                    int id = this.transport.receiveInteger();
                    int frame = this.transport.receiveInteger();
                    ThreadInfo info = (ThreadInfo)this.ids.get(new Integer(id));
                    boolean ok = false;
                    if (info != null && frame < (stack = info.getStack()).size()) {
                        this.transport.sendMessage(1);
                        this.sendStackFrame((StackFrame)stack.get(frame));
                        ok = true;
                    }
                    if (!ok) {
                        this.transport.sendMessage(2);
                    }
                    this.transport.flush();
                    break;
                }
                case 166: {
                    int id = this.transport.receiveInteger();
                    ThreadInfo info = (ThreadInfo)this.ids.get(new Integer(id));
                    if (info != null) {
                        this.transport.sendMessage(1);
                        this.sendStack(info.getStack());
                    } else {
                        this.transport.sendMessage(2);
                    }
                    this.transport.flush();
                    break;
                }
                case 160: {
                    this.sendThreads();
                    this.transport.flush();
                    break;
                }
                case 97: {
                    List list;
                    int cookie = this.transport.receiveInteger();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.remove(new Integer(cookie));
                    if (breakpoint == null) break;
                    this.locations.remove(breakpoint.getLocation());
                    String name = breakpoint.getName();
                    if (name == null || (list = (List)this.names.get(name)) == null) continue block27;
                    list.remove(breakpoint);
                    if (!list.isEmpty()) break;
                    this.names.remove(name);
                    break;
                }
                case 98: {
                    this.breakpoints.clear();
                    this.locations.clear();
                    this.names.clear();
                    this.breakpointCount = 1;
                    break;
                }
                case 80: {
                    int cookie;
                    String filename = this.transport.receiveString();
                    int line = this.transport.receiveInteger();
                    ++this.breakpointCount;
                    BreakPointLocation location = new BreakPointLocation(filename, line);
                    BreakPoint breakpoint = new BreakPoint(location, cookie);
                    this.breakpoints.put(new Integer(cookie), breakpoint);
                    this.locations.put(location, breakpoint);
                    this.transport.sendInteger(cookie);
                    this.transport.flush();
                    break;
                }
                case 100: {
                    int cookie = this.transport.receiveInteger();
                    boolean enabled = this.transport.receiveBoolean();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setEnabled(enabled);
                    break;
                }
                case 102: {
                    int cookie = this.transport.receiveInteger();
                    boolean log = this.transport.receiveBoolean();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setLog(log);
                    break;
                }
                case 101: {
                    int cookie = this.transport.receiveInteger();
                    boolean stop = this.transport.receiveBoolean();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setStop(stop);
                    break;
                }
                case 103: {
                    String name = this.transport.receiveString();
                    int cookie = this.transport.receiveInteger();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setName(name);
                    break;
                }
                case 106: {
                    int cookie = this.transport.receiveInteger();
                    int passCount = this.transport.receiveInteger();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setPassCount(passCount);
                    break;
                }
                case 99: {
                    String thread = this.transport.receiveString();
                    int cookie = this.transport.receiveInteger();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setThreadname(thread);
                    break;
                }
                case 108: {
                    String thread = this.transport.receiveString();
                    int cookie = this.transport.receiveInteger();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setThreadnameNot(thread);
                    break;
                }
                case 107: {
                    int cookie = this.transport.receiveInteger();
                    boolean condition = this.transport.receiveBoolean();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setCondition(condition);
                    break;
                }
                case 104: {
                    String enableOtherBPs = this.transport.receiveString();
                    int cookie = this.transport.receiveInteger();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setEnableOtherBPs(enableOtherBPs);
                    break;
                }
                case 105: {
                    String disableOtherBPs = this.transport.receiveString();
                    int cookie = this.transport.receiveInteger();
                    BreakPoint breakpoint = (BreakPoint)this.breakpoints.get(new Integer(cookie));
                    if (breakpoint == null) break;
                    breakpoint.setDisableOtherBPs(disableOtherBPs);
                    break;
                }
                case 34: {
                    boolean terminate = this.transport.receiveBoolean();
                    if (terminate) {
                        System.exit(0);
                        break;
                    }
                    this.transport.disconnect();
                    throw new BuildException("Program Terminated.");
                }
                case 177: {
                    this.sendProperties();
                    this.transport.flush();
                    break;
                }
                case 191: {
                    String property = this.transport.receiveString();
                    String value = this.transport.receiveString();
                    Project project = this.getCurrentProject();
                    Hashtable userProperties = project.getUserProperties();
                    if (userProperties.containsKey(property)) {
                        project.setUserProperty(property, value);
                        break;
                    }
                    project.setProperty(property, value);
                    break;
                }
            }
        } while (this.isConnected() && this.suspended);
        if (this.suspended) {
            this.resume();
            throw new BuildException();
        }
    }

    private void sendCurrentThread() {
        Thread thread = Thread.currentThread();
        this.sendThread(this.getThreadInfo(thread));
    }

    private void sendThreads() {
        Set keys = this.threads.keySet();
        this.transport.sendInteger(keys.size());
        for (Object key : keys) {
            this.sendThread((ThreadInfo)this.threads.get(key));
        }
    }

    private void sendThread(ThreadInfo info) {
        Thread thread = info.getThread();
        this.transport.sendInteger(info.getId());
        this.transport.sendString(thread.getName());
    }

    private void sendCurrentStack() {
        this.sendStack(Thread.currentThread());
    }

    private void sendStack(Thread thread) {
        ThreadInfo info = this.getThreadInfo(thread);
        Stack stack = info.getStack();
        this.sendStack(stack);
    }

    private void sendStack(Stack stack) {
        int size = stack.size();
        this.transport.sendInteger(size);
        int i = size - 1;
        while (i >= 0) {
            this.sendStackFrame((StackFrame)stack.get(i));
            --i;
        }
    }

    private void sendStackFrame(StackFrame entry) {
        AntLocation location = entry.getLocation();
        this.transport.sendString(location.getFileName());
        this.transport.sendInteger(location.getLineNumber());
        this.transport.sendString(entry.getTargetName());
    }

    private void sendProperties() {
        Project project = this.getCurrentProject();
        Hashtable properties = project.getProperties();
        int size = properties.size();
        this.transport.sendInteger(size);
        this.transport.flush();
        ArrayList keyList = new ArrayList(properties.size());
        keyList.addAll(properties.keySet());
        Collections.sort(keyList);
        for (String key : keyList) {
            String value = (String)properties.get(key);
            this.transport.sendString(key);
            this.transport.sendString(value);
        }
    }

    private Stack getCurrentStack() {
        return this.getCurrentThreadInfo().getStack();
    }

    private Project getCurrentProject() {
        return this.getCurrentThreadInfo().getProject();
    }

    private void setCurrentProject(Project project) {
        this.getCurrentThreadInfo().setProject(project);
    }

    private ThreadInfo getCurrentThreadInfo() {
        return this.getThreadInfo(Thread.currentThread());
    }

    private ThreadInfo getThreadInfo(Thread thread) {
        ThreadInfo info = (ThreadInfo)this.threads.get(thread);
        if (info == null) {
            info = new ThreadInfo(thread, this.threadCount);
            this.threads.put(thread, info);
            this.ids.put(new Integer(this.threadCount++), info);
        }
        return info;
    }

    private AntLocation getTargetLocation(Target target) {
        if (getTargetLocation != null) {
            try {
                AntLocation antLocation = new AntLocation((Location)getTargetLocation.invoke((Object)target, null));
                return antLocation;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return AntLocation.UNKNOWN_LOCATION;
    }

    private boolean dependsOn(Target parent, Target child) {
        String name = child.getName();
        Enumeration e = parent.getDependencies();
        while (e.hasMoreElements()) {
            String current = (String)e.nextElement();
            if (!name.equals(current)) continue;
            return true;
        }
        return false;
    }

    public DebugBuildListener() {
        this.$init$();
    }

    static HashMap ra$names(DebugBuildListener debugBuildListener) {
        return debugBuildListener.names;
    }

    private class BreakPointLocation {
        private String filename;
        private int line;

        public BreakPointLocation(AntLocation location) {
            this(location.getFileName(), location.getLineNumber());
        }

        public BreakPointLocation(String filename, int line) {
            this.filename = filename;
            this.line = line;
        }

        public String getFileName() {
            return this.filename;
        }

        public int getLine() {
            return this.line;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BreakPointLocation) {
                BreakPointLocation bp = (BreakPointLocation)obj;
                File file1 = new File(this.filename);
                File file2 = new File(bp.filename);
                return this.line == this.line && file1.equals(file2);
            }
            return false;
        }

        public int hashCode() {
            return (this.filename + this.line).hashCode();
        }
    }

    private class BreakPoint {
        private BreakPointLocation location;
        private int cookie;
        private String name;
        private boolean enabled;
        private boolean stop;
        private boolean log;
        private int passCount;
        private int passed;
        private String threadname;
        private String threadnameNot;
        private boolean condition;
        private String enableOtherBPs;
        private String disableOtherBPs;

        private void $init$() {
            this.enabled = true;
            this.stop = true;
            this.passCount = 1;
        }

        public BreakPoint(BreakPointLocation location, int cookie) {
            this.$init$();
            this.location = location;
            this.cookie = cookie;
        }

        public BreakPointLocation getLocation() {
            return this.location;
        }

        public int getCookie() {
            return this.cookie;
        }

        public void setName(String name) {
            List list;
            if (this.name != null && (list = (List)DebugBuildListener.ra$names(DebugBuildListener.this).get(name)) != null) {
                list.remove(this);
                if (list.isEmpty()) {
                    DebugBuildListener.ra$names(DebugBuildListener.this).remove(name);
                }
            }
            this.name = name;
            if (name != null) {
                ArrayList<BreakPoint> list2 = (ArrayList<BreakPoint>)DebugBuildListener.ra$names(DebugBuildListener.this).get(name);
                if (list2 == null) {
                    list2 = new ArrayList<BreakPoint>();
                    DebugBuildListener.ra$names(DebugBuildListener.this).put(name, list2);
                }
                list2.add(this);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setLog(boolean log) {
            this.log = log;
        }

        public boolean isLog() {
            return this.log;
        }

        public void setStop(boolean stop) {
            this.stop = stop;
        }

        public boolean isStop() {
            return this.stop;
        }

        public void setPassCount(int passCount) {
            this.passCount = passCount;
        }

        public int getPassCount() {
            return this.passCount;
        }

        public void setPassed(int passed) {
            this.passed = passed;
        }

        public int getPassed() {
            return this.passed;
        }

        public void setThreadname(String threadname) {
            this.threadname = threadname;
        }

        public String getThreadname() {
            return this.threadname;
        }

        public void setThreadnameNot(String threadnameNot) {
            this.threadnameNot = threadnameNot;
        }

        public String getThreadnameNot() {
            return this.threadnameNot;
        }

        public void setCondition(boolean condition) {
            this.condition = condition;
        }

        public boolean getCondition() {
            return this.condition;
        }

        public void setEnableOtherBPs(String enableOtherBPs) {
            this.enableOtherBPs = enableOtherBPs;
        }

        public String getEnableOtherBPs() {
            return this.enableOtherBPs;
        }

        public void setDisableOtherBPs(String disableOtherBPs) {
            this.disableOtherBPs = disableOtherBPs;
        }

        public String getDisableOtherBPs() {
            return this.disableOtherBPs;
        }

        static int ra$cookie(BreakPoint breakPoint) {
            return breakPoint.cookie;
        }
    }

    private class ThreadInfo {
        private Thread thread;
        private int id;
        private Project project;
        private Stack stack;
        private boolean stepping;
        private int stepCommand;
        private StackFrame stepFrame;
        private boolean stepFinished;
        private String[] targetOrder;

        private void $init$() {
            this.stack = new Stack();
        }

        public ThreadInfo(Thread thread, int id) {
            this.$init$();
            this.thread = thread;
            this.id = id;
        }

        public Thread getThread() {
            return this.thread;
        }

        public int getId() {
            return this.id;
        }

        public Project getProject() {
            return this.project;
        }

        public void setProject(Project project) {
            this.project = project;
        }

        public Stack getStack() {
            return this.stack;
        }

        public int getStackLevel() {
            return this.stack.size();
        }

        public boolean isStepping() {
            return this.stepping;
        }

        public void setStepping(boolean stepping) {
            this.stepping = stepping;
            this.stepFrame = stepping && !this.stack.isEmpty() ? (StackFrame)this.stack.peek() : null;
            this.stepFinished = false;
        }

        public StackFrame getStepFrame() {
            return this.stepFrame;
        }

        public int getStepCommand() {
            return this.stepCommand;
        }

        public void setStepCommand(int stepCommand) {
            this.stepCommand = stepCommand;
        }

        public void setStepFinished(boolean stepFinished) {
            this.stepFinished = stepFinished;
        }

        public boolean isStepFinished() {
            return this.stepFinished;
        }

        public String[] getTargetOrder() {
            return this.targetOrder;
        }

        public void setTargetOrder(String[] targetOrder) {
            this.targetOrder = targetOrder;
        }
    }

    private class StackFrame {
        private Target target;
        private AntLocation location;
        private boolean dependency;

        public StackFrame(Target target, AntLocation location, boolean dependency) {
            this.target = target;
            this.location = location;
            this.dependency = dependency;
        }

        public Target getTarget() {
            return this.target;
        }

        public String getTargetName() {
            return this.target != null ? this.target.getName() : "";
        }

        public AntLocation getLocation() {
            return this.location;
        }

        public void setLocation(AntLocation location) {
            this.location = location;
        }

        public boolean isDependency() {
            return this.dependency;
        }
    }
}

