/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointCondition;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;

class DebugFerrariBreakpoint
extends DebugSharedBreakpoint
implements DebugBreakpoint {
    DebugFerrari df;
    String threadname;
    String threadnameNot;
    boolean enabled;
    boolean stop;
    boolean log;
    String name;
    String enableOtherBPs;
    String disableOtherBPs;
    int passCount;
    DebugBreakpointCondition condition;
    long bpPtr;
    List locations;
    List instanceFilters_id;
    List instanceFilters_address;

    DebugFerrariBreakpoint(DebugFerrari df) {
        this.df = df;
        this.stop = true;
        this.enabled = true;
        this.passCount = 1;
        this.bpPtr = 0L;
        this.instanceFilters_id = new ArrayList();
        this.instanceFilters_address = new ArrayList();
    }

    public void remove() {
        if (this.df != null) {
            this.df.removeBreakpoint(this);
        }
    }

    public String getThreadname() {
        return this.threadname;
    }

    public void setThreadname(String threadname) {
        if (threadname != null && threadname.length() == 0) {
            threadname = null;
        }
        this.threadname = threadname;
        if (this.df != null) {
            this.df.setBreakpointThread(this);
        }
        if (threadname != null && this.threadnameNot != null) {
            this.threadnameNot = null;
            if (this.df != null) {
                this.df.setBreakpointThreadNot(this);
            }
        }
    }

    public String getThreadnameNot() {
        return this.threadnameNot;
    }

    public void setThreadnameNot(String threadnameNot) {
        if (threadnameNot != null && threadnameNot.length() == 0) {
            threadnameNot = null;
        }
        this.threadnameNot = threadnameNot;
        if (this.df != null) {
            this.df.setBreakpointThreadNot(this);
        }
        if (threadnameNot != null && this.threadname != null) {
            this.threadname = null;
            if (this.df != null) {
                this.df.setBreakpointThread(this);
            }
        }
    }

    public synchronized boolean getEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.df != null) {
            this.df.setBreakpointEnabled(this);
        }
    }

    public boolean getStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
        if (this.df != null) {
            this.df.setBreakpointStop(this);
        }
    }

    public boolean getLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
        if (this.df != null) {
            this.df.setBreakpointLog(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.df != null) {
            this.df.setBreakpointName(this);
        }
    }

    public String getEnableOtherBPs() {
        return this.enableOtherBPs;
    }

    public void setEnableOtherBPs(String enableOtherBPs) {
        this.enableOtherBPs = enableOtherBPs;
        if (this.df != null) {
            this.df.setBreakpointEnableOtherBPs(this);
        }
    }

    public String getDisableOtherBPs() {
        return this.disableOtherBPs;
    }

    public void setDisableOtherBPs(String disableOtherBPs) {
        this.disableOtherBPs = disableOtherBPs;
        if (this.df != null) {
            this.df.setBreakpointDisableOtherBPs(this);
        }
    }

    public DebugBreakpointCondition getCondition() {
        return this.condition;
    }

    public void setCondition(DebugBreakpointCondition condition) {
        this.condition = condition;
        if (this.df != null) {
            this.df.setBreakpointCondition(this);
        }
    }

    public synchronized int getPassCount() {
        return this.passCount;
    }

    public synchronized void setPassCount(int passCount) {
        this.passCount = passCount;
        if (this.df != null) {
            this.df.setBreakpointPassCount(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceFilter(DebugDataObjectInfo data) {
        Long id = new Long(data.getUniqueID());
        List list = this.instanceFilters_id;
        synchronized (list) {
            if (!this.instanceFilters_id.contains(id)) {
                this.instanceFilters_id.add(id);
                Long address = new Long(((DebugFerrariDataObjectInfo)data).address);
                this.instanceFilters_address.add(address);
            }
        }
        this.df.modifyBreakpointInstanceFilter(this, (DebugFerrariDataObjectInfo)data, true);
    }

    public void removeInstanceFilter(DebugDataObjectInfo data) {
        this.removeInstanceFilter(data.getUniqueID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceFilter(long uniqueID) {
        Long id = new Long(uniqueID);
        Long address = null;
        List list = this.instanceFilters_id;
        synchronized (list) {
            int i = this.instanceFilters_id.indexOf(id);
            if (i != -1) {
                this.instanceFilters_id.remove(i);
                address = (Long)this.instanceFilters_address.remove(i);
            }
        }
        if (address != null) {
            this.df.modifyBreakpointInstanceFilter(this, address, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstanceFilterSet(DebugDataObjectInfo data) {
        Long id = new Long(data.getUniqueID());
        List list = this.instanceFilters_id;
        synchronized (list) {
            if (this.instanceFilters_id.contains(id)) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getInstanceFilters() {
        List list = this.instanceFilters_id;
        synchronized (list) {
            long[] array = new long[this.instanceFilters_id.size()];
            int i = 0;
            Iterator it = this.instanceFilters_id.iterator();
            while (it.hasNext()) {
                array[i++] = (Long)it.next();
            }
            long[] lArray = array;
            return lArray;
        }
    }

    public synchronized DebugLocation[] getLocations() {
        if (this.locations == null) {
            return new DebugLocation[0];
        }
        int count = this.locations.size();
        DebugLocation[] array = new DebugLocation[count];
        int i = 0;
        while (i < count) {
            array[i] = (DebugLocation)this.locations.get(i);
            ++i;
        }
        return array;
    }

    synchronized void addLocation(DebugLocation location) {
        if (this.locations == null) {
            this.locations = new ArrayList();
        }
        this.locations.add(location);
    }

    synchronized void disconnect() {
        this.df = null;
        this.bpPtr = 0L;
        this.locations = null;
    }

    synchronized void updateChanges(DebugFerrariBreakpoint bpFromVM) {
        this.enabled = bpFromVM.enabled;
        this.passCount = bpFromVM.passCount;
        this.locations = bpFromVM.locations;
    }

    public void setBreakpoint() {
    }

    public void changeBreakpoint() {
    }
}

