/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassLoaderInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariFieldInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariMethodInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStoppedListener;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public final class DebugFerrariClassInfo
implements DebugClassInfo,
DebugFerrariStoppedListener {
    DebugFerrari df;
    int stoppedCount;
    boolean expired;
    long classPtr;
    int access;
    int sizeOfObject;
    boolean isPrimitive;
    String name;
    String primarySourceFilename;
    String sourceFilename;
    int countObjects;
    int countMemory;
    String justPackage;
    String packagePath;
    String nameWithoutPackage;
    private boolean stoppedListener;
    private SoftReference sfFields;
    private HashMap methodsCache;
    private boolean classLoaderInfoReceived;
    private long classLoaderAddress;
    private long classLoaderClassPtr;
    private int hashCode;

    DebugFerrariClassInfo(DebugFerrari df, long classPtr, int access, int sizeOfObject, boolean isPrimitive, String name, String sourceFilename) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.expired = false;
        this.classPtr = classPtr;
        this.access = access;
        this.isPrimitive = isPrimitive;
        this.name = name;
        this.sourceFilename = sourceFilename;
        this.sizeOfObject = sizeOfObject;
        this.countObjects = 0;
        this.countMemory = 0;
    }

    void setClassLoader(long classLoaderAddress, long classLoaderClassPtr) {
        this.classLoaderAddress = classLoaderAddress;
        this.classLoaderClassPtr = classLoaderClassPtr;
        this.classLoaderInfoReceived = true;
    }

    public void stoppedOrResuming(boolean stopped) {
        this.sfFields = null;
        this.stoppedListener = false;
        this.df.removeStoppedListener(this);
    }

    public boolean hasExpired() {
        return this.classPtr == 0L && this.df.stoppedCount != this.stoppedCount || this.expired;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Class has expired: " + this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        if (this.justPackage == null) {
            this.justPackage = DebugShared.getPackage(this.name);
        }
        return this.justPackage;
    }

    public String getPackagePath() {
        if (this.packagePath == null) {
            this.packagePath = DebugShared.getPackagePath(this.name);
        }
        return this.packagePath;
    }

    public String getNameWithoutPackage() {
        if (this.nameWithoutPackage == null) {
            this.nameWithoutPackage = DebugShared.getNameWithoutPackage(this.name);
        }
        return this.nameWithoutPackage;
    }

    public String getGenericSignature() {
        return null;
    }

    public int getAccess() {
        return this.access;
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isObject() {
        return !this.isInterface() && !this.isPrimitive && !this.name.endsWith("]");
    }

    public boolean isArray() {
        return !this.isInterface() && !this.isPrimitive && this.name.endsWith("]");
    }

    public int getSizeOfObject() {
        return this.sizeOfObject;
    }

    public long countObjectsOfClass() {
        this.throwIfExpired();
        this.df.updateClassCounts();
        return this.countObjects;
    }

    public int countMemoryOfClass() {
        this.throwIfExpired();
        this.df.updateClassCounts();
        return this.countMemory;
    }

    public DebugDataObjectInfo getClassObject() {
        this.throwIfExpired();
        return this.df.getClassObject(this);
    }

    long getClassLoaderAddress() {
        if (!this.classLoaderInfoReceived) {
            this.getClassLoaderObject();
        }
        return this.classLoaderAddress;
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        this.throwIfExpired();
        if (!this.isPrimitive) {
            DebugFerrariDataObjectInfo data;
            if (this.classLoaderInfoReceived) {
                DebugFerrariClassInfo classLoaderClazz = this.df.findClass(this.classLoaderClassPtr);
                data = new DebugFerrariDataObjectInfo(this.df, classLoaderClazz, 0L, 0L, "", Long.toHexString(this.classLoaderAddress).toUpperCase());
            } else {
                data = this.df.getClassLoaderObject(this);
                if (data != null) {
                    this.classLoaderAddress = data.address;
                    this.classLoaderClassPtr = data.clazz.classPtr;
                }
                this.classLoaderInfoReceived = true;
            }
            return data;
        }
        return null;
    }

    public DebugClassLoaderInfo getClassLoader() {
        this.throwIfExpired();
        if (!this.classLoaderInfoReceived) {
            this.getClassLoaderObject();
        }
        DebugFerrariClassInfo classLoaderClass = this.df.findClass(this.classLoaderClassPtr);
        return DebugFerrariClassLoaderInfo.makeClassLoaderInfo(this.df, this.classLoaderAddress, classLoaderClass);
    }

    public String getPrimarySourceFilename() {
        this.throwIfExpired();
        if (this.primarySourceFilename == null) {
            String[] fileAndPath = this.df.getClassPrimarySourceFilename(this);
            if (fileAndPath != null) {
                this.primarySourceFilename = fileAndPath[0];
            }
            if (this.primarySourceFilename == null) {
                this.primarySourceFilename = this.sourceFilename;
            }
        }
        return this.primarySourceFilename;
    }

    public String getSourceFilename() {
        return this.sourceFilename;
    }

    public DebugClassInfo getSuperClass(int level) {
        this.throwIfExpired();
        return this.df.getClassSuperClass(this, level);
    }

    public int getMethodCount() {
        this.throwIfExpired();
        return this.df.getClassMethodCount(this);
    }

    public DebugMethodInfo[] getMethods() {
        this.throwIfExpired();
        return this.df.getClassMethods(this);
    }

    DebugFerrariMethodInfo getMethod(long methodPtr, int access, String name) {
        DebugFerrariMethodInfo method;
        Long key = new Long(methodPtr);
        if (this.methodsCache != null) {
            SoftReference sfMethod = (SoftReference)this.methodsCache.get(key);
            if (sfMethod != null && (method = (DebugFerrariMethodInfo)sfMethod.get()) != null) {
                method.updateMethod(access);
                return method;
            }
        } else {
            this.methodsCache = new HashMap();
        }
        method = new DebugFerrariMethodInfo(this.df, methodPtr, this, access, name);
        this.methodsCache.put(key, new SoftReference<DebugFerrariMethodInfo>(method));
        return method;
    }

    void redefinedClass() {
        this.sfFields = null;
        if (this.methodsCache != null) {
            this.methodsCache.clear();
        }
    }

    public int getStaticFieldCount() {
        return this.getStaticFieldCount(0, false);
    }

    public DebugFieldInfo[] getStaticFields() {
        return this.getStaticFields(0, false);
    }

    public DebugFieldInfo getStaticField(int index) {
        return this.getStaticField(0, false, index);
    }

    public int getStaticFieldCount(int classLevel) {
        return this.getStaticFieldCount(classLevel, false);
    }

    public DebugFieldInfo[] getStaticFields(int classLevel) {
        return this.getStaticFields(classLevel, false);
    }

    public DebugFieldInfo getStaticField(int classLevel, int index) {
        return this.getStaticField(classLevel, false, index);
    }

    public int getStaticFieldCount(int classLevel, boolean noFinal) {
        this.throwIfExpired();
        return this.df.getClassStaticFieldCount(this, classLevel, noFinal);
    }

    public DebugFieldInfo[] getStaticFields(int classLevel, boolean noFinal) {
        Object o;
        this.throwIfExpired();
        if (classLevel == -1 && !noFinal && this.sfFields != null && (o = this.sfFields.get()) != null) {
            return (DebugFieldInfo[])o;
        }
        DebugFieldInfo[] fields = this.df.getClassStaticFields(this, classLevel, noFinal, -1);
        if (classLevel == -1 && !noFinal) {
            this.sfFields = new SoftReference<DebugFieldInfo[]>(fields);
            if (!this.stoppedListener) {
                this.stoppedListener = true;
                this.df.addStoppedListener(this);
            }
        }
        return fields;
    }

    public DebugFieldInfo getStaticField(int classLevel, boolean noFinal, int index) {
        this.throwIfExpired();
        DebugFerrariFieldInfo[] field = this.df.getClassStaticFields(this, classLevel, noFinal, index);
        if (field != null && field.length == 1) {
            return field[0];
        }
        return null;
    }

    public DebugFieldInfo getStaticField(String name) {
        return null;
    }

    public int getFieldCount(int classLevel) {
        return this.getFieldCount(classLevel, false, false);
    }

    public DebugFieldInfo[] getFields(int classLevel) {
        return this.getFields(classLevel, false, false);
    }

    public DebugFieldInfo getField(int classLevel, int index) {
        return this.getField(classLevel, false, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal) {
        return this.getFieldCount(classLevel, noFinal, false);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        return this.getFields(classLevel, noFinal, false);
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        return this.getField(classLevel, noFinal, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        this.throwIfExpired();
        return this.df.getClassFieldCount(this, classLevel, noFinal, noStatic);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        this.throwIfExpired();
        return this.df.getClassFields(this, classLevel, noFinal, noStatic, -1);
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        this.throwIfExpired();
        DebugFerrariFieldInfo[] field = this.df.getClassFields(this, classLevel, noFinal, noStatic, index);
        if (field != null && field.length == 1) {
            return field[0];
        }
        return null;
    }

    public boolean isDebuggable() {
        this.throwIfExpired();
        return this.df.isClassDebuggable(this);
    }

    public void setDebuggable(boolean debuggable) {
        this.throwIfExpired();
        this.df.setClassDebuggable(this, debuggable);
    }

    public boolean isObfuscated() {
        this.throwIfExpired();
        return this.df.isClassObfuscated(this);
    }

    public boolean isCodeCoverage() {
        this.throwIfExpired();
        return this.df.isClassCodeCoverage(this);
    }

    public void setCodeCoverage(boolean codeCoverage) {
        this.throwIfExpired();
        this.df.setClassCodeCoverage(this, codeCoverage);
    }

    public void discardCodeCoverage() {
        this.throwIfExpired();
        this.df.discardClassCodeCoverage(this);
    }

    public double getCodeCoverageRatio() {
        this.throwIfExpired();
        return this.df.getClassCodeCoverageRatio(this);
    }

    public DebugClassInfo[] getInterfaces() {
        return this.getInterfaces(0);
    }

    public DebugClassInfo[] getInterfaces(int classLevel) {
        this.throwIfExpired();
        return this.df.getClassInterfaces(this, classLevel);
    }

    public boolean generateSourceFile() {
        this.throwIfExpired();
        return this.df.generateSourceFile(this);
    }

    public int getLanguage() {
        return 1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.classPtr;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariClassInfo) {
            DebugFerrariClassInfo other = (DebugFerrariClassInfo)o;
            if (!this.hasExpired()) {
                return !other.hasExpired() && this.classPtr == other.classPtr;
            }
            return other.hasExpired() && this.classPtr == other.classPtr && this.access == other.access && this.isPrimitive == other.isPrimitive && this.name.equals(other.name) && (this.sourceFilename == null ? other.sourceFilename == null : this.sourceFilename.equals(other.sourceFilename));
        }
        return false;
    }

    public void special(int i) {
        this.throwIfExpired();
        this.df.special(this, i);
    }

    public boolean isEnum() {
        return false;
    }

    public DebugFieldInfo[] getEnumConstants() {
        return new DebugFieldInfo[0];
    }
}

