/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.util.ArrayList;
import java.util.Map;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataObjectInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;

final class DebugFerrariClassLoaderInfo
implements DebugClassLoaderInfo {
    private DebugFerrari df;
    private long address;
    private DebugFerrariClassInfo clazz;
    private DebugFerrariClassLoaderInfo parent;
    private String className;
    private int id;
    private int hashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DebugFerrariClassLoaderInfo makeClassLoaderInfo(DebugFerrari df, long address, DebugFerrariClassInfo clazz) {
        Map map = df.classLoaderInfosByAddress;
        synchronized (map) {
            Long key = new Long(address);
            DebugFerrariClassLoaderInfo classLoaderInfo = (DebugFerrariClassLoaderInfo)df.classLoaderInfosByAddress.get(key);
            if (classLoaderInfo == null) {
                classLoaderInfo = new DebugFerrariClassLoaderInfo(df, address, clazz);
                df.classLoaderInfosByAddress.put(key, classLoaderInfo);
            }
            DebugFerrariClassLoaderInfo debugFerrariClassLoaderInfo = classLoaderInfo;
            return debugFerrariClassLoaderInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DebugFerrariClassLoaderInfo(DebugFerrari df, long address, DebugFerrariClassInfo clazz) {
        this.df = df;
        this.address = address;
        this.clazz = clazz;
        if (clazz != null) {
            this.className = clazz.name;
            if (!this.className.equals("sun.reflect.DelegatingClassLoader")) {
                DebugShared.exploreClassLoaderParents(this);
            }
            Map map = df.classLoaderIds;
            synchronized (map) {
                Integer lastId = (Integer)df.classLoaderIds.get(this.className);
                this.id = lastId == null ? 1 : lastId + 1;
                lastId = new Integer(this.id);
                df.classLoaderIds.put(this.className, lastId);
            }
        }
    }

    public boolean hasExpired() {
        return false;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("ClassLoader has expired");
        }
    }

    public String getClassName() {
        this.throwIfExpired();
        return this.className;
    }

    public int getId() {
        this.throwIfExpired();
        return this.id;
    }

    public DebugClassInfo[] listDefinedClasses() {
        this.throwIfExpired();
        ArrayList<DebugFerrariClassInfo> v = new ArrayList<DebugFerrariClassInfo>();
        DebugClassInfo[] allClasses = this.df.listClasses();
        int size = allClasses.length;
        int i = 0;
        while (i < size) {
            DebugFerrariClassInfo clazz = (DebugFerrariClassInfo)allClasses[i];
            if (clazz.getClassLoaderAddress() == this.address) {
                v.add(clazz);
            }
            ++i;
        }
        DebugClassInfo[] array = new DebugClassInfo[v.size()];
        return v.toArray(array);
    }

    public DebugDataObjectInfo getClassLoaderObject() {
        this.throwIfExpired();
        if (this.address != 0L) {
            return new DebugFerrariDataObjectInfo(this.df, this.clazz, 0L, 0L, "", Long.toHexString(this.address).toUpperCase());
        }
        return null;
    }

    public DebugClassLoaderInfo getParent() {
        DebugFerrariDataObjectInfo parentClassLoaderObject;
        DebugDataObjectInfo classLoaderObject;
        this.throwIfExpired();
        if (this.parent == null && (classLoaderObject = this.getClassLoaderObject()) != null && (parentClassLoaderObject = (DebugFerrariDataObjectInfo)DebugShared.getParentClassLoaderObject(classLoaderObject)) != null) {
            this.parent = DebugFerrariClassLoaderInfo.makeClassLoaderInfo(this.df, parentClassLoaderObject.address, parentClassLoaderObject.clazz);
        }
        return this.parent;
    }

    public boolean isSystemClassLoader() {
        this.throwIfExpired();
        return this.address != 0L && this.address == this.df.getSystemClassLoaderAddress();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.address;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariClassLoaderInfo) {
            DebugFerrariClassLoaderInfo other = (DebugFerrariClassLoaderInfo)o;
            return this.address == other.address;
        }
        return false;
    }
}

