/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariArb;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariConnectArg;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariConnection;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariTransport;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugConnectionListener;
import oracle.jdevimpl.debugger.support.DebugConnector;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public final class DebugFerrariConnector
implements DebugConnector,
DebugFerrariConnection {
    private DebugFerrariConnection connection;
    private Socket clientSock;

    public static String getVersion() {
        int major = 2;
        int minor = 19;
        return Integer.toString(major) + "." + Integer.toString(minor);
    }

    public DebugFerrariConnector() {
        this(null);
    }

    public DebugFerrariConnector(DebugFerrariConnection connection) {
        this.connection = connection != null ? connection : this;
    }

    public synchronized DebugConnectArg[] getConnectArgs() {
        DebugConnectArg[] a = new DebugFerrariConnectArg[]{};
        return a;
    }

    public synchronized DebugVirtualMachine connect(DebugConnectArg[] connectArgs) throws Exception {
        String host = connectArgs[0].getValue();
        int port = Integer.parseInt(connectArgs[1].getValue());
        int timeout = 0;
        try {
            timeout = Integer.parseInt(connectArgs[2].getValue()) * 1000;
        }
        catch (Exception e) {
            // empty catch block
        }
        DebugFerrariTransport transport = null;
        boolean vmWasRunning = false;
        try {
            this.connection.openConnection(host, port, timeout);
            transport = new DebugFerrariTransport(this.connection);
            transport.sendMessage(32);
            int response = transport.receiveMessage();
            if (response == 19) {
                int protocolVersion = transport.receiveInt();
                boolean bl = vmWasRunning = transport.receiveInt() != 0;
                if (protocolVersion == 531) {
                    DebugFerrari debugFerrari = new DebugFerrari(transport, vmWasRunning);
                    return debugFerrari;
                }
                String msg = DebugFerrariArb.format(5, Integer.toHexString(protocolVersion).toUpperCase(), Integer.toHexString(531).toUpperCase());
                throw new Exception(msg);
            }
            throw new Exception(DebugFerrariArb.getString(6));
        }
        catch (Exception e) {
            if (transport != null && transport.isConnected()) {
                boolean terminate = vmWasRunning ^ true;
                transport.sendMessage(34, terminate ? 1 : 0);
                transport.disconnect();
            }
            throw (Exception)e.fillInStackTrace();
        }
    }

    public synchronized void startListening(DebugConnectArg[] connectArgs, DebugConnectionListener connectionListener) throws Exception {
        throw new UnsupportedOperationException("Can not listen. Not supported.");
    }

    public synchronized void stopListening() {
        throw new IllegalStateException("Can not stop listening. Not currently listening.");
    }

    public void openConnection(String host, int port, int timeout) throws IOException {
        this.clientSock = new Socket();
        InetAddress addr = InetAddress.getByName(host);
        InetSocketAddress socketAddress = new InetSocketAddress(addr, port);
        this.clientSock.connect(socketAddress, timeout);
        this.clientSock.setTcpNoDelay(true);
    }

    public InputStream getInputStream() throws IOException {
        return this.clientSock.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.clientSock.getOutputStream();
    }

    public void closeConnection() throws IOException {
        this.clientSock = null;
    }
}

