/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.lang.ref.SoftReference;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStoppedListener;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;

final class DebugFerrariDataArrayInfo
extends DebugFerrariDataCompositeInfo
implements DebugDataArrayInfo,
DebugFerrariStoppedListener {
    private boolean stoppedListener;
    private SoftReference sfArrayElements;

    DebugFerrariDataArrayInfo(DebugFerrari df, DebugFerrariClassInfo clazz, long place, long owner, String value, String hexValue) {
        super(df, clazz, place, owner, value, hexValue);
    }

    public void stoppedOrResuming(boolean stopped) {
        this.sfArrayElements = null;
        this.stoppedListener = false;
        this.df.removeStoppedListener(this);
    }

    public DebugClassInfo getArrayElementClassInfo() {
        DebugFerrariClassInfo arrayElementClass = this.df.getArrayElementClass(this.clazz);
        if (arrayElementClass != null) {
            return arrayElementClass;
        }
        String name = this.clazz.getName();
        if (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            return this.df.findClassByName(name);
        }
        return null;
    }

    public int getArrayStart() {
        return 0;
    }

    public int getArrayCount() {
        return this.getArrayCount(false);
    }

    public DebugArrayElementInfo[] getArrayElements() {
        return this.getArrayElements(0, -1, false);
    }

    public DebugArrayElementInfo[] getArrayElements(int start, int count) {
        return this.getArrayElements(start, count, false);
    }

    public int getArrayCount(boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        return this.df.getArrayCount(this, nonNullCompositesOnly);
    }

    public DebugArrayElementInfo[] getArrayElements(boolean nonNullCompositesOnly) {
        return this.getArrayElements(0, -1, nonNullCompositesOnly);
    }

    public DebugArrayElementInfo[] getArrayElements(int start, int count, boolean nonNullCompositesOnly) {
        Object o;
        this.throwIfExpired();
        if (start == 0 && count == -1 && !nonNullCompositesOnly && this.sfArrayElements != null && (o = this.sfArrayElements.get()) != null) {
            return (DebugArrayElementInfo[])o;
        }
        DebugArrayElementInfo[] arrayElements = this.df.listArray(this, start, count, nonNullCompositesOnly);
        if (start == 0 && count == -1 && !nonNullCompositesOnly) {
            this.sfArrayElements = new SoftReference<DebugArrayElementInfo[]>(arrayElements);
            if (!this.stoppedListener) {
                this.stoppedListener = true;
                this.df.addStoppedListener(this);
            }
        }
        return arrayElements;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariDataArrayInfo) {
            return super.equals(o);
        }
        return false;
    }
}

