/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;

class DebugFerrariDataCompositeInfo
extends DebugFerrariDataInfo
implements DebugDataCompositeInfo {
    long address = 0L;
    private int hashCode;

    DebugFerrariDataCompositeInfo(DebugFerrari df, DebugFerrariClassInfo clazz, long place, long owner, String value, String hexValue) {
        super(df, clazz, place, owner, value, "");
        if (hexValue.length() > 0) {
            try {
                this.address = DebugSharedPrimitives.longFromHexString(hexValue);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    void updateInfo(DebugFerrariDataInfo other) {
        super.updateInfo(other);
        if (other instanceof DebugFerrariDataCompositeInfo) {
            this.address = ((DebugFerrariDataCompositeInfo)other).address;
        }
    }

    public boolean isNull() {
        this.hasExpired();
        return this.address == 0L;
    }

    public long getAddressOfObject() {
        this.hasExpired();
        return this.address;
    }

    public boolean canSetAddressOfObject() {
        return this.place != 0L;
    }

    public boolean canSetAddressOfObjectToNull() {
        return this.place != 0L;
    }

    public boolean setAddressOfObject(long address) {
        this.throwIfExpired();
        return this.df.modifyData(this, Long.toString(address));
    }

    public DebugPinnedInfo pinObject(DebugPinListener pinListener) {
        this.throwIfExpired();
        return this.df.pinObject(this, pinListener);
    }

    public long getUniqueID() {
        this.throwIfExpired();
        return this.df.getUniqueID(this);
    }

    public String getCourtesyValue() {
        this.throwIfExpired();
        return this.df.getCourtesyInfo(this);
    }

    public boolean canGetWholeThing() {
        this.throwIfExpired();
        return this.df.canGetWholeThing(this);
    }

    public Object getWholeThing() {
        this.throwIfExpired();
        return this.df.getWholeThing(this);
    }

    public DebugMonitorInfo getMonitor() {
        this.throwIfExpired();
        return this.df.getMonitor(this);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode() + (int)this.address;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariDataCompositeInfo) {
            DebugFerrariDataCompositeInfo other = (DebugFerrariDataCompositeInfo)o;
            return super.equals(o) && this.address == other.address;
        }
        return false;
    }
}

