/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariFieldInfo;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

class DebugFerrariDataInfo
implements DebugDataInfo {
    DebugFerrari df;
    int stoppedCount;
    DebugFerrariClassInfo clazz;
    long place;
    long owner;
    String value;
    String hexValue;
    DebugFerrariFieldInfo staticField;
    DebugFerrariClassInfo declaredClass;
    private int hashCode;

    DebugFerrariDataInfo(DebugFerrari df, DebugFerrariClassInfo clazz, long place, long owner, String value, String hexValue) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.clazz = clazz;
        this.place = place;
        this.owner = owner;
        this.value = value;
        this.hexValue = hexValue;
        this.declaredClass = clazz;
    }

    void setStaticField(DebugFerrariFieldInfo staticField) {
        this.staticField = staticField;
    }

    void setDeclaredClass(DebugFerrariClassInfo declaredClass) {
        this.declaredClass = declaredClass;
    }

    void updateInfo(DebugFerrariDataInfo other) {
        this.stoppedCount = other.stoppedCount;
        this.clazz = other.clazz;
        this.place = other.place;
        this.owner = other.owner;
        this.value = other.value;
        this.hexValue = other.hexValue;
    }

    public DebugVirtualMachine getVM() {
        return this.df;
    }

    public boolean hasExpired() {
        if (this.df.stoppedCount != this.stoppedCount && this.staticField != null && !this.staticField.hasExpired()) {
            this.df.updateStaticFieldData(this);
        }
        return this.df.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    boolean isStaticFieldData() {
        return this.staticField != null;
    }

    public DebugClassInfo getClassInfo() {
        this.hasExpired();
        return this.clazz;
    }

    public String getValue() {
        this.hasExpired();
        return this.value;
    }

    public String getHexValue() {
        this.hasExpired();
        return this.hexValue;
    }

    public boolean canModifyDataWithString() {
        return this.place != 0L && (this.declaredClass.isPrimitive || this.declaredClass.name.equals("java.lang.String"));
    }

    public boolean modifyDataWithString(String newValue) {
        this.throwIfExpired();
        if (this.place != 0L) {
            if (this.declaredClass.isPrimitive) {
                return this.df.modifyData(this, newValue);
            }
            if (this.declaredClass.name.equals("java.lang.String")) {
                return this.df.modifyString(this, newValue);
            }
        }
        return false;
    }

    public boolean canModifyDataWithData() {
        return this.place != 0L;
    }

    public boolean modifyDataWithData(DebugDataInfo newValue) {
        this.throwIfExpired();
        String v = newValue instanceof DebugFerrariDataCompositeInfo ? Long.toString(((DebugFerrariDataCompositeInfo)newValue).address) : ((DebugFerrariDataInfo)newValue).value;
        return this.df.modifyData(this, v);
    }

    public boolean canModifyDataWithNewObject() {
        return false;
    }

    public boolean modifyDataWithNewObject(DebugMethodInfo method, String[] arguments) {
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.clazz.hashCode() + this.value.hashCode() + this.hexValue.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariDataInfo) {
            DebugFerrariDataInfo other = (DebugFerrariDataInfo)o;
            return this.df.equals(other.df) && this.clazz.equals(other.clazz) && this.value.equals(other.value) && this.hexValue.equals(other.hexValue);
        }
        return false;
    }
}

