/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.lang.ref.SoftReference;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariFieldInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariStoppedListener;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;

final class DebugFerrariDataObjectInfo
extends DebugFerrariDataCompositeInfo
implements DebugDataObjectInfo,
DebugFerrariStoppedListener {
    private boolean stoppedListener;
    private SoftReference sfFields;

    DebugFerrariDataObjectInfo(DebugFerrari df, DebugFerrariClassInfo clazz, long place, long owner, String value, String hexValue) {
        super(df, clazz, place, owner, value, hexValue);
    }

    public void stoppedOrResuming(boolean stopped) {
        this.sfFields = null;
        this.stoppedListener = false;
        this.df.removeStoppedListener(this);
    }

    public int getFieldCount(int classLevel) {
        return this.getFieldCount(classLevel, false, false, false);
    }

    public DebugFieldInfo[] getFields(int classLevel) {
        return this.getFields(classLevel, false, false, false);
    }

    public DebugFieldInfo getField(int classLevel, int index) {
        return this.getField(classLevel, false, false, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal) {
        return this.getFieldCount(classLevel, noFinal, false, false);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        return this.getFields(classLevel, noFinal, false, false);
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        return this.getField(classLevel, noFinal, false, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        return this.getFieldCount(classLevel, noFinal, noStatic, false);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        return this.getFields(classLevel, noFinal, noStatic, false);
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        return this.getField(classLevel, noFinal, noStatic, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        return this.df.getFieldCount(this, classLevel, noFinal, noStatic, nonNullCompositesOnly);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly) {
        Object o;
        this.throwIfExpired();
        if (!(classLevel != -1 || noFinal || noStatic || nonNullCompositesOnly || this.sfFields == null || (o = this.sfFields.get()) == null)) {
            return (DebugFieldInfo[])o;
        }
        DebugFieldInfo[] fields = this.df.listFields(this, classLevel, noFinal, noStatic, nonNullCompositesOnly, -1);
        if (!(classLevel != -1 || noFinal || noStatic || nonNullCompositesOnly)) {
            this.sfFields = new SoftReference<DebugFieldInfo[]>(fields);
            if (!this.stoppedListener) {
                this.stoppedListener = true;
                this.df.addStoppedListener(this);
            }
        }
        return fields;
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly, int index) {
        this.throwIfExpired();
        DebugFerrariFieldInfo[] field = this.df.listFields(this, classLevel, noFinal, noStatic, nonNullCompositesOnly, index);
        if (field != null && field.length == 1) {
            return field[0];
        }
        return null;
    }

    public boolean canGetFieldByName() {
        return this.df.canGetFieldByName();
    }

    public DebugFieldInfo getField(String name) {
        this.throwIfExpired();
        return this.df.getFieldByName(this, name, null);
    }

    public DebugFieldInfo getField(String name, DebugClassInfo declaringClass) {
        this.throwIfExpired();
        return this.df.getFieldByName(this, name, (DebugFerrariClassInfo)declaringClass);
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariDataObjectInfo) {
            return super.equals(o);
        }
        return false;
    }
}

