/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;

final class DebugFerrariDataPrimitiveInfo
extends DebugFerrariDataInfo
implements DebugDataPrimitiveInfo {
    DebugFerrariDataPrimitiveInfo(DebugFerrari df, DebugFerrariClassInfo clazz, long place, long owner, String value, String hexValue) {
        super(df, clazz, place, owner, value, hexValue);
        if (clazz != null) {
            try {
                if (clazz.name.equals("double")) {
                    double d = Double.longBitsToDouble(DebugSharedPrimitives.longFromHexString(hexValue));
                    this.value = Double.toString(d);
                } else if (clazz.name.equals("float")) {
                    float f = Float.intBitsToFloat(DebugSharedPrimitives.intFromHexString(hexValue));
                    this.value = Float.toString(f);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public boolean modifyDataWithString(String newValue) {
        if (this.clazz != null) {
            try {
                if (this.clazz.name.equals("double")) {
                    newValue = Double.toString(DebugSharedPrimitives.doubleDecode(newValue));
                } else if (this.clazz.name.equals("float")) {
                    newValue = Float.toString(DebugSharedPrimitives.floatDecode(newValue));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.modifyDataWithString(newValue);
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariDataPrimitiveInfo) {
            return super.equals(o);
        }
        return false;
    }

    Object promoteValue(char sig2) throws Exception {
        if (this.clazz != null) {
            switch (sig2) {
                case 'Z': {
                    if (!this.clazz.name.equals("boolean")) break;
                    return new Boolean(DebugSharedPrimitives.booleanDecode(this.value));
                }
                case 'C': {
                    if (!this.clazz.name.equals("char")) break;
                    return new Character(DebugSharedPrimitives.charDecode(this.value));
                }
                case 'B': {
                    if (!this.clazz.name.equals("byte")) break;
                    return new Byte(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'S': {
                    if (this.clazz.name.equals("short")) {
                        return new Short(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Short(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'I': {
                    if (this.clazz.name.equals("int")) {
                        return new Integer(DebugSharedPrimitives.intDecode(this.value));
                    }
                    if (this.clazz.name.equals("short")) {
                        return new Integer(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Integer(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'J': {
                    if (this.clazz.name.equals("long")) {
                        return new Long(DebugSharedPrimitives.longDecode(this.value));
                    }
                    if (this.clazz.name.equals("int")) {
                        return new Long(DebugSharedPrimitives.intDecode(this.value));
                    }
                    if (this.clazz.name.equals("short")) {
                        return new Long(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Long(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'F': {
                    if (this.clazz.name.equals("float")) {
                        return new Float(DebugSharedPrimitives.floatDecode(this.value));
                    }
                    if (this.clazz.name.equals("long")) {
                        return new Float(DebugSharedPrimitives.longDecode(this.value));
                    }
                    if (this.clazz.name.equals("int")) {
                        return new Float(DebugSharedPrimitives.intDecode(this.value));
                    }
                    if (this.clazz.name.equals("short")) {
                        return new Float(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Float(DebugSharedPrimitives.byteDecode(this.value));
                }
                case 'D': {
                    if (this.clazz.name.equals("double")) {
                        return new Double(DebugSharedPrimitives.doubleDecode(this.value));
                    }
                    if (this.clazz.name.equals("float")) {
                        return new Double(DebugSharedPrimitives.floatDecode(this.value));
                    }
                    if (this.clazz.name.equals("long")) {
                        return new Double(DebugSharedPrimitives.longDecode(this.value));
                    }
                    if (this.clazz.name.equals("int")) {
                        return new Double(DebugSharedPrimitives.intDecode(this.value));
                    }
                    if (this.clazz.name.equals("short")) {
                        return new Double(DebugSharedPrimitives.shortDecode(this.value));
                    }
                    if (!this.clazz.name.equals("byte")) break;
                    return new Double(DebugSharedPrimitives.byteDecode(this.value));
                }
            }
        }
        throw new Exception("Unable to promote value");
    }
}

