/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;

public final class DebugFerrariFieldInfo
implements DebugFieldInfo {
    DebugFerrari df;
    int stoppedCount;
    long fieldPtr;
    DebugFerrariClassInfo declaringClass;
    int access;
    DebugFerrariClassInfo clazz;
    String name;
    DebugFerrariDataInfo data;
    private int hashCode;

    DebugFerrariFieldInfo(DebugFerrari df, long fieldPtr, DebugFerrariClassInfo declaringClass, int access, DebugFerrariClassInfo clazz, String name, DebugFerrariDataInfo data) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.fieldPtr = fieldPtr;
        this.declaringClass = declaringClass;
        this.access = access;
        this.clazz = clazz;
        this.name = name;
        this.data = data;
        if (data != null) {
            data.setDeclaredClass(clazz);
        }
        if ((access & 8) != 0) {
            data.setStaticField(this);
        }
    }

    public boolean hasExpired() {
        if (this.df.stoppedCount != this.stoppedCount) {
            if ((this.access & 8) == 0) {
                this.data = null;
            }
            if (!this.declaringClass.hasExpired()) {
                this.stoppedCount = this.df.stoppedCount;
            }
        }
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Field has expired: " + this.name);
        }
    }

    public int getAccess() {
        this.hasExpired();
        return this.access;
    }

    public boolean isStatic() {
        this.hasExpired();
        return (this.access & 8) != 0;
    }

    public boolean isFinal() {
        this.hasExpired();
        return (this.access & 0x10) != 0;
    }

    public DebugClassInfo getClassInfo() {
        this.hasExpired();
        return this.clazz;
    }

    public String getGenericSignature() {
        return null;
    }

    public DebugClassInfo getDeclaringClassInfo() {
        this.hasExpired();
        return this.declaringClass;
    }

    public String getName() {
        this.hasExpired();
        return this.name;
    }

    public DebugDataInfo getDataInfo() {
        this.hasExpired();
        return this.data;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.fieldPtr + this.access + this.clazz.hashCode() + this.name.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariFieldInfo) {
            DebugFerrariFieldInfo other = (DebugFerrariFieldInfo)o;
            return this.fieldPtr == other.fieldPtr && this.access == other.access && this.clazz.equals(other.clazz) && this.name.equals(other.name) && (this.data == null ? other.data == null : this.data.equals(other.data));
        }
        return false;
    }

    public void special(int i) {
        this.throwIfExpired();
        this.df.special(this, i);
    }
}

