/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;

abstract class DebugFerrariHeapAncestor
implements DebugHeapAncestor {
    DebugFerrari df;
    long address;
    int depth;
    int stoppedCount;
    DebugFerrariDataCompositeInfo data;

    DebugFerrariHeapAncestor(DebugFerrari df, long address) {
        this.df = df;
        this.address = address;
        this.stoppedCount = df.stoppedCount;
    }

    void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public long getAddress() {
        return this.address;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    protected void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("HeapAncestor has expired");
        }
    }

    public DebugDataCompositeInfo getDataInfo() {
        if (this.data != null) {
            return this.data;
        }
        this.throwIfExpired();
        if (this.data == null) {
            this.data = this.df.getObjectFromAddress(this.address);
        }
        return this.data;
    }

    public int hashCode() {
        return (int)this.address;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariHeapAncestor) {
            DebugFerrariHeapAncestor other = (DebugFerrariHeapAncestor)o;
            return this.df.equals(other.df) && this.address == other.address;
        }
        return false;
    }
}

