/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;

final class DebugFerrariHeapInfo
implements DebugHeapInfo {
    DebugFerrari df;
    DebugHeapSubset subset;
    int stoppedCount;
    DebugFerrariHeapAncestorOutsideHeap[] heapAncestorsOutsideHeap;
    long[] heapAddresses;
    int[] depths;
    DebugFerrariHeapAncestorInsideHeap[] heapAncestorsInsideHeap;
    private int hashCode;

    DebugFerrariHeapInfo(DebugFerrari df, DebugHeapSubset subset, DebugFerrariHeapAncestorOutsideHeap[] heapAncestorsOutsideHeap, long[] heapAddresses, int[] depths) {
        this.df = df;
        this.subset = subset;
        this.stoppedCount = df.stoppedCount;
        this.heapAddresses = heapAddresses;
        this.depths = depths;
        ArrayList<DebugFerrariHeapAncestorOutsideHeap> temp = new ArrayList<DebugFerrariHeapAncestorOutsideHeap>();
        int maxDepth = -1;
        if (subset instanceof DebugHeapSubsetAncestors) {
            maxDepth = ((DebugHeapSubsetAncestors)subset).getDepth();
        }
        int length = heapAncestorsOutsideHeap.length;
        int i = 0;
        while (i < length) {
            DebugFerrariHeapAncestorOutsideHeap ancestor = heapAncestorsOutsideHeap[i];
            long address = ancestor.getAddress();
            int depth = this.getDepth(address) + 1;
            if (maxDepth == -1 || depth <= maxDepth) {
                ancestor.setDepth(depth);
                temp.add(ancestor);
            }
            ++i;
        }
        this.heapAncestorsOutsideHeap = temp.toArray(new DebugFerrariHeapAncestorOutsideHeap[temp.size()]);
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("HeapInfo has expired");
        }
    }

    public DebugHeapAncestorOutsideHeap[] getAncestorsOutsideHeap() {
        return this.heapAncestorsOutsideHeap;
    }

    public DebugHeapAncestorInsideHeap[] getAncestorsInsideHeap() {
        if (this.heapAncestorsInsideHeap == null) {
            if (this.subset instanceof DebugHeapSubsetAncestors) {
                int length = this.heapAddresses.length;
                if (this.depths != null && this.depths.length == length) {
                    1HeapAddressAndDepth[] a = new 1HeapAddressAndDepth[this.heapAddresses.length];
                    int i = 0;
                    while (i < length) {
                        a[i] = new 1HeapAddressAndDepth(this.heapAddresses[i], this.depths[i]);
                        ++i;
                    }
                    Arrays.sort(a, new 1());
                    this.heapAncestorsInsideHeap = new DebugFerrariHeapAncestorInsideHeap[length];
                    int i2 = 0;
                    while (i2 < length) {
                        this.heapAncestorsInsideHeap[i2] = new DebugFerrariHeapAncestorInsideHeap(this.df, a[i2].heapAddress);
                        this.heapAncestorsInsideHeap[i2].setDepth(a[i2].depth);
                        ++i2;
                    }
                } else {
                    this.heapAncestorsInsideHeap = new DebugFerrariHeapAncestorInsideHeap[0];
                }
            } else {
                this.heapAncestorsInsideHeap = new DebugFerrariHeapAncestorInsideHeap[0];
            }
        }
        return this.heapAncestorsInsideHeap;
    }

    public long[] getHeapAddresses() {
        return this.heapAddresses;
    }

    public int[] getHeapAncestorDepths() {
        return this.depths;
    }

    public int getDepth(long address) {
        if (this.subset instanceof DebugHeapSubsetAncestors) {
            int index;
            long searchedAddress = ((DebugHeapSubsetAncestors)this.subset).getAddress();
            if (address == searchedAddress) {
                return 0;
            }
            if (this.depths != null && (index = Arrays.binarySearch(this.heapAddresses, address)) >= 0) {
                return this.depths[index];
            }
        }
        return -1;
    }

    public int getDepth(DebugDataCompositeInfo data) {
        return this.getDepth(data.getAddressOfObject());
    }

    public DebugHeapObjectInfo[] getHeapObjects(int start, int count) {
        this.throwIfExpired();
        if (start == 0 && count == 0) {
            count = this.heapAddresses.length;
        }
        if (start + count > this.heapAddresses.length) {
            count = this.heapAddresses.length - start;
        }
        return this.df.getHeapObjects(this.heapAddresses, start, count);
    }

    public int countHeapObjects() {
        return this.heapAddresses.length;
    }

    public DebugHeapSubset getHeapSubset() {
        return this.subset;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this.subset != null) {
            this.hashCode = this.subset.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariHeapInfo) {
            DebugFerrariHeapInfo other = (DebugFerrariHeapInfo)o;
            return this.df.equals(other.df) && (this.subset == null ? other.subset == null : this.subset.equals(other.subset));
        }
        return false;
    }

    class 1HeapAddressAndDepth {
        long heapAddress;
        int depth;

        1HeapAddressAndDepth(long heapAddress, int depth) {
            this.heapAddress = heapAddress;
            this.depth = depth;
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return ((1HeapAddressAndDepth)o1).depth - ((1HeapAddressAndDepth)o2).depth;
        }
    }
}

