/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.ModelUtil;
import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariClassInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataCompositeInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataInfo;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariDataPrimitiveInfo;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDisassembleInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public final class DebugFerrariMethodInfo
implements DebugMethodInfo {
    private static final int ACC_COMPILED = 0x10000000;
    DebugFerrari df;
    int stoppedCount;
    long methodPtr;
    DebugFerrariClassInfo clazz;
    int access;
    String name;
    int[] range;
    private SoftReference sfLocationsCache;
    private int hashCode;

    DebugFerrariMethodInfo(DebugFerrari df, long methodPtr, DebugFerrariClassInfo clazz, int access, String name) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.methodPtr = methodPtr;
        this.clazz = clazz;
        this.access = access;
        this.name = name;
    }

    public DebugVirtualMachine getVM() {
        return this.df;
    }

    public boolean hasExpired() {
        if (this.df.stoppedCount != this.stoppedCount && !this.clazz.hasExpired()) {
            this.updateMethod();
        }
        return this.df.stoppedCount != this.stoppedCount;
    }

    void updateMethod() {
        this.updateMethod(this.df.getMethodAccess(this));
    }

    void updateMethod(int access) {
        this.access = access;
        this.stoppedCount = this.df.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Method has expired");
        }
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public boolean isCompiled() {
        this.hasExpired();
        return (this.access & 0x10000000) != 0;
    }

    public String getName() {
        this.hasExpired();
        return this.name;
    }

    public String getNameWithoutClass() {
        this.hasExpired();
        return DebugShared.getNameWithoutClass(this.name);
    }

    public String getNameWithoutSignature() {
        this.hasExpired();
        return DebugShared.getNameWithoutSignature(this.name);
    }

    public String getNameWithoutClassOrSignature() {
        this.hasExpired();
        return DebugShared.getNameWithoutClassOrSignature(this.name);
    }

    public String getParameterSignature() {
        this.hasExpired();
        return DebugShared.getMethodParameterSignature(this.name);
    }

    public int getAccess() {
        this.hasExpired();
        return this.access;
    }

    public int[] getMethodLineRange() {
        this.throwIfExpired();
        if (this.range == null) {
            this.range = this.df.getMethodLineRange(this);
        }
        return this.range;
    }

    public int[] getMethodLines() {
        this.throwIfExpired();
        return this.df.getMethodLines(this);
    }

    public int[] getCodeCoverage() {
        this.throwIfExpired();
        return this.df.getMethodCodeCoverage(this);
    }

    public double getCodeCoverageRatio() {
        this.throwIfExpired();
        return this.df.getMethodCodeCoverageRatio(this);
    }

    private IntHashMap getLocationsCache() {
        IntHashMap locationsCache;
        if (this.sfLocationsCache != null && (locationsCache = (IntHashMap)this.sfLocationsCache.get()) != null) {
            return locationsCache;
        }
        locationsCache = new IntHashMap();
        this.sfLocationsCache = new SoftReference<IntHashMap>(locationsCache);
        return locationsCache;
    }

    public DebugLocation getFirstLocation() {
        this.throwIfExpired();
        return this.df.getMethodLocation(this, null, 0);
    }

    public DebugLocation getLocation(String filename, int line) {
        this.throwIfExpired();
        IntHashMap locationsCache = null;
        if (ModelUtil.areEqual((Object)filename, (Object)this.clazz.getSourceFilename()) && line != 0) {
            locationsCache = this.getLocationsCache();
        }
        if (locationsCache != null) {
            Object o = locationsCache.get(line);
            if (o == Boolean.FALSE) {
                return null;
            }
            if (o != null) {
                return (DebugLocation)o;
            }
        }
        DebugLocation location = this.df.getMethodLocation(this, filename, line);
        if (locationsCache != null) {
            if (location == null) {
                locationsCache.put(line, (Object)Boolean.FALSE);
            } else {
                locationsCache.put(line, (Object)location);
            }
        }
        return location;
    }

    public DebugDisassembleInfo[] disassembleMethod(boolean java, boolean bytecode, boolean assembly, Project project) {
        this.throwIfExpired();
        int options = 0;
        if (java) {
            options |= 1;
        }
        if (bytecode) {
            options |= 2;
        }
        if (assembly) {
            options |= 4;
        }
        return this.df.disassembleMethod(this, options);
    }

    public boolean hasMethodChanged() {
        this.throwIfExpired();
        return this.df.hasMethodChanged(this);
    }

    public byte[] getBytecodes() {
        this.throwIfExpired();
        return this.df.getMethodBytecodes(this);
    }

    public byte getBytecode(int offset) {
        this.throwIfExpired();
        return this.df.getMethodBytecode(this, offset);
    }

    private Object[] makeArgArray(String invokeSig, List arguments, List pins) {
        int length = invokeSig.length();
        if (arguments.size() == length) {
            Object[] argArray = new Object[length];
            try {
                int i = 0;
                while (i < length) {
                    Object o = arguments.get(i);
                    char ch = invokeSig.charAt(i);
                    switch (ch) {
                        case 'Z': {
                            if (o instanceof Boolean) {
                                argArray[i] = o;
                                break;
                            }
                            if (o instanceof DebugFerrariDataPrimitiveInfo) {
                                argArray[i] = ((DebugFerrariDataPrimitiveInfo)o).promoteValue(ch);
                                break;
                            }
                            throw new Exception("bad boolean");
                        }
                        case 'B': {
                            if (o instanceof Byte) {
                                argArray[i] = o;
                                break;
                            }
                            if (o instanceof DebugFerrariDataPrimitiveInfo) {
                                argArray[i] = ((DebugFerrariDataPrimitiveInfo)o).promoteValue(ch);
                                break;
                            }
                            throw new Exception("bad byte");
                        }
                        case 'C': {
                            if (o instanceof Character) {
                                argArray[i] = o;
                                break;
                            }
                            if (o instanceof DebugFerrariDataPrimitiveInfo) {
                                argArray[i] = ((DebugFerrariDataPrimitiveInfo)o).promoteValue(ch);
                                break;
                            }
                            throw new Exception("bad char");
                        }
                        case 'F': {
                            if (o instanceof Float) {
                                argArray[i] = o;
                                break;
                            }
                            if (o instanceof DebugFerrariDataPrimitiveInfo) {
                                argArray[i] = ((DebugFerrariDataPrimitiveInfo)o).promoteValue(ch);
                                break;
                            }
                            throw new Exception("bad float");
                        }
                        case 'I': {
                            if (o instanceof Integer) {
                                argArray[i] = o;
                                break;
                            }
                            if (o instanceof DebugFerrariDataPrimitiveInfo) {
                                argArray[i] = ((DebugFerrariDataPrimitiveInfo)o).promoteValue(ch);
                                break;
                            }
                            throw new Exception("bad int");
                        }
                        case 'S': {
                            if (o instanceof Short) {
                                argArray[i] = o;
                                break;
                            }
                            if (o instanceof DebugFerrariDataPrimitiveInfo) {
                                argArray[i] = ((DebugFerrariDataPrimitiveInfo)o).promoteValue(ch);
                                break;
                            }
                            throw new Exception("bad short");
                        }
                        case 'J': {
                            if (o instanceof Long) {
                                argArray[i] = o;
                                break;
                            }
                            if (o instanceof DebugFerrariDataPrimitiveInfo) {
                                argArray[i] = ((DebugFerrariDataPrimitiveInfo)o).promoteValue(ch);
                                break;
                            }
                            throw new Exception("bad long");
                        }
                        case 'D': {
                            if (o instanceof Double) {
                                argArray[i] = o;
                                break;
                            }
                            if (o instanceof DebugFerrariDataPrimitiveInfo) {
                                argArray[i] = ((DebugFerrariDataPrimitiveInfo)o).promoteValue(ch);
                                break;
                            }
                            throw new Exception("bad double");
                        }
                        case 'L': {
                            if (o == null) {
                                argArray[i] = null;
                                break;
                            }
                            if (o instanceof String) {
                                argArray[i] = this.df.createString((String)o);
                                if (!(argArray[i] instanceof DebugFerrariDataCompositeInfo) || !this.df.pinUnpin((DebugFerrariDataCompositeInfo)argArray[i], true)) break;
                                pins.add(argArray[i]);
                                break;
                            }
                            if (o instanceof DebugFerrariDataCompositeInfo) {
                                argArray[i] = o;
                                break;
                            }
                            throw new Exception("bad object");
                        }
                        case '[': {
                            if (o == null) {
                                argArray[i] = null;
                                break;
                            }
                            if (o instanceof DebugFerrariDataCompositeInfo) {
                                argArray[i] = o;
                                break;
                            }
                            throw new Exception("bad array");
                        }
                    }
                    ++i;
                }
                Object[] objectArray = argArray;
                return objectArray;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public DebugDataInfo invoke(List arguments) {
        this.throwIfExpired();
        DebugFerrariDataInfo result = null;
        String invokeSig = this.df.getInvokeSignature(this);
        if (invokeSig != null) {
            ArrayList pins = new ArrayList();
            this.df.pinAllReferences(pins);
            Object[] argArray = this.makeArgArray(invokeSig, arguments, pins);
            if (argArray != null) {
                result = this.df.invokeMethod(this, argArray);
            }
            this.df.unpinAll(pins);
        }
        return result;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.methodPtr;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariMethodInfo) {
            DebugFerrariMethodInfo other = (DebugFerrariMethodInfo)o;
            if (!this.clazz.hasExpired()) {
                return !other.clazz.hasExpired() && this.methodPtr == other.methodPtr;
            }
            return this.clazz.equals(other.clazz) && this.methodPtr == other.methodPtr && this.access == other.access && this.name.equals(other.name);
        }
        return false;
    }

    public void special(int i) {
        this.throwIfExpired();
        this.df.special(this, i);
    }
}

