/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.ferrari;

import oracle.jdevimpl.debugger.ferrari.DebugFerrari;
import oracle.jdevimpl.debugger.ferrari.DebugFerrariThreadInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;

public final class DebugFerrariMonitorInfo
implements DebugMonitorInfo {
    private static int MK_CLASS_MONITOR = 0;
    private static int MK_INSTANCE_MONITOR = 1;
    DebugFerrari df;
    int stoppedCount;
    long monitorPtr;
    int kind;
    int entryCount;
    int waiterCount;
    DebugFerrariThreadInfo owner;
    private int hashCode;

    DebugFerrariMonitorInfo(DebugFerrari df, long monitorPtr, int kind, int entryCount, int waiterCount, DebugFerrariThreadInfo owner) {
        this.df = df;
        this.stoppedCount = df.stoppedCount;
        this.monitorPtr = monitorPtr;
        this.kind = kind;
        this.entryCount = entryCount;
        this.waiterCount = waiterCount;
        this.owner = owner;
    }

    void copyFrom(DebugFerrariMonitorInfo other) {
        this.monitorPtr = other.monitorPtr;
        this.kind = other.kind;
        this.entryCount = other.entryCount;
        this.waiterCount = other.waiterCount;
        this.owner = other.owner;
    }

    public boolean hasExpired() {
        return this.df.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new IllegalStateException("MonitorInfo has expired");
        }
    }

    public boolean isClassMonitor() {
        return this.kind == MK_CLASS_MONITOR;
    }

    public boolean isInstanceMonitor() {
        return this.kind == MK_INSTANCE_MONITOR;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public int getWaiterCount() {
        return this.waiterCount;
    }

    public DebugThreadInfo getOwnerThread() {
        return this.owner;
    }

    public DebugThreadInfo[] listWaitingThreads() {
        this.throwIfExpired();
        return this.df.listWaitingThreads(this);
    }

    public DebugThreadInfo[] listBlockedThreads() {
        this.throwIfExpired();
        return this.df.listBlockedThreads(this);
    }

    public DebugDataCompositeInfo getAssociatedObject() {
        this.throwIfExpired();
        return this.df.getObjectAssociatedWithMonitor(this);
    }

    public DebugLocation getEntryLocation() {
        this.throwIfExpired();
        return this.df.getMonitorEntryLocation(this);
    }

    public boolean canDoNotify() {
        return this.df.canDoMonitorNotify();
    }

    public void doNotify() {
        this.df.doMonitorNotify(this, false);
    }

    public void doNotifyAll() {
        this.df.doMonitorNotify(this, true);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.monitorPtr;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugFerrariMonitorInfo) {
            DebugFerrariMonitorInfo other = (DebugFerrariMonitorInfo)o;
            return this.monitorPtr == other.monitorPtr;
        }
        return false;
    }

    public void special(int i) {
        this.throwIfExpired();
        this.df.special(this, i);
    }
}

